/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util.rb_trees;

import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.uima.internal.util.ComparableIntIterator;
import org.apache.uima.internal.util.ComparableIntPointerIterator;
import org.apache.uima.internal.util.IntArrayUtils;
import org.apache.uima.internal.util.IntComparator;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.IntPointerIterator;
import org.apache.uima.internal.util.StringUtils;

public class IntArrayRBT {
    protected int[] key;
    protected int[] left;
    protected int[] right;
    protected int[] parent;
    protected boolean[] color;
    private int next;
    private int size;
    protected int root;
    protected int greatestNode;
    protected static final int default_size = 1024;
    private static final int default_growth_factor = 2;
    private static final int default_multiplication_limit = 2000000;
    private int growth_factor;
    private int multiplication_limit;
    public static final int NIL = 0;
    protected static final boolean red = true;
    protected static final boolean black = false;
    protected final Random rand = new Random();

    public IntArrayRBT() {
        this(1024);
    }

    public IntArrayRBT(int initialSize) {
        if (initialSize < 1) {
            initialSize = 1;
        }
        this.initVars();
        this.growth_factor = 2;
        this.multiplication_limit = 2000000;
        this.key = new int[++initialSize];
        this.left = new int[initialSize];
        this.right = new int[initialSize];
        this.parent = new int[initialSize];
        this.color = new boolean[initialSize];
        this.left[0] = 0;
        this.right[0] = 0;
        this.parent[0] = 0;
        this.color[0] = false;
    }

    private void initVars() {
        this.root = 0;
        this.greatestNode = 0;
        this.next = 1;
        this.size = 0;
    }

    public void flush() {
        this.initVars();
    }

    public final int size() {
        return this.size;
    }

    private void grow(int initialSize) {
        this.key = this.grow(this.key, initialSize);
        this.left = this.grow(this.left, initialSize);
        this.right = this.grow(this.right, initialSize);
        this.parent = this.grow(this.parent, initialSize);
        this.color = this.grow(this.color, initialSize);
    }

    public int getKeyForNode(int node) {
        return this.key[node];
    }

    protected int treeInsert(int k) {
        int z;
        int y;
        int x2 = this.root;
        if (this.greatestNode != 0 && this.key[this.greatestNode] < k) {
            y = this.greatestNode;
            this.greatestNode = z = this.newNode(k);
        } else {
            y = 0;
            while (x2 != 0) {
                y = x2;
                int xKey = this.key[x2];
                if (k < xKey) {
                    x2 = this.left[x2];
                    continue;
                }
                if (k == xKey) {
                    return -x2;
                }
                x2 = this.right[x2];
            }
            z = this.newNode(k);
        }
        if (y == 0) {
            this.setAsRoot(z);
            this.greatestNode = z;
            this.parent[z] = 0;
        } else {
            this.parent[z] = y;
            if (k < this.key[y]) {
                this.left[y] = z;
            } else {
                this.right[y] = z;
            }
        }
        return z;
    }

    protected int treeInsertWithDups(int k) {
        int x2 = this.root;
        if (this.greatestNode != 0 && this.key[this.greatestNode] <= k) {
            int z;
            int y = this.greatestNode;
            this.greatestNode = z = this.newNode(k);
            this.right[y] = z;
            this.parent[z] = y;
            return z;
        }
        int y = 0;
        while (x2 != 0) {
            y = x2;
            int xKey = this.key[x2];
            if (k < xKey) {
                x2 = this.left[x2];
                continue;
            }
            if (k > xKey) {
                x2 = this.right[x2];
                continue;
            }
            if (this.rand.nextBoolean()) {
                x2 = this.left[x2];
                continue;
            }
            x2 = this.right[x2];
        }
        int z = this.newNode(k);
        if (y == 0) {
            this.setAsRoot(z);
            this.greatestNode = z;
            this.parent[z] = 0;
        } else {
            this.parent[z] = y;
            if (k < this.key[y]) {
                this.left[y] = z;
            } else if (k > this.key[y]) {
                this.right[y] = z;
            } else if (this.rand.nextBoolean()) {
                this.left[y] = z;
            } else {
                this.right[y] = z;
            }
        }
        return z;
    }

    protected int newNode(int k) {
        if (this.next >= this.key.length) {
            this.grow(this.next + 1);
        }
        int z = this.next++;
        ++this.size;
        this.key[z] = k;
        this.left[z] = 0;
        this.right[z] = 0;
        this.color[z] = true;
        return z;
    }

    private final void setAsRoot(int x2) {
        this.root = x2;
        this.parent[this.root] = 0;
    }

    private final int[] grow(int[] array, int newSize) {
        return IntArrayUtils.ensure_size(array, newSize, this.growth_factor, this.multiplication_limit);
    }

    private final boolean[] grow(boolean[] array, int newSize) {
        return IntArrayUtils.ensure_size(array, newSize, this.growth_factor, this.multiplication_limit);
    }

    private final void leftRotate(int x2) {
        int y = this.right[x2];
        this.right[x2] = this.left[y];
        if (this.left[y] != 0) {
            this.parent[this.left[y]] = x2;
        }
        this.parent[y] = this.parent[x2];
        if (this.root == x2) {
            this.setAsRoot(y);
        } else if (x2 == this.left[this.parent[x2]]) {
            this.left[this.parent[x2]] = y;
        } else {
            this.right[this.parent[x2]] = y;
        }
        this.left[y] = x2;
        this.parent[x2] = y;
    }

    private final void rightRotate(int x2) {
        int y = this.left[x2];
        this.left[x2] = this.right[y];
        if (this.right[y] != 0) {
            this.parent[this.right[y]] = x2;
        }
        this.parent[y] = this.parent[x2];
        if (this.root == x2) {
            this.setAsRoot(y);
        } else if (x2 == this.right[this.parent[x2]]) {
            this.right[this.parent[x2]] = y;
        } else {
            this.left[this.parent[x2]] = y;
        }
        this.right[y] = x2;
        this.parent[x2] = y;
    }

    public int insertKey(int k) {
        return this.insertKey(k, false);
    }

    public int insertKeyWithDups(int k) {
        return this.insertKey(k, true);
    }

    private int insertKey(int k, boolean withDups) {
        int x2;
        if (this.root == 0) {
            int x3 = this.newNode(k);
            this.setAsRoot(x3);
            this.color[this.root] = false;
            this.greatestNode = x3;
            return x3;
        }
        if (withDups) {
            x2 = this.treeInsertWithDups(k);
        } else {
            x2 = this.treeInsert(k);
            if (x2 < 0) {
                return -x2;
            }
        }
        this.color[x2] = true;
        int node = x2;
        while (x2 != this.root && this.color[this.parent[x2]]) {
            int y;
            if (this.parent[x2] == this.left[this.parent[this.parent[x2]]]) {
                y = this.right[this.parent[this.parent[x2]]];
                if (this.color[y]) {
                    this.color[this.parent[x2]] = false;
                    this.color[y] = false;
                    this.color[this.parent[this.parent[x2]]] = true;
                    x2 = this.parent[this.parent[x2]];
                    continue;
                }
                if (x2 == this.right[this.parent[x2]]) {
                    x2 = this.parent[x2];
                    this.leftRotate(x2);
                }
                this.color[this.parent[x2]] = false;
                this.color[this.parent[this.parent[x2]]] = true;
                this.rightRotate(this.parent[this.parent[x2]]);
                continue;
            }
            y = this.left[this.parent[this.parent[x2]]];
            if (this.color[y]) {
                this.color[this.parent[x2]] = false;
                this.color[y] = false;
                this.color[this.parent[this.parent[x2]]] = true;
                x2 = this.parent[this.parent[x2]];
                continue;
            }
            if (x2 == this.left[this.parent[x2]]) {
                x2 = this.parent[x2];
                this.rightRotate(x2);
            }
            this.color[this.parent[x2]] = false;
            this.color[this.parent[this.parent[x2]]] = true;
            this.leftRotate(this.parent[this.parent[x2]]);
        }
        this.color[this.root] = false;
        return node;
    }

    public int findKey(int k) {
        int node = this.root;
        while (node != 0) {
            if (k < this.key[node]) {
                node = this.left[node];
                continue;
            }
            if (k == this.key[node]) {
                return node;
            }
            node = this.right[node];
        }
        return 0;
    }

    public int findInsertionPoint(int k) {
        int node;
        int found = node = this.root;
        while (node != 0) {
            found = node;
            if (k < this.key[node]) {
                node = this.left[node];
                continue;
            }
            if (k == this.key[node]) {
                while (this.left[node] != 0 && this.key[this.left[node]] == this.key[node]) {
                    node = this.left[node];
                }
                return node;
            }
            node = this.right[node];
        }
        return found;
    }

    public int findInsertionPointNoDups(int k) {
        int node;
        int found = node = this.root;
        while (node != 0) {
            found = node;
            if (k < this.key[node]) {
                node = this.left[node];
                continue;
            }
            if (k == this.key[node]) {
                return node;
            }
            node = this.right[node];
        }
        return found;
    }

    public final boolean containsKey(int k) {
        return this.findKey(k) != 0;
    }

    private final boolean isLeftDtr(int node) {
        return node != this.root && node == this.left[this.parent[node]];
    }

    private final int getFirstNode() {
        if (this.root == 0) {
            return 0;
        }
        int node = this.root;
        while (this.left[node] != 0) {
            node = this.left[node];
        }
        return node;
    }

    protected final int nextNode(int node) {
        if (this.right[node] != 0) {
            node = this.right[node];
            while (this.left[node] != 0) {
                node = this.left[node];
            }
        } else {
            int y = this.parent[node];
            while (y != 0 && node == this.right[y]) {
                node = y;
                y = this.parent[y];
            }
            node = y;
        }
        return node;
    }

    private final int previousNode(int node) {
        if (this.left[node] != 0) {
            node = this.left[node];
            while (this.right[node] != 0) {
                node = this.right[node];
            }
        } else {
            while (this.isLeftDtr(node)) {
                node = this.parent[node];
            }
            if (node == this.root) {
                return 0;
            }
            node = this.parent[node];
        }
        return node;
    }

    public boolean deleteKey(int aKey) {
        int node = this.findKey(aKey);
        if (node == 0) {
            return false;
        }
        this.deleteNode(node);
        --this.size;
        return true;
    }

    private void deleteNode(int z) {
        int y = this.left[z] == 0 || this.right[z] == 0 ? z : this.nextNode(z);
        int x2 = this.left[y] != 0 ? this.left[y] : this.right[y];
        this.parent[x2] = this.parent[y];
        if (this.parent[y] == 0) {
            this.setAsRoot(x2);
        } else if (y == this.left[this.parent[y]]) {
            this.left[this.parent[y]] = x2;
        } else {
            this.right[this.parent[y]] = x2;
        }
        if (y != z) {
            this.key[z] = this.key[y];
        }
        if (!this.color[y]) {
            this.deleteFixup(x2);
        }
    }

    private void deleteFixup(int x2) {
        while (x2 != this.root && !this.color[x2]) {
            int w;
            if (x2 == this.left[this.parent[x2]]) {
                w = this.right[this.parent[x2]];
                if (this.color[w]) {
                    this.color[w] = false;
                    this.color[this.parent[x2]] = true;
                    this.leftRotate(this.parent[x2]);
                    w = this.right[this.parent[x2]];
                }
                if (!this.color[this.left[w]] && !this.color[this.right[w]]) {
                    this.color[w] = true;
                    x2 = this.parent[x2];
                    continue;
                }
                if (!this.color[this.right[w]]) {
                    this.color[this.left[w]] = false;
                    this.color[w] = true;
                    this.rightRotate(w);
                    w = this.right[this.parent[x2]];
                }
                this.color[w] = this.color[this.parent[x2]];
                this.color[this.parent[x2]] = false;
                this.color[this.right[w]] = false;
                this.leftRotate(this.parent[x2]);
                x2 = this.root;
                continue;
            }
            w = this.left[this.parent[x2]];
            if (this.color[w]) {
                this.color[w] = false;
                this.color[this.parent[x2]] = true;
                this.rightRotate(this.parent[x2]);
                w = this.left[this.parent[x2]];
            }
            if (!this.color[this.left[w]] && !this.color[this.right[w]]) {
                this.color[w] = true;
                x2 = this.parent[x2];
                continue;
            }
            if (!this.color[this.left[w]]) {
                this.color[this.right[w]] = false;
                this.color[w] = true;
                this.leftRotate(w);
                w = this.left[this.parent[x2]];
            }
            this.color[w] = this.color[this.parent[x2]];
            this.color[this.parent[x2]] = false;
            this.color[this.left[w]] = false;
            this.rightRotate(this.parent[x2]);
            x2 = this.root;
        }
        this.color[x2] = false;
    }

    public ComparableIntIterator iterator(IntComparator comp) {
        return new ComparableIterator(comp);
    }

    public IntListIterator iterator() {
        return new IntArrayRBTKeyIterator();
    }

    public IntPointerIterator pointerIterator() {
        return new PointerIterator();
    }

    public IntPointerIterator pointerIterator(int aKey) {
        PointerIterator it = new PointerIterator();
        it.currentNode = this.findKey(aKey);
        return it;
    }

    public ComparableIntPointerIterator pointerIterator(IntComparator comp, int[] detectIllegalIndexUpdates, int typeCode) {
        ComparablePointerIterator cpi = new ComparablePointerIterator(comp);
        cpi.modificationSnapshot = detectIllegalIndexUpdates[typeCode];
        ComparablePointerIterator.access$602(cpi, detectIllegalIndexUpdates);
        cpi.typeCode = typeCode;
        return cpi;
    }

    public boolean satisfiesRedBlackProperties() {
        int node = this.root;
        int blackDepth = 0;
        while (node != 0) {
            if (!this.color[node]) {
                ++blackDepth;
            }
            node = this.left[node];
        }
        return this.satisfiesRBProps(this.root, blackDepth, 0);
    }

    private boolean satisfiesRBProps(int node, int blackDepth, int currentBlack) {
        if (node == 0) {
            return currentBlack == blackDepth;
        }
        if (this.color[node]) {
            if (this.color[this.left[node]] || this.color[this.right[node]]) {
                return false;
            }
        } else {
            ++currentBlack;
        }
        return this.satisfiesRBProps(this.left[node], blackDepth, currentBlack) && this.satisfiesRBProps(this.right[node], blackDepth, currentBlack);
    }

    public int maxDepth() {
        return this.maxDepth(this.root, 0);
    }

    public int minDepth() {
        return this.minDepth(this.root, 0);
    }

    public int nodeDepth(int k) {
        return this.nodeDepth(this.root, 1, k);
    }

    private int nodeDepth(int node, int depth, int k) {
        if (node == 0) {
            return -1;
        }
        if (k == this.key[node]) {
            return depth;
        }
        if (k < this.key[node]) {
            return this.nodeDepth(this.left[node], depth + 1, k);
        }
        return this.nodeDepth(this.right[node], depth + 1, k);
    }

    private int maxDepth(int node, int depth) {
        int depth2;
        if (node == 0) {
            return depth;
        }
        int depth1 = this.maxDepth(this.left[node], depth + 1);
        return depth1 > (depth2 = this.maxDepth(this.right[node], depth + 1)) ? depth1 : depth2;
    }

    private int minDepth(int node, int depth) {
        int depth2;
        if (node == 0) {
            return depth;
        }
        int depth1 = this.maxDepth(this.left[node], depth + 1);
        return depth1 > (depth2 = this.maxDepth(this.right[node], depth + 1)) ? depth2 : depth1;
    }

    public final void printKeys() {
        if (this.size() == 0) {
            System.out.println("Tree is empty.");
            return;
        }
        StringBuffer buf = new StringBuffer();
        this.printKeys(this.root, 0, buf);
        System.out.println(buf);
    }

    private final void printKeys(int node, int offset, StringBuffer buf) {
        if (node == 0) {
            return;
        }
        StringUtils.printSpaces(offset, buf);
        buf.append(Integer.toString(this.key[node]));
        if (!this.color[node]) {
            buf.append(" BLACK");
        }
        buf.append("\n");
        this.printKeys(this.left[node], offset + 2, buf);
        this.printKeys(this.right[node], offset + 2, buf);
    }

    public static void main(String[] args) {
        System.out.println("Constructing tree.");
        IntArrayRBT tree = new IntArrayRBT();
        tree.insertKeyWithDups(2);
        tree.insertKeyWithDups(1);
    }

    private class ComparableIterator
    extends IntArrayRBTKeyIterator
    implements ComparableIntIterator {
        private final IntComparator comparator;

        private ComparableIterator(IntComparator comp) {
            this.comparator = comp;
        }

        public int compareTo(Object o) {
            ComparableIterator it = (ComparableIterator)o;
            return this.comparator.compare(IntArrayRBT.this.key[this.currentNode], it.getKey(it.currentNode));
        }
    }

    private class IntArrayRBTKeyIterator
    implements IntListIterator {
        protected int currentNode = 0;

        protected IntArrayRBTKeyIterator() {
        }

        public final boolean hasNext() {
            return this.currentNode != IntArrayRBT.this.greatestNode;
        }

        public final int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentNode = IntArrayRBT.this.nextNode(this.currentNode);
            return IntArrayRBT.this.key[this.currentNode];
        }

        public boolean hasPrevious() {
            return this.currentNode != 0;
        }

        public int previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            int currentKey = IntArrayRBT.this.key[this.currentNode];
            this.currentNode = this.currentNode == IntArrayRBT.this.getFirstNode() ? 0 : IntArrayRBT.this.previousNode(this.currentNode);
            return currentKey;
        }

        public void moveToEnd() {
            this.currentNode = IntArrayRBT.this.greatestNode;
        }

        public void moveToStart() {
            this.currentNode = 0;
        }

        protected final int getKey(int node) {
            return IntArrayRBT.this.key[node];
        }
    }

    private class PointerIterator
    implements IntPointerIterator {
        protected int currentNode;

        private PointerIterator() {
            this.moveToFirst();
        }

        public void dec() {
            this.currentNode = IntArrayRBT.this.previousNode(this.currentNode);
        }

        public int get() {
            if (!this.isValid()) {
                throw new NoSuchElementException();
            }
            return IntArrayRBT.this.key[this.currentNode];
        }

        public void inc() {
            this.currentNode = IntArrayRBT.this.nextNode(this.currentNode);
        }

        public boolean isValid() {
            return this.currentNode != 0;
        }

        public void moveToFirst() {
            this.currentNode = IntArrayRBT.this.getFirstNode();
        }

        public void moveToLast() {
            this.currentNode = IntArrayRBT.this.greatestNode;
        }

        public Object copy() {
            PointerIterator it = new PointerIterator();
            it.currentNode = this.currentNode;
            return it;
        }

        public void moveTo(int i) {
            this.currentNode = IntArrayRBT.this.findInsertionPoint(i);
        }
    }

    private class ComparablePointerIterator
    extends PointerIterator
    implements ComparableIntPointerIterator {
        private final IntComparator comp;
        private int modificationSnapshot;
        private int[] detectIllegalIndexUpdates;
        private int typeCode;

        public boolean isConcurrentModification() {
            return this.modificationSnapshot != this.detectIllegalIndexUpdates[this.typeCode];
        }

        public void resetConcurrentModification() {
            this.modificationSnapshot = this.detectIllegalIndexUpdates[this.typeCode];
        }

        private ComparablePointerIterator(IntComparator comp) {
            this.comp = comp;
        }

        public int compareTo(Object o) throws NoSuchElementException {
            ComparableIntPointerIterator it = (ComparableIntPointerIterator)o;
            return this.comp.compare(this.get(), it.get());
        }

        public Object copy() {
            ComparablePointerIterator copy = new ComparablePointerIterator(this.comp);
            copy.currentNode = this.currentNode;
            return copy;
        }

        static /* synthetic */ int[] access$602(ComparablePointerIterator x0, int[] x1) {
            x0.detectIllegalIndexUpdates = x1;
            return x1;
        }
    }
}

