/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.uima.util.FileUtils;

public class ReplaceStringInFiles {
    private static DirFileFilter dirFileFilter = new DirFileFilter();

    public static int indexOfCaseSensitive(String mainStr, String argStr, int start, boolean caseSensitive) {
        if (caseSensitive) {
            return mainStr.indexOf(argStr, start);
        }
        String source = mainStr.toLowerCase();
        String pattern = argStr.toLowerCase();
        int index = source.indexOf(pattern, start);
        return index;
    }

    public static final void replaceStringInString(String text2, String toReplace, String replacement, ReplacementResult res, boolean caseSensitive) {
        int next2;
        StringBuffer buf = new StringBuffer();
        int current = 0;
        int count2 = 0;
        while ((next2 = ReplaceStringInFiles.indexOfCaseSensitive(text2, toReplace, current, caseSensitive)) >= 0) {
            buf.append(text2.substring(current, next2));
            buf.append(replacement);
            current = next2 + toReplace.length();
            ++count2;
        }
        buf.append(text2.substring(current, text2.length()));
        res.outString = buf.toString();
        res.numReplaced = count2;
    }

    public static final void replaceStringInFiles(File dir2, FileFilter fileFilter, String toReplace, String replacement, boolean caseSensitive) throws IOException {
        int i;
        File[] fileList = null;
        fileList = fileFilter == null ? dir2.listFiles() : dir2.listFiles(fileFilter);
        ReplacementResult result2 = new ReplacementResult();
        for (i = 0; i < fileList.length; ++i) {
            File file = fileList[i];
            if (!file.isFile()) continue;
            if (!file.canRead()) {
                System.err.println("Warning, can't read file: " + file.getAbsolutePath());
                continue;
            }
            if (!file.canWrite()) {
                System.err.println("Warning, can't write file: " + file.getAbsolutePath());
                continue;
            }
            System.out.println("Working on file: " + file.getAbsolutePath());
            String fileContents = FileUtils.file2String(file);
            ReplaceStringInFiles.replaceStringInString(fileContents, toReplace, replacement, result2, caseSensitive);
            fileContents = result2.outString;
            if (result2.numReplaced <= 0) continue;
            FileUtils.saveString2File(fileContents, file);
            System.out.println("File modified, number of instances replaced: " + result2.numReplaced);
        }
        fileList = dir2.listFiles(dirFileFilter);
        for (i = 0; i < fileList.length; ++i) {
            ReplaceStringInFiles.replaceStringInFiles(fileList[i], fileFilter, toReplace, replacement, caseSensitive);
        }
    }

    public static void main(String[] args) {
        if (args.length != 4 && args.length != 5) {
            System.out.println("Usage: java org.apache.uima.util.ReplaceStringInFile <Dir> <Extension> <ToReplace> <Replacement> [-ignorecase]");
            System.exit(1);
        }
        try {
            String dirName = args[0];
            String extension = args[1];
            String toReplace = args[2];
            String replacement = args[3];
            boolean caseSensitive = false;
            if (args.length >= 5) {
                boolean bl = caseSensitive = args[4].compareToIgnoreCase("-ignorecase") != 0;
            }
            if (caseSensitive) {
                System.out.println("Case sensitive");
            } else {
                System.out.println("Ignoring case");
            }
            File dir2 = new File(dirName);
            if (dir2.isDirectory()) {
                ReplaceStringInFiles.replaceStringInFiles(dir2, new ExtFileFilter(extension), toReplace, replacement, caseSensitive);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ReplacementResult {
        public String outString;
        public int numReplaced;
    }

    private static class DirFileFilter
    implements FileFilter {
        private DirFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory();
        }
    }

    private static class ExtFileFilter
    implements FileFilter {
        private String ext;

        private ExtFileFilter(String extension) {
            this.ext = extension;
        }

        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(this.ext);
        }
    }
}

