/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class EncodedPrintStream
extends PrintStream {
    private final String encoding;

    public EncodedPrintStream(OutputStream out, String encoding) throws UnsupportedEncodingException {
        this(out, false, encoding);
    }

    public EncodedPrintStream(OutputStream out, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
        super(out, autoFlush);
        this.encoding = encoding;
        "test".getBytes(encoding);
    }

    private final void writeBytes(byte[] bytes) {
        super.write(bytes, 0, bytes.length);
    }

    public void print(char c) {
        try {
            this.writeBytes(new String(new char[]{c}).getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void print(char[] s) {
        try {
            this.writeBytes(new String(s).getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void print(String s) {
        try {
            this.writeBytes(s.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void println(char x2) {
        this.print(x2);
        this.println();
    }

    public void println(char[] x2) {
        this.print(x2);
        this.println();
    }

    public void println(String x2) {
        this.print(x2);
        this.println();
    }
}

