/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.xmi;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.AllowedValue;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class UimaTypeSystem2Ecore {
    public static void uimaTypeSystem2Ecore(String aUimaTypeSystemFilePath, Resource aOutputResource, Map aOptions) throws InvalidXMLException, IOException {
        TypeSystemDescription tsDesc = UIMAFramework.getXMLParser().parseTypeSystemDescription(new XMLInputSource(aUimaTypeSystemFilePath));
        UimaTypeSystem2Ecore.uimaTypeSystem2Ecore(tsDesc, aOutputResource, aOptions);
    }

    public static void uimaTypeSystem2Ecore(TypeSystemDescription aTypeSystem, Resource aOutputResource, Map aOptions) throws InvalidXMLException {
        UimaTypeSystem2Ecore.uimaTypeSystem2Ecore(aTypeSystem, aOutputResource, aOptions, null);
    }

    public static void uimaTypeSystem2Ecore(TypeSystemDescription aTypeSystem, Resource aOutputResource, Map aOptions, Map aSchemaLocationMap) throws InvalidXMLException {
        EClassifier eclassifier;
        TypeDescription type;
        int i;
        ResourceSet resSet;
        aTypeSystem = (TypeSystemDescription)aTypeSystem.clone();
        TypeDescription docAnnotType = aTypeSystem.addType("uima.tcas.DocumentAnnotation", "", "uima.tcas.Annotation");
        docAnnotType.addFeature("language", "", "uima.cas.String");
        aTypeSystem.resolveImports();
        try {
            aTypeSystem = CasCreationUtils.mergeTypeSystems(Arrays.asList(aTypeSystem));
        }
        catch (ResourceInitializationException e) {
            throw new InvalidXMLException(e);
        }
        if (aOptions == null) {
            aOptions = Collections.EMPTY_MAP;
        }
        if ((resSet = aOutputResource.getResourceSet()) == null) {
            resSet = new ResourceSetImpl();
            resSet.getResources().add((Object)aOutputResource);
        }
        UimaTypeSystem2Ecore.loadUimaBuiltinsEcore(resSet, aSchemaLocationMap);
        TypeDescription[] types = aTypeSystem.getTypes();
        EPackage firstPackage = null;
        for (i = 0; i < types.length; ++i) {
            type = types[i];
            eclassifier = UimaTypeSystem2Ecore.uimaType2EClassifier(type, aOptions);
            EPackage rootPackage = eclassifier.getEPackage();
            while (rootPackage.getESuperPackage() != null) {
                rootPackage = rootPackage.getESuperPackage();
            }
            aOutputResource.getContents().add((Object)rootPackage);
            if (aSchemaLocationMap != null) {
                String schemaLoc = aOutputResource.getURI() + "#" + aOutputResource.getURIFragment((EObject)eclassifier.getEPackage());
                aSchemaLocationMap.put(eclassifier.getEPackage().getNsURI(), schemaLoc);
            }
            if (firstPackage != null) continue;
            firstPackage = eclassifier.getEPackage();
        }
        for (i = 0; i < types.length; ++i) {
            type = types[i];
            eclassifier = UimaTypeSystem2Ecore.lookupEClassifierForType(type.getName());
            if (!(eclassifier instanceof EClass)) continue;
            EClass eclass = (EClass)eclassifier;
            String supertypeName = type.getSupertypeName();
            EClassifier superclass = UimaTypeSystem2Ecore.lookupEClassifierForType(supertypeName);
            eclass.getESuperTypes().add((Object)((EClass)superclass));
            FeatureDescription[] features = type.getFeatures();
            for (int j = 0; j < features.length; ++j) {
                eclass.getEStructuralFeatures().add((Object)UimaTypeSystem2Ecore.uimaFeature2EStructuralFeature(features[j], aOptions));
            }
        }
        EAnnotation eannot = EcoreFactory.eINSTANCE.createEAnnotation();
        eannot.setSource("http://uima.apache.org");
        if (aTypeSystem.getName() != null && aTypeSystem.getName().length() > 0) {
            eannot.getDetails().put((Object)"name", (Object)aTypeSystem.getName());
        }
        if (aTypeSystem.getDescription() != null && aTypeSystem.getDescription().length() > 0) {
            eannot.getDetails().put((Object)"description", (Object)aTypeSystem.getDescription());
        }
        if (aTypeSystem.getVersion() != null && aTypeSystem.getVersion().length() > 0) {
            eannot.getDetails().put((Object)"version", (Object)aTypeSystem.getVersion());
        }
        if (aTypeSystem.getVendor() != null && aTypeSystem.getVendor().length() > 0) {
            eannot.getDetails().put((Object)"vendor", (Object)aTypeSystem.getVendor());
        }
        firstPackage.getEAnnotations().add((Object)eannot);
    }

    private static Resource loadUimaBuiltinsEcore(ResourceSet resourceSet, Map aSchemaLocationMap) {
        URL uimaEcoreUrl = UimaTypeSystem2Ecore.class.getResource("/uima.ecore");
        if (uimaEcoreUrl == null) {
            throw new UIMARuntimeException("uima_ecore_not_found", new Object[0]);
        }
        Resource uimaEcoreResource = resourceSet.getResource(URI.createURI((String)uimaEcoreUrl.toString()), true);
        TreeIterator iter2 = uimaEcoreResource.getAllContents();
        while (iter2.hasNext()) {
            Object current = iter2.next();
            if (!(current instanceof EPackage)) continue;
            EPackage pkg = (EPackage)current;
            EPackage.Registry.INSTANCE.put((Object)pkg.getNsURI(), (Object)pkg);
            if (aSchemaLocationMap == null) continue;
            String schemaLoc = uimaEcoreResource.getURI() + "#" + uimaEcoreResource.getURIFragment((EObject)pkg);
            aSchemaLocationMap.put(pkg.getNsURI(), schemaLoc);
        }
        return uimaEcoreResource;
    }

    private static EClassifier uimaType2EClassifier(TypeDescription aType, Map aOptions) {
        EEnum eclassifier;
        String shortTypeName;
        String uimaNamespace;
        String fullTypeName = aType.getName();
        int lastDot = fullTypeName.lastIndexOf(46);
        if (lastDot <= 0) {
            uimaNamespace = null;
            shortTypeName = fullTypeName;
        } else {
            uimaNamespace = fullTypeName.substring(0, lastDot);
            shortTypeName = fullTypeName.substring(lastDot + 1);
        }
        EPackage ePackage = UimaTypeSystem2Ecore.uimaNamespace2EPackage(uimaNamespace);
        if ("uima.cas.String".equals(aType.getSupertypeName())) {
            eclassifier = EcoreFactory.eINSTANCE.createEEnum();
            AllowedValue[] vals = aType.getAllowedValues();
            for (int i = 0; i < vals.length; ++i) {
                EEnumLiteral literal = EcoreFactory.eINSTANCE.createEEnumLiteral();
                literal.setValue(i);
                literal.setName(vals[i].getString());
                if (vals[i].getDescription() != null && vals[i].getDescription().length() > 0) {
                    EAnnotation eannot = EcoreFactory.eINSTANCE.createEAnnotation();
                    eannot.setSource("http://uima.apache.org");
                    eannot.getDetails().put((Object)"description", (Object)vals[i].getDescription());
                    literal.getEAnnotations().add((Object)eannot);
                }
                eclassifier.getELiterals().add((Object)literal);
            }
        } else {
            eclassifier = EcoreFactory.eINSTANCE.createEClass();
        }
        eclassifier.setName(shortTypeName);
        ePackage.getEClassifiers().add((Object)eclassifier);
        if (aType.getDescription() != null && aType.getDescription().length() > 0) {
            EAnnotation eannot = EcoreFactory.eINSTANCE.createEAnnotation();
            eannot.setSource("http://uima.apache.org");
            eannot.getDetails().put((Object)"description", (Object)aType.getDescription());
            eclassifier.getEAnnotations().add((Object)eannot);
        }
        return eclassifier;
    }

    private static EStructuralFeature uimaFeature2EStructuralFeature(FeatureDescription aFeature, Map aOptions) {
        Object efeat;
        boolean multiRefAllowed;
        String range2 = aFeature.getRangeTypeName();
        boolean bl = multiRefAllowed = aFeature.getMultipleReferencesAllowed() == null ? false : aFeature.getMultipleReferencesAllowed();
        if ("uima.cas.String".equals(range2)) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        } else if ("uima.cas.Integer".equals(range2)) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
        } else if ("uima.cas.Float".equals(range2)) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEFloat());
        } else if ("uima.cas.Byte".equals(range2)) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEByte());
        } else if ("uima.cas.Short".equals(range2)) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEShort());
        } else if ("uima.cas.Long".equals(range2)) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getELong());
        } else if ("uima.cas.Double".equals(range2)) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEDouble());
        } else if ("uima.cas.Boolean".equals(range2)) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        } else if (("uima.cas.StringArray".equals(range2) || "uima.cas.StringList".equals(range2)) && !multiRefAllowed) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
            efeat.setUpperBound(-1);
        } else if (("uima.cas.IntegerArray".equals(range2) || "uima.cas.IntegerList".equals(range2)) && !multiRefAllowed) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEInt());
            efeat.setUpperBound(-1);
        } else if (("uima.cas.FloatArray".equals(range2) || "uima.cas.FloatList".equals(range2)) && !multiRefAllowed) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEFloat());
            efeat.setUpperBound(-1);
        } else if ("uima.cas.ShortArray".equals(range2) && !multiRefAllowed) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEShort());
            efeat.setUpperBound(-1);
        } else if ("uima.cas.LongArray".equals(range2) && !multiRefAllowed) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getELong());
            efeat.setUpperBound(-1);
        } else if ("uima.cas.DoubleArray".equals(range2) && !multiRefAllowed) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEDouble());
            efeat.setUpperBound(-1);
        } else if ("uima.cas.BooleanArray".equals(range2) && !multiRefAllowed) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
            efeat.setUpperBound(-1);
        } else if ("uima.cas.ByteArray".equals(range2) && !multiRefAllowed) {
            efeat = EcoreFactory.eINSTANCE.createEAttribute();
            efeat.setEType((EClassifier)EcorePackage.eINSTANCE.getEByteArray());
        } else if (("uima.cas.FSArray".equals(range2) || "uima.cas.FSList".equals(range2)) && !multiRefAllowed) {
            efeat = EcoreFactory.eINSTANCE.createEReference();
            String elementType = aFeature.getElementType();
            if (elementType == null) {
                elementType = "uima.cas.TOP";
            }
            efeat.setEType(UimaTypeSystem2Ecore.lookupEClassifierForType(elementType));
            efeat.setUpperBound(-1);
        } else {
            EClassifier etype = UimaTypeSystem2Ecore.lookupEClassifierForType(range2);
            efeat = etype instanceof EEnum ? EcoreFactory.eINSTANCE.createEAttribute() : EcoreFactory.eINSTANCE.createEReference();
            efeat.setEType(etype);
        }
        efeat.setName(aFeature.getName());
        if (aFeature.getDescription() != null && aFeature.getDescription().length() > 0 || efeat.isMany() || aFeature.getElementType() != null) {
            EAnnotation eannot = EcoreFactory.eINSTANCE.createEAnnotation();
            eannot.setSource("http://uima.apache.org");
            if (aFeature.getDescription() != null && aFeature.getDescription().length() > 0) {
                eannot.getDetails().put((Object)"description", (Object)aFeature.getDescription());
            }
            if (efeat.isMany()) {
                eannot.getDetails().put((Object)"uimaType", (Object)aFeature.getRangeTypeName());
            }
            if (!efeat.isMany() && aFeature.getElementType() != null) {
                eannot.getDetails().put((Object)"elementType", (Object)aFeature.getElementType());
            }
            efeat.getEAnnotations().add((Object)eannot);
        }
        return efeat;
    }

    private static EClassifier lookupEClassifierForType(String aFullTypeName) {
        String shortTypeName;
        String uimaNamespace;
        int lastDot = aFullTypeName.lastIndexOf(46);
        if (lastDot <= 0) {
            uimaNamespace = null;
            shortTypeName = aFullTypeName;
        } else {
            uimaNamespace = aFullTypeName.substring(0, lastDot);
            shortTypeName = aFullTypeName.substring(lastDot + 1);
        }
        String nsUri = UimaTypeSystem2Ecore.uimaNamespace2NamespaceUri(uimaNamespace);
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsUri);
        if (ePackage == null) {
            return null;
        }
        return ePackage.getEClassifier(shortTypeName);
    }

    private static EPackage uimaNamespace2EPackage(String uimaNamespace) {
        String nsUri = UimaTypeSystem2Ecore.uimaNamespace2NamespaceUri(uimaNamespace);
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsUri);
        if (ePackage == null) {
            String packageName;
            String parentNamespace = null;
            if (uimaNamespace != null) {
                int lastDot = uimaNamespace.lastIndexOf(46);
                packageName = uimaNamespace.substring(lastDot + 1);
                if (lastDot > 0) {
                    parentNamespace = uimaNamespace.substring(0, lastDot);
                }
            } else {
                packageName = "noNamespace";
            }
            ePackage = EcoreFactory.eINSTANCE.createEPackage();
            ePackage.setNsURI(nsUri);
            ePackage.setName(packageName);
            EPackage.Registry.INSTANCE.put((Object)nsUri, (Object)ePackage);
            if (parentNamespace != null) {
                EPackage superPackage = UimaTypeSystem2Ecore.uimaNamespace2EPackage(parentNamespace);
                superPackage.getESubpackages().add((Object)ePackage);
            }
        }
        return ePackage;
    }

    private static String uimaNamespace2NamespaceUri(String uimaNamespace) {
        if (uimaNamespace == null || uimaNamespace.length() == 0) {
            return "http:///uima/noNamespace.ecore";
        }
        return "http:///" + uimaNamespace.replace('.', '/') + ".ecore";
    }

    public static void main(String[] args) throws Exception {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI outputURI = URI.createFileURI((String)args[1]);
        Resource outputResource = resourceSet.createResource(outputURI);
        HashMap options = new HashMap();
        UimaTypeSystem2Ecore.uimaTypeSystem2Ecore(args[0], outputResource, options);
        outputResource.save(null);
    }
}

