/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.xmi;

import java.io.File;
import java.io.FileOutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.ResourceSpecifierFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.resource.metadata.AllowedValue;
import org.apache.uima.resource.metadata.FeatureDescription;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class Ecore2UimaTypeSystem {
    public static final String OPTION_GENERATE_UIMA_LIST_TYPES = "OPTION_GENERATE_UIMA_LIST_TYPES";
    public static final String OPTION_CREATE_ANNOTATION_SUBTYPES = "OPTION_CREATE_ANNOTATION_SUBTYPES";
    private static ResourceSpecifierFactory uimaFactory = UIMAFramework.getResourceSpecifierFactory();

    public static TypeSystemDescription ecore2UimaTypeSystem(String aEcoreFilePath, Map aOptions) throws URISyntaxException {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File inputFile = new File(aEcoreFilePath);
        URI absoluteInputURI = URI.createFileURI((String)inputFile.getAbsolutePath());
        Resource resource = resourceSet.getResource(absoluteInputURI, true);
        return Ecore2UimaTypeSystem.ecore2UimaTypeSystem(resource, aOptions);
    }

    public static TypeSystemDescription ecore2UimaTypeSystem(Resource aEcoreResource, Map aOptions) throws URISyntaxException {
        if (aOptions == null) {
            aOptions = Collections.EMPTY_MAP;
        }
        TypeSystemDescription tsDesc = uimaFactory.createTypeSystemDescription();
        EPackage ePackage = (EPackage)aEcoreResource.getContents().get(0);
        EAnnotation eannot = ePackage.getEAnnotation("http://uima.apache.org");
        if (eannot != null) {
            tsDesc.setName((String)eannot.getDetails().get((Object)"name"));
            tsDesc.setDescription((String)eannot.getDetails().get((Object)"description"));
            tsDesc.setVendor((String)eannot.getDetails().get((Object)"vendor"));
            tsDesc.setVersion((String)eannot.getDetails().get((Object)"version"));
        }
        ArrayList types = new ArrayList();
        for (Object obj : aEcoreResource.getContents()) {
            if (!(obj instanceof EPackage)) continue;
            Ecore2UimaTypeSystem.ePackage2UimaTypes((EPackage)obj, types, aOptions);
        }
        TypeDescription[] typeArr = new TypeDescription[types.size()];
        types.toArray(typeArr);
        tsDesc.setTypes(typeArr);
        return tsDesc;
    }

    private static void ePackage2UimaTypes(EPackage aEPackage, List aResultTypes, Map aOptions) throws URISyntaxException {
        String nsUri = aEPackage.getNsURI();
        String uimaNamespace = Ecore2UimaTypeSystem.namespaceUri2UimaNamespace(nsUri);
        if ("uima.cas".equals(uimaNamespace)) {
            return;
        }
        for (Object classifier : aEPackage.getEClassifiers()) {
            TypeDescription type;
            if (classifier instanceof EClass) {
                EClass eclass = (EClass)classifier;
                type = Ecore2UimaTypeSystem.eclass2UimaType(eclass, uimaNamespace, aOptions);
                if ("uima.tcas.Annotation".equals(type.getName())) continue;
                aResultTypes.add(type);
                continue;
            }
            if (!(classifier instanceof EEnum)) continue;
            EEnum eenum = (EEnum)classifier;
            type = Ecore2UimaTypeSystem.eenum2UimaType(eenum, uimaNamespace, aOptions);
            aResultTypes.add(type);
        }
        Iterator iter2 = aEPackage.getESubpackages().iterator();
        while (iter2.hasNext()) {
            Ecore2UimaTypeSystem.ePackage2UimaTypes((EPackage)iter2.next(), aResultTypes, aOptions);
        }
    }

    private static TypeDescription eclass2UimaType(EClass aEClass, String aUimaNamespace, Map aOptions) throws URISyntaxException {
        EList supertypes;
        TypeDescription type = uimaFactory.createTypeDescription();
        if (aUimaNamespace != null) {
            type.setName(aUimaNamespace + "." + aEClass.getName());
        } else {
            type.setName(aEClass.getName());
        }
        EAnnotation eannot = aEClass.getEAnnotation("http://uima.apache.org");
        if (eannot != null) {
            type.setDescription((String)eannot.getDetails().get((Object)"description"));
        }
        if ((supertypes = aEClass.getESuperTypes()).isEmpty()) {
            if (aOptions.get(OPTION_CREATE_ANNOTATION_SUBTYPES) == Boolean.FALSE) {
                type.setSupertypeName("uima.cas.TOP");
            } else {
                EStructuralFeature begin = aEClass.getEStructuralFeature("begin");
                EStructuralFeature end = aEClass.getEStructuralFeature("end");
                if (begin != null && end != null && begin.getEType() == EcorePackage.eINSTANCE.getEInt() && end.getEType() == EcorePackage.eINSTANCE.getEInt()) {
                    type.setSupertypeName("uima.tcas.Annotation");
                } else {
                    type.setSupertypeName("uima.cas.TOP");
                }
            }
        } else {
            EClass supertype = (EClass)supertypes.get(0);
            if (supertype.equals(EcorePackage.eINSTANCE.getEObject())) {
                type.setSupertypeName("uima.cas.TOP");
            }
            String uimaSupertypeName = Ecore2UimaTypeSystem.getUimaTypeName((EClassifier)supertype, false, aOptions);
            type.setSupertypeName(uimaSupertypeName);
            if (supertypes.size() > 1) {
                System.err.println("Warning: EClass " + aEClass.getName() + " defines multiple supertypes. " + "The UIMA supertype will be " + type.getSupertypeName() + "; features inherited from other supertypes will be copied down.");
            }
        }
        EList eFeatures = aEClass.getEStructuralFeatures();
        Iterator iter2 = eFeatures.iterator();
        ArrayList<FeatureDescription> uimaFeatures = new ArrayList<FeatureDescription>();
        while (iter2.hasNext()) {
            EStructuralFeature eFeat = (EStructuralFeature)iter2.next();
            FeatureDescription uimaFeat = Ecore2UimaTypeSystem.eStructuralFeature2UimaFeature(eFeat, aOptions);
            uimaFeatures.add(uimaFeat);
        }
        for (int i = 1; i < supertypes.size(); ++i) {
            EClass copyFrom = (EClass)supertypes.get(i);
            EList copyFeatures = copyFrom.getEStructuralFeatures();
            for (EStructuralFeature eFeat : copyFeatures) {
                EList locallyDefinedFeatures = aEClass.getEStructuralFeatures();
                EList firstSupertypesFeatures = ((EClass)supertypes.get(0)).getEAllStructuralFeatures();
                if (Ecore2UimaTypeSystem.containsNamedElement(locallyDefinedFeatures, eFeat.getName()) || Ecore2UimaTypeSystem.containsNamedElement(firstSupertypesFeatures, eFeat.getName())) continue;
                FeatureDescription uimaFeat = Ecore2UimaTypeSystem.eStructuralFeature2UimaFeature(eFeat, aOptions);
                uimaFeatures.add(uimaFeat);
            }
        }
        FeatureDescription[] featureArr = new FeatureDescription[uimaFeatures.size()];
        uimaFeatures.toArray(featureArr);
        type.setFeatures(featureArr);
        return type;
    }

    private static boolean containsNamedElement(EList locallyDefinedFeatures, String name) {
        for (Object obj : locallyDefinedFeatures) {
            if (!(obj instanceof ENamedElement) || !name.equals(((ENamedElement)obj).getName())) continue;
            return true;
        }
        return false;
    }

    private static TypeDescription eenum2UimaType(EEnum aEEnum, String aUimaNamespace, Map aOptions) throws URISyntaxException {
        TypeDescription type = uimaFactory.createTypeDescription();
        if (aUimaNamespace != null) {
            type.setName(aUimaNamespace + "." + aEEnum.getName());
        } else {
            type.setName(aEEnum.getName());
        }
        type.setSupertypeName("uima.cas.String");
        EAnnotation eannot = aEEnum.getEAnnotation("http://uima.apache.org");
        if (eannot != null) {
            type.setDescription((String)eannot.getDetails().get((Object)"description"));
        }
        EList literals = aEEnum.getELiterals();
        AllowedValue[] vals = new AllowedValue[literals.size()];
        for (int i = 0; i < literals.size(); ++i) {
            EEnumLiteral literal = (EEnumLiteral)literals.get(i);
            vals[i] = uimaFactory.createAllowedValue();
            vals[i].setString(literal.getName());
            EAnnotation literalAnnot = literal.getEAnnotation("http://uima.apache.org");
            if (literalAnnot == null) continue;
            vals[i].setDescription((String)literalAnnot.getDetails().get((Object)"description"));
        }
        type.setAllowedValues(vals);
        return type;
    }

    private static FeatureDescription eStructuralFeature2UimaFeature(EStructuralFeature aStructuralFeature, Map aOptions) throws URISyntaxException {
        FeatureDescription feat = uimaFactory.createFeatureDescription();
        feat.setName(aStructuralFeature.getName());
        String rangeTypeName = null;
        String elementTypeName = null;
        EAnnotation eannot = aStructuralFeature.getEAnnotation("http://uima.apache.org");
        if (eannot != null) {
            feat.setDescription((String)eannot.getDetails().get((Object)"description"));
            rangeTypeName = (String)eannot.getDetails().get((Object)"uimaType");
            elementTypeName = (String)eannot.getDetails().get((Object)"elementType");
        }
        EClassifier attrRangeType = aStructuralFeature.getEType();
        if (rangeTypeName == null) {
            rangeTypeName = Ecore2UimaTypeSystem.getUimaTypeName(attrRangeType, aStructuralFeature.isMany(), aOptions);
        }
        feat.setRangeTypeName(rangeTypeName);
        if (aStructuralFeature.isMany()) {
            String uimaElementType = Ecore2UimaTypeSystem.getUimaTypeName(attrRangeType, false, aOptions);
            if (!("uima.cas.Integer".equals(uimaElementType) || "uima.cas.Float".equals(uimaElementType) || "uima.cas.String".equals(uimaElementType) || "uima.cas.TOP".equals(uimaElementType) || "uima.cas.Byte".equals(uimaElementType) || "uima.cas.Short".equals(uimaElementType) || "uima.cas.Long".equals(uimaElementType) || "uima.cas.Double".equals(uimaElementType) || "uima.cas.Boolean".equals(uimaElementType))) {
                feat.setElementType(uimaElementType);
            }
        } else if (!aStructuralFeature.getEType().equals(EcorePackage.eINSTANCE.getEByteArray()) && Ecore2UimaTypeSystem.isArrayOrList(rangeTypeName)) {
            feat.setMultipleReferencesAllowed(Boolean.TRUE);
            feat.setElementType(elementTypeName);
        }
        return feat;
    }

    private static boolean isArrayOrList(String rangeTypeName) {
        return "uima.cas.FSList".equals(rangeTypeName) || "uima.cas.IntegerList".equals(rangeTypeName) || "uima.cas.FloatList".equals(rangeTypeName) || "uima.cas.StringList".equals(rangeTypeName) || "uima.cas.FSArray".equals(rangeTypeName) || "uima.cas.IntegerArray".equals(rangeTypeName) || "uima.cas.FloatArray".equals(rangeTypeName) || "uima.cas.StringArray".equals(rangeTypeName) || "uima.cas.ByteArray".equals(rangeTypeName) || "uima.cas.ShortArray".equals(rangeTypeName) || "uima.cas.LongArray".equals(rangeTypeName) || "uima.cas.DoubleArray".equals(rangeTypeName) || "uima.cas.BooleanArray".equals(rangeTypeName);
    }

    private static String getUimaTypeName(EClassifier aEcoreType, boolean aMultiValued, Map aOptions) throws URISyntaxException {
        boolean useUimaLists = Boolean.TRUE.equals(aOptions.get(OPTION_GENERATE_UIMA_LIST_TYPES));
        if (aEcoreType.eIsProxy() && (aEcoreType = (EClassifier)EcoreUtil.resolve((EObject)aEcoreType, (EObject)aEcoreType)).eIsProxy()) {
            throw new UIMARuntimeException("ecore_unresolved_proxy", new Object[]{aEcoreType.toString()});
        }
        if (aEcoreType instanceof EClass || aEcoreType instanceof EEnum) {
            if (aMultiValued) {
                return useUimaLists ? "uima.cas.FSList" : "uima.cas.FSArray";
            }
            EPackage epackage = aEcoreType.getEPackage();
            if (epackage != null) {
                String uimaNamespace = Ecore2UimaTypeSystem.namespaceUri2UimaNamespace(epackage.getNsURI());
                if (uimaNamespace != null) {
                    return uimaNamespace + '.' + aEcoreType.getName();
                }
                return aEcoreType.getName();
            }
            return aEcoreType.getName();
        }
        if (aEcoreType.equals(EcorePackage.eINSTANCE.getEInt())) {
            return aMultiValued ? (useUimaLists ? "uima.cas.IntegerList" : "uima.cas.IntegerArray") : "uima.cas.Integer";
        }
        if (aEcoreType.equals(EcorePackage.eINSTANCE.getEShort())) {
            return aMultiValued ? "uima.cas.ShortArray" : "uima.cas.Short";
        }
        if (aEcoreType.equals(EcorePackage.eINSTANCE.getELong())) {
            return aMultiValued ? "uima.cas.LongArray" : "uima.cas.Long";
        }
        if (aEcoreType.equals(EcorePackage.eINSTANCE.getEByte())) {
            return aMultiValued ? "uima.cas.ByteArray" : "uima.cas.Byte";
        }
        if (aEcoreType.equals(EcorePackage.eINSTANCE.getEFloat())) {
            return aMultiValued ? (useUimaLists ? "uima.cas.FloatList" : "uima.cas.FloatArray") : "uima.cas.Float";
        }
        if (aEcoreType.equals(EcorePackage.eINSTANCE.getEDouble())) {
            return aMultiValued ? "uima.cas.DoubleArray" : "uima.cas.Double";
        }
        if (aEcoreType.equals(EcorePackage.eINSTANCE.getEBoolean())) {
            return aMultiValued ? "uima.cas.BooleanArray" : "uima.cas.Boolean";
        }
        if (aEcoreType.equals(EcorePackage.eINSTANCE.getEByteArray())) {
            return "uima.cas.ByteArray";
        }
        if (!aEcoreType.equals(EcorePackage.eINSTANCE.getEString())) {
            System.err.println("Warning: unknown EDataType " + aEcoreType.getName() + " being mapped to uima.cas.String.");
        }
        return aMultiValued ? (useUimaLists ? "uima.cas.StringList" : "uima.cas.StringArray") : "uima.cas.String";
    }

    private static String namespaceUri2UimaNamespace(String nsUri) throws URISyntaxException {
        if ("http:///uima/noNamespace.ecore".equals(nsUri)) {
            return null;
        }
        java.net.URI uri = new java.net.URI(nsUri);
        String uimaNs = uri.getPath();
        if (uimaNs == null) {
            uimaNs = uri.getSchemeSpecificPart();
            uimaNs = uimaNs.replace(':', '.');
        } else {
            while (uimaNs.startsWith("/")) {
                uimaNs = uimaNs.substring(1);
            }
            if (uimaNs.endsWith(".ecore")) {
                uimaNs = uimaNs.substring(0, uimaNs.length() - 6);
            }
            uimaNs = uimaNs.replace('/', '.');
        }
        uimaNs = uimaNs.replace('-', '_');
        return uimaNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: java " + Ecore2UimaTypeSystem.class.getName() + " <ecore filename> <filename of UIMA TypeSystem file to generate>");
            return;
        }
        if (!new File(args[0]).exists()) {
            System.err.println("File " + args[0] + " does not exist");
            return;
        }
        HashMap options = new HashMap();
        TypeSystemDescription tsDesc = Ecore2UimaTypeSystem.ecore2UimaTypeSystem(args[0], options);
        FileOutputStream os = new FileOutputStream(args[1]);
        try {
            tsDesc.toXML(os);
        }
        finally {
            os.close();
        }
        try {
            CasCreationUtils.createCas(tsDesc, null, new FsIndexDescription[0]);
        }
        catch (Exception e) {
            System.err.println("Warning: CAS could not be created from the output type system.  The following problem occurred:");
            System.err.println(e.getMessage());
        }
    }
}

