/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.casMultiplier;

import java.io.File;
import java.io.PrintStream;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.CasIterator;
import org.apache.uima.cas.CAS;
import org.apache.uima.examples.PrintAnnotations;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.XMLInputSource;

public class CasMultiplierExampleApplication {
    static PrintStream outputStream;

    public static void main(String[] args) {
        try {
            XMLInputSource in = new XMLInputSource(args[0]);
            ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
            AnalysisEngine ae = UIMAFramework.produceAnalysisEngine(specifier);
            File textFile = new File(args[1]);
            String document2 = FileUtils.file2String(textFile, "UTF-8");
            CAS initialCas = ae.newCAS();
            initialCas.setDocumentText(document2);
            CasIterator casIterator = ae.processAndOutputNewCASes(initialCas);
            while (casIterator.hasNext()) {
                CAS outCas = casIterator.next();
                System.out.println("********* NEW SEGMENT *********");
                System.out.println(outCas.getDocumentText());
                PrintAnnotations.printAnnotations(outCas, System.out);
                outCas.release();
            }
            ae.collectionProcessComplete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

