/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.metadata.cpe;

import org.apache.uima.collection.impl.cpm.utils.CpmLocalizedMessage;
import org.apache.uima.collection.impl.metadata.cpe.CasProcessorConfigurationParameterSettingsImpl;
import org.apache.uima.collection.impl.metadata.cpe.CasProcessorDeploymentParamImpl;
import org.apache.uima.collection.impl.metadata.cpe.CpeDescriptorFactory;
import org.apache.uima.collection.metadata.CasProcessorConfigurationParameterSettings;
import org.apache.uima.collection.metadata.CasProcessorDeploymentParam;
import org.apache.uima.collection.metadata.CasProcessorDeploymentParams;
import org.apache.uima.collection.metadata.CasProcessorErrorHandling;
import org.apache.uima.collection.metadata.CasProcessorErrorRateThreshold;
import org.apache.uima.collection.metadata.CasProcessorFilter;
import org.apache.uima.collection.metadata.CasProcessorMaxRestarts;
import org.apache.uima.collection.metadata.CasProcessorRunInSeperateProcess;
import org.apache.uima.collection.metadata.CasProcessorTimeout;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCheckpoint;
import org.apache.uima.collection.metadata.CpeComponentDescriptor;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.collection.metadata.CpeSofaMappings;
import org.apache.uima.collection.metadata.NameValuePair;
import org.apache.uima.internal.util.StringUtils;
import org.apache.uima.resource.Parameter;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.impl.ConfigurationParameterSettings_impl;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.NameValuePair_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.w3c.dom.Element;
import org.xml.sax.helpers.AttributesImpl;

public class CasProcessorCpeObject
extends MetaDataObject_impl
implements CpeCasProcessor {
    private static final long serialVersionUID = -2424851648116984900L;
    private static final String[] actionArray = new String[]{"continue", "terminate", "disable", "kill-pipeline"};
    private static final String[] deployArray = new String[]{"integrated", "remote", "local"};
    private CpeComponentDescriptor descriptor;
    private Parameter[] parameters;
    private CasProcessorRunInSeperateProcess runInSeparateProcess;
    private CasProcessorFilter filter;
    private CasProcessorErrorHandling errorHandling;
    private CpeCheckpoint checkpoint;
    private String deployment;
    private String name;
    private CasProcessorDeploymentParams deploymentParameters;
    private CasProcessorConfigurationParameterSettings configurationParameterSettings;
    private ConfigurationParameterSettings parameterSettings;
    private CpeSofaMappings sofaNameMappings;
    private boolean isParallelizable;
    private static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("casProcessor", new PropertyXmlInfo[]{new PropertyXmlInfo("cpeComponentDescriptor", null), new PropertyXmlInfo("deploymentParameters", null), new PropertyXmlInfo("runInSeparateProcess", null), new PropertyXmlInfo("filter", null), new PropertyXmlInfo("errorHandling", null), new PropertyXmlInfo("checkpoint", null), new PropertyXmlInfo("sofaNameMappings", null), new PropertyXmlInfo("parameterSettings", null)});

    public void setDeployment(String aDeployMode) throws CpeDescriptorException {
        this.deployment = aDeployMode;
        for (int i = 0; i < deployArray.length; ++i) {
            if (!deployArray[i].equalsIgnoreCase(aDeployMode)) continue;
            this.deployment = aDeployMode;
            return;
        }
        throw new CpeDescriptorException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_Exception_invalid_deployment__WARNING", new Object[]{Thread.currentThread().getName(), "", aDeployMode}));
    }

    public String getDeployment() {
        return this.deployment;
    }

    public void setDescriptor(String aDescriptorPath) throws CpeDescriptorException {
        if (this.descriptor == null) {
            CpeComponentDescriptor comp_desc = CpeDescriptorFactory.produceComponentDescriptor(aDescriptorPath);
            this.setCpeComponentDescriptor(comp_desc);
        } else {
            this.descriptor.getInclude().set(aDescriptorPath);
        }
    }

    @Deprecated
    public String getDescriptor() {
        if (this.descriptor != null && this.descriptor.getInclude() != null) {
            return this.descriptor.getInclude().get();
        }
        return null;
    }

    public CpeComponentDescriptor getCpeComponentDescriptor() {
        return this.descriptor;
    }

    public void setCasProcessorFilter(String aFilterExpression) {
        if (this.filter == null) {
            this.filter = CpeDescriptorFactory.produceCasProcessorFilter("");
        }
        this.filter.setFilterString(aFilterExpression);
    }

    public String getCasProcessorFilter() {
        if (this.getFilter() == null || this.getFilter().getFilterString() == null) {
            return "";
        }
        String filterString = this.getFilter().getFilterString();
        if (this.filter != null) {
            if (filterString.indexOf(":") > -1) {
                filterString = StringUtils.replaceAll(filterString, ":", "_colon_");
            }
            if (filterString.indexOf("_dash_") > -1) {
                filterString = StringUtils.replaceAll(filterString, "-", "_dash_");
            }
        }
        return filterString;
    }

    protected void addDefaults() throws CpeDescriptorException {
        if (this.getCasProcessorFilter() == null) {
            CasProcessorFilter filter2 = CpeDescriptorFactory.produceCasProcessorFilter("");
            this.setCasProcessorFilter(filter2);
        }
        if (this.getErrorHandling() == null) {
            CasProcessorErrorHandling errorHandling = CpeDescriptorFactory.produceCasProcessorErrorHandling();
            CasProcessorMaxRestarts maxRestart = CpeDescriptorFactory.produceCasProcessorMaxRestarts();
            maxRestart.setRestartCount(30);
            maxRestart.setAction("terminate");
            errorHandling.setMaxConsecutiveRestarts(maxRestart);
            CasProcessorTimeout timeout = CpeDescriptorFactory.produceCasProcessorTimeout();
            timeout.set(100000);
            errorHandling.setTimeout(timeout);
            CasProcessorErrorRateThreshold errorThreshold = CpeDescriptorFactory.produceCasProcessorErrorRateThreshold();
            errorThreshold.setMaxErrorCount(100);
            errorThreshold.setMaxErrorSampleSize(1000);
            errorThreshold.setAction("terminate");
            errorHandling.setErrorRateThreshold(errorThreshold);
            this.setErrorHandling(errorHandling);
        }
        if (this.getCheckpoint() == null) {
            CpeCheckpoint checkpoint = CpeDescriptorFactory.produceCpeCheckpoint();
            checkpoint.setBatchSize(1);
            checkpoint.setFilePath("");
            checkpoint.setFrequency(1000, true);
            this.setCheckpoint(checkpoint);
        }
    }

    public void setBatchSize(int aBatchSize) {
        this.checkpoint.setBatchSize(aBatchSize);
    }

    public int getBatchSize() {
        return this.checkpoint.getBatchSize();
    }

    private int deleteParam(String aParamName) throws CpeDescriptorException {
        CasProcessorDeploymentParams depParams = this.getDeploymentParameters();
        if (depParams != null) {
            CasProcessorDeploymentParam[] paramArray = depParams.getAll();
            for (int i = 0; paramArray != null && i < paramArray.length; ++i) {
                if (!aParamName.equals(paramArray[i].getParameterName())) continue;
                depParams.remove(paramArray[i]);
                return i;
            }
        }
        return -1;
    }

    public void addDeployParam(String aParamName, String aParamValue) throws CpeDescriptorException {
        boolean found = false;
        CasProcessorDeploymentParam[] params = this.deploymentParameters.getAll();
        for (int i = 0; params != null && i < params.length; ++i) {
            if (!aParamName.equals(params[i].getParameterName())) continue;
            params[i].setParameterValue(aParamValue);
            found = true;
            break;
        }
        if (!found) {
            this.deploymentParameters.add(new CasProcessorDeploymentParamImpl(aParamName, aParamValue, "string"));
        }
    }

    protected void setDeploymentParams(CasProcessorDeploymentParams aParams) throws CpeDescriptorException {
        this.deploymentParameters = aParams;
    }

    public CasProcessorDeploymentParams getDeploymentParams() {
        return this.deploymentParameters;
    }

    public void setName(String aName) throws CpeDescriptorException {
        if (aName == null || aName.trim().length() == 0) {
            throw new CpeDescriptorException(CpmLocalizedMessage.getLocalizedMessage("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_invalid_reference__WARNING", new Object[]{Thread.currentThread().getName(), "casProcessor name=NULL"}));
        }
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setSOFA(String aSoFa) throws CpeDescriptorException {
    }

    @Deprecated
    public String getSOFA() {
        return null;
    }

    public void setCpeComponentDescriptor(CpeComponentDescriptor aDescriptor) throws CpeDescriptorException {
        this.descriptor = aDescriptor;
    }

    public void setCasProcessorFilter(CasProcessorFilter aFilter) throws CpeDescriptorException {
        this.filter = aFilter;
    }

    public void setErrorHandling(CasProcessorErrorHandling aErrorHandling) throws CpeDescriptorException {
        this.errorHandling = aErrorHandling;
    }

    public CasProcessorErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    public void setMaxErrorCount(int aErrorCount) {
        CasProcessorErrorHandling eh = this.getErrorHandling();
        if (eh != null && eh.getErrorRateThreshold() != null) {
            eh.getErrorRateThreshold().setMaxErrorCount(aErrorCount);
        }
    }

    public int getMaxErrorCount() {
        CasProcessorErrorHandling eh = this.getErrorHandling();
        if (eh != null && eh.getErrorRateThreshold() != null) {
            return eh.getErrorRateThreshold().getMaxErrorCount();
        }
        return 0;
    }

    public void setMaxErrorSampleSize(int aErrorSampleSize) {
        CasProcessorErrorHandling eh = this.getErrorHandling();
        if (eh != null && eh.getErrorRateThreshold() != null) {
            eh.getErrorRateThreshold().setMaxErrorSampleSize(aErrorSampleSize);
        }
    }

    public int getMaxErrorSampleSize() {
        CasProcessorErrorHandling eh = this.getErrorHandling();
        if (eh != null && eh.getErrorRateThreshold() != null) {
            return eh.getErrorRateThreshold().getMaxErrorSampleSize();
        }
        return 0;
    }

    private boolean validAction(String aAction) {
        for (int i = 0; i < actionArray.length; ++i) {
            if (!actionArray[i].equalsIgnoreCase(aAction)) continue;
            return true;
        }
        return false;
    }

    public void setActionOnMaxError(String aAction) {
        CasProcessorErrorHandling eh = this.getErrorHandling();
        if (eh != null && eh.getErrorRateThreshold() != null) {
            eh.getErrorRateThreshold().setAction(aAction);
        }
    }

    public String getActionOnMaxError() {
        CasProcessorErrorHandling eh = this.getErrorHandling();
        if (eh != null && eh.getErrorRateThreshold() != null) {
            return eh.getErrorRateThreshold().getAction();
        }
        return null;
    }

    public void setActionOnMaxRestart(String aAction) {
        CasProcessorErrorHandling eh = this.getErrorHandling();
        if (eh != null && eh.getMaxConsecutiveRestarts() != null) {
            eh.getMaxConsecutiveRestarts().setAction(aAction);
        }
    }

    public String getActionOnMaxRestart() {
        CasProcessorErrorHandling eh = this.getErrorHandling();
        if (eh != null && eh.getMaxConsecutiveRestarts() != null) {
            return eh.getMaxConsecutiveRestarts().getAction();
        }
        return null;
    }

    public void setMaxRestartCount(int aRestartCount) {
        CasProcessorErrorHandling eh = this.getErrorHandling();
        if (eh != null && eh.getMaxConsecutiveRestarts() != null) {
            eh.getMaxConsecutiveRestarts().setRestartCount(aRestartCount);
        }
    }

    public int getMaxRestartCount() {
        CasProcessorErrorHandling eh = this.getErrorHandling();
        if (eh != null && eh.getMaxConsecutiveRestarts() != null) {
            return eh.getMaxConsecutiveRestarts().getRestartCount();
        }
        return 0;
    }

    public void setTimeout(int aTimeoutValue) {
        CasProcessorErrorHandling eh = this.getErrorHandling();
        if (eh != null && eh.getTimeout() != null) {
            eh.getTimeout().set(aTimeoutValue);
        }
    }

    public int getTimeout() {
        CasProcessorErrorHandling eh = this.getErrorHandling();
        if (eh != null && eh.getTimeout() != null) {
            return eh.getTimeout().get();
        }
        return 0;
    }

    public void setConfigurationParameterSettings(CasProcessorConfigurationParameterSettings settings) throws CpeDescriptorException {
        int length;
        this.configurationParameterSettings = settings;
        if (settings != null && settings.getParameterSettings() != null && (length = settings.getParameterSettings().length) > 0) {
            this.parameterSettings = new ConfigurationParameterSettings_impl();
            org.apache.uima.resource.metadata.NameValuePair[] nvp = new NameValuePair_impl[settings.getParameterSettings().length];
            for (int i = 0; i < settings.getParameterSettings().length; ++i) {
                nvp[i] = new NameValuePair_impl(settings.getParameterSettings()[i].getName(), settings.getParameterSettings()[i].getValue());
            }
            this.parameterSettings.setParameterSettings(nvp);
        }
    }

    public CasProcessorConfigurationParameterSettings getConfigurationParameterSettings() {
        return this.configurationParameterSettings;
    }

    public void setParameterSettings(ConfigurationParameterSettings settings) {
        this.parameterSettings = settings;
        if (this.parameterSettings != null) {
            this.configurationParameterSettings = new CasProcessorConfigurationParameterSettingsImpl(this.parameterSettings);
        }
    }

    public ConfigurationParameterSettings getParameterSettings() {
        ConfigurationParameterSettings local = null;
        if (this.configurationParameterSettings != null) {
            local = new ConfigurationParameterSettings_impl();
            NameValuePair[] nvp = this.configurationParameterSettings.getParameterSettings();
            for (int i = 0; nvp != null && i < nvp.length; ++i) {
                local.setParameterValue(nvp[i].getName(), nvp[i].getValue());
            }
        } else {
            local = this.parameterSettings;
        }
        return local;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public CasProcessorFilter getFilter() {
        return this.filter;
    }

    public void setCheckpoint(CpeCheckpoint checkpoint) {
        this.checkpoint = checkpoint;
    }

    public void setParameters(Parameter[] aparameters) {
        this.parameters = aparameters;
    }

    public void setFilter(CasProcessorFilter aFilter) {
        this.filter = aFilter;
    }

    public CasProcessorRunInSeperateProcess getRunInSeparateProcess() {
        return this.runInSeparateProcess;
    }

    public void setRunInSeparateProcess(CasProcessorRunInSeperateProcess process) {
        this.runInSeparateProcess = process;
    }

    public CasProcessorDeploymentParams getDeploymentParameters() {
        return this.deploymentParameters;
    }

    public void setDeploymentParameters(CasProcessorDeploymentParams parameters) {
        this.deploymentParameters = parameters;
    }

    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        super.buildFromXMLElement(aElement, aParser, aOptions);
        String field2 = "name";
        try {
            this.setName(aElement.getAttribute("name"));
            field2 = "deployment";
            this.setDeployment(aElement.getAttribute("deployment"));
        }
        catch (Exception e) {
            throw new InvalidXMLException("org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_EXP_missing_attribute_from_xml_element__WARNING", new Object[]{Thread.currentThread().getName(), "casProcessor", field2, "casProcessor"});
        }
    }

    protected AttributesImpl getXMLAttributes() {
        AttributesImpl attrs = super.getXMLAttributes();
        attrs.addAttribute("", "deployment", "deployment", "CDATA", this.getDeployment());
        attrs.addAttribute("", "name", "name", "CDATA", this.getName());
        return attrs;
    }

    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }

    public CpeCheckpoint getCheckpoint() {
        return this.checkpoint;
    }

    public CpeSofaMappings getSofaNameMappings() {
        return this.sofaNameMappings;
    }

    public void setSofaNameMappings(CpeSofaMappings mappings) {
        this.sofaNameMappings = mappings;
    }

    public void setIsParallelizable(boolean isP) {
        this.isParallelizable = isP;
    }

    public boolean getIsParallelizable() {
        return this.isParallelizable;
    }
}

