/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl.cpm.utils;

import java.text.ParseException;
import java.util.LinkedList;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;

public class Filter {
    Stack stack = new Stack();
    LinkedList expressionList = new LinkedList();
    protected boolean isAndFilter = false;
    protected boolean isOrFilter = true;
    protected boolean filterInitialized = false;

    public LinkedList parse(String expression) throws ParseException {
        StringTokenizer tokenizer = new StringTokenizer(expression, " !=", true);
        this.parseTokens(tokenizer);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.expressionList.size(); ++i) {
            Expression ex = (Expression)this.expressionList.get(i);
            if (ex.hasLeftPart()) {
                sb.append(ex.getLeftPart().get() + " ");
            }
            if (ex.hasOperand()) {
                sb.append(ex.getOperand().getOperand() + " ");
            }
            if (ex.hasRightPart()) {
                sb.append(ex.getRightPart().get() + " ");
            }
            if (UIMAFramework.getLogger().isLoggable(Level.FINEST)) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINEST, this.getClass().getName(), "process", "org.apache.uima.collection.impl.cpm.cpm_messages", "UIMA_CPM_expression__FINEST", new Object[]{Thread.currentThread().getName(), sb.toString()});
            }
            sb.setLength(0);
        }
        return this.expressionList;
    }

    private void parseTokens(StringTokenizer aTokenizer) throws ParseException {
        boolean leftPartInStack = false;
        while (aTokenizer.hasMoreTokens()) {
            String token2 = aTokenizer.nextToken();
            if ("where".equals(token2) || "".equals(token2.trim())) continue;
            if ("!".equals(token2)) {
                this.stack.push(new Operand("!"));
                continue;
            }
            if ("=".equals(token2)) {
                Object o = this.stack.peek();
                if (o instanceof Operand && "!".equals(((Operand)o).getOperand())) {
                    this.stack.pop();
                    this.stack.push(new Operand("!="));
                }
                this.stack.push(new Operand("="));
                continue;
            }
            if ("and".equalsIgnoreCase(token2) || "or".equalsIgnoreCase(token2)) {
                this.evaluate(token2);
                continue;
            }
            if (leftPartInStack) {
                this.stack.push(new RightPart(token2));
                leftPartInStack = false;
                continue;
            }
            this.stack.push(new LeftPart(token2));
            leftPartInStack = true;
        }
        if (this.stack.size() > 0) {
            this.evaluate(null);
        }
    }

    private void evaluate(String anOp) throws ParseException {
        Expression ex = new Expression(this);
        if (anOp != null) {
            if ("or".equalsIgnoreCase(anOp)) {
                ex.setIsOrFilter();
            } else if ("and".equalsIgnoreCase(anOp)) {
                ex.setIsAndFilter();
            }
        }
        boolean valid = false;
        while (this.stack.size() > 0) {
            valid = true;
            Object o = this.stack.pop();
            if (o instanceof LeftPart) {
                ex.setLeftPart((LeftPart)o);
                continue;
            }
            if (o instanceof RightPart) {
                ex.setRightPart((RightPart)o);
                continue;
            }
            if (o instanceof Operand) {
                ex.setOperand((Operand)o);
                continue;
            }
            throw new ParseException("Unexpected Entity in the Stack::" + o.getClass().getName(), 0);
        }
        if (valid) {
            this.expressionList.add(ex);
        }
    }

    public static void main(String[] args) {
        Filter filter2 = new Filter();
        try {
            filter2.parse(args[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class Expression {
        private LeftPart lP;
        private RightPart rP;
        private Operand op;
        private Filter filter = null;

        public Expression(Filter aFilter) {
            this.filter = aFilter;
        }

        protected void setIsOrFilter() throws ParseException {
            if (this.filter.isAndFilter) {
                throw new ParseException("Filter.Expression.setIsOrFilter()-Mixing <AND> and <OR> currently not supported. Choose one conjunction <AND> or disjunction <OR> in your filter.", 0);
            }
            this.filter.isOrFilter = true;
            this.filter.filterInitialized = true;
        }

        protected void setIsAndFilter() throws ParseException {
            if (this.filter.filterInitialized && this.filter.isOrFilter) {
                throw new ParseException("Filter.Expression.setIsOrFilter()-Mixing <AND> and <OR> currently not supported. Choose one conjunction <AND> or disjunction <OR> in your filter.", 0);
            }
            this.filter.isAndFilter = true;
            this.filter.isOrFilter = false;
        }

        public boolean isOrFilter() {
            return this.filter.isOrFilter;
        }

        public boolean isAndFilter() {
            return this.filter.isAndFilter;
        }

        public void setLeftPart(LeftPart aLP) {
            this.lP = aLP;
        }

        public void setRightPart(RightPart aRP) {
            this.rP = aRP;
        }

        public void setOperand(Operand aOP) {
            this.op = aOP;
        }

        public boolean hasLeftPart() {
            return this.lP != null;
        }

        public boolean hasRightPart() {
            return this.rP != null;
        }

        public boolean hasOperand() {
            return this.op != null;
        }

        public LeftPart getLeftPart() {
            return this.lP;
        }

        public RightPart getRightPart() {
            return this.rP;
        }

        public Operand getOperand() {
            return this.op;
        }
    }

    public class RightPart {
        private String rightPart;

        public RightPart(String aRPart) {
            this.rightPart = aRPart;
        }

        public String get() {
            return this.rightPart;
        }
    }

    public class LeftPart {
        private String leftPart;

        public LeftPart(String aLPart) {
            this.leftPart = aLPart;
        }

        public String get() {
            return this.leftPart;
        }
    }

    public class Operand {
        private String operand;

        public Operand(String aOp) {
            this.operand = aOp;
        }

        public String getOperand() {
            return this.operand;
        }
    }
}

