/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.internal.util.XmlAttribute;
import org.apache.uima.internal.util.XmlElementName;
import org.apache.uima.internal.util.XmlElementNameAndContents;
import org.apache.uima.internal.util.rb_trees.RedBlackTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmiSerializationSharedData {
    private RedBlackTree<String> fsAddrToXmiIdMap = new RedBlackTree();
    private RedBlackTree<Integer> xmiIdToFsAddrMap = new RedBlackTree();
    private List<OotsElementData> ootsFs = new ArrayList<OotsElementData>();
    private Map<String, List<String>> ootsViewMembers = new HashMap<String, List<String>>();
    private Map<Integer, OotsElementData> ootsFeatures = new HashMap<Integer, OotsElementData>();
    private Map<Integer, List<XmiArrayElement>> ootsArrayElements = new HashMap<Integer, List<XmiArrayElement>>();
    private int maxXmiId = 0;
    RedBlackTree<Integer> nonsharedfeatureIdToFSId = new RedBlackTree();

    void addIdMapping(int fsAddr, int xmiId) {
        this.fsAddrToXmiIdMap.put(fsAddr, Integer.toString(xmiId));
        this.xmiIdToFsAddrMap.put(xmiId, fsAddr);
        if (xmiId > this.maxXmiId) {
            this.maxXmiId = xmiId;
        }
    }

    String getXmiId(int fsAddr) {
        String xmiId = this.fsAddrToXmiIdMap.get(fsAddr);
        if (xmiId != null) {
            return xmiId;
        }
        String idStr = Integer.toString(++this.maxXmiId);
        this.fsAddrToXmiIdMap.put(fsAddr, idStr);
        this.xmiIdToFsAddrMap.put(this.maxXmiId, fsAddr);
        return idStr;
    }

    public int getMaxXmiId() {
        return this.maxXmiId;
    }

    public int getFsAddrForXmiId(int xmiId) {
        Integer addr = this.xmiIdToFsAddrMap.get(xmiId);
        return addr == null ? -1 : addr;
    }

    public void clearIdMap() {
        this.fsAddrToXmiIdMap.clear();
        this.xmiIdToFsAddrMap.clear();
        this.nonsharedfeatureIdToFSId.clear();
        this.maxXmiId = 0;
    }

    public void addOutOfTypeSystemElement(OotsElementData elemData) {
        this.ootsFs.add(elemData);
        int xmiId = Integer.parseInt(elemData.xmiId);
        if (xmiId > this.maxXmiId) {
            this.maxXmiId = xmiId;
        }
    }

    public List<OotsElementData> getOutOfTypeSystemElements() {
        return Collections.unmodifiableList(this.ootsFs);
    }

    public void addOutOfTypeSystemViewMember(String sofaXmiId, String memberXmiId) {
        List<String> membersList = this.ootsViewMembers.get(sofaXmiId);
        if (membersList == null) {
            membersList = new ArrayList<String>();
            this.ootsViewMembers.put(sofaXmiId, membersList);
        }
        membersList.add(memberXmiId);
    }

    public List<String> getOutOfTypeSystemViewMembers(String sofaXmiId) {
        List<String> members = this.ootsViewMembers.get(sofaXmiId);
        return members == null ? null : Collections.unmodifiableList(members);
    }

    public void addOutOfTypeSystemAttribute(int addr, String featName, String featVal) {
        Integer key = addr;
        OotsElementData oed = this.ootsFeatures.get(key);
        if (oed == null) {
            oed = new OotsElementData();
            this.ootsFeatures.put(key, oed);
        }
        oed.attributes.add(new XmlAttribute(featName, featVal));
    }

    public void addOutOfTypeSystemChildElements(int addr, String featName, List<String> featVals) {
        Integer key = addr;
        OotsElementData oed = this.ootsFeatures.get(key);
        if (oed == null) {
            oed = new OotsElementData();
            this.ootsFeatures.put(key, oed);
        }
        Iterator<String> iter2 = featVals.iterator();
        XmlElementName elemName = new XmlElementName(null, featName, featName);
        while (iter2.hasNext()) {
            oed.childElements.add(new XmlElementNameAndContents(elemName, iter2.next()));
        }
    }

    public OotsElementData getOutOfTypeSystemFeatures(int addr) {
        Integer key = addr;
        return this.ootsFeatures.get(key);
    }

    public int[] getAllFsAddressesInIdMap() {
        return this.fsAddrToXmiIdMap.keySet();
    }

    public List<XmiArrayElement> getOutOfTypeSystemArrayElements(int addr) {
        return this.ootsArrayElements.get(addr);
    }

    public void addOutOfTypeSystemArrayElement(int addr, int index, int xmiId) {
        Integer key = addr;
        List<XmiArrayElement> list2 = this.ootsArrayElements.get(key);
        if (list2 == null) {
            list2 = new ArrayList<XmiArrayElement>();
            this.ootsArrayElements.put(key, list2);
        }
        list2.add(new XmiArrayElement(index, Integer.toString(xmiId)));
    }

    public void addNonsharedRefToFSMapping(int nonsharedFSAddr, int fsAddr) {
        this.nonsharedfeatureIdToFSId.put(nonsharedFSAddr, fsAddr);
    }

    public int[] getNonsharedMulitValuedFSs() {
        return this.nonsharedfeatureIdToFSId.keySet();
    }

    public int getEncompassingFS(int nonsharedFS) {
        Integer addr = this.nonsharedfeatureIdToFSId.get(nonsharedFS);
        return addr == null ? -1 : addr;
    }

    void checkForDups() {
        HashSet<String> ids = new HashSet<String>();
        for (String xmiId : this.fsAddrToXmiIdMap) {
            if (ids.add(xmiId)) continue;
            throw new RuntimeException("Duplicate ID " + xmiId + "!");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int[] keys = this.fsAddrToXmiIdMap.keySet();
        for (int i = 0; i < keys.length; ++i) {
            buf.append(keys[i]).append(": ").append(this.fsAddrToXmiIdMap.get(keys[i])).append('\n');
        }
        return buf.toString();
    }

    static class XmiArrayElement {
        int index;
        String xmiId;

        XmiArrayElement(int index, String xmiId) {
            this.index = index;
            this.xmiId = xmiId;
        }
    }

    static class OotsElementData {
        String xmiId;
        XmlElementName elementName;
        List<XmlAttribute> attributes = new ArrayList<XmlAttribute>();
        List<XmlElementNameAndContents> childElements = new ArrayList<XmlElementNameAndContents>();

        OotsElementData() {
        }
    }
}

