/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.LinearTypeOrder;
import org.apache.uima.cas.admin.LinearTypeOrderBuilder;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.GraphNode;

public class LinearTypeOrderBuilderImpl
implements LinearTypeOrderBuilder {
    private Graph order = new Graph();
    private TypeSystem ts;

    public LinearTypeOrderBuilderImpl(TypeSystem ts) {
        this.ts = ts;
    }

    public static LinearTypeOrder createTypeOrder(int[] typeList, TypeSystem ts) {
        return new TotalTypeOrder(typeList, ts);
    }

    public void add(String[] types) throws CASException {
        int max2 = types.length - 1;
        for (int i = 0; i < max2; ++i) {
            boolean rc = this.add(types[i], types[i + 1]);
            if (rc) continue;
            CASException e = new CASException("CYCLE_IN_TYPE_ORDER", new String[]{types[i], types[i + 1]});
            throw e;
        }
    }

    private boolean add(String s1, String s2) {
        Node n2;
        Node n1 = this.order.getNode(s1);
        if (this.order.pathFromTo(n1, n2 = this.order.getNode(s2))) {
            return true;
        }
        if (this.order.pathFromTo(n2, n1)) {
            return false;
        }
        n1.connect(n2);
        return true;
    }

    private void addInheritanceTypes() {
        ArrayList<Type> typesToModify = new ArrayList<Type>();
        Iterator<Type> tsi = this.ts.getTypeIterator();
        while (tsi.hasNext()) {
            Type bottomType;
            Type type2 = bottomType = tsi.next();
            Node nIn = null;
            Node nOut = null;
            typesToModify.clear();
            while (true) {
                String typeName = type2.getName();
                Node n = this.order.getNode(typeName);
                if (nIn == null && n.inRank() != 0) {
                    nIn = n;
                }
                if (nOut == null && n.outRank() != 0) {
                    nOut = n;
                }
                if (nIn != null && nOut != null || typeName.equals("uima.cas.TOP")) break;
                typesToModify.add(type2);
                type2 = this.ts.getParent(type2);
            }
            boolean doIn = true;
            boolean doOut = true;
            for (Type type2 : typesToModify) {
                String typeName = type2.getName();
                Node n = this.order.getNode(typeName);
                if (doIn && nIn != null) {
                    if (n.inRank() == 0) {
                        n.addAllPredecessors(nIn.getAllPredecessors());
                    } else {
                        doIn = false;
                    }
                }
                if (!doOut || nOut == null) continue;
                if (n.outRank() == 0) {
                    n.addAllSuccessors(nOut.getAllSuccessors());
                    continue;
                }
                doOut = false;
            }
        }
    }

    public LinearTypeOrder getOrder() throws CASException {
        this.addInheritanceTypes();
        Node inRank0Nodes = new Node("");
        Graph g = this.order.copy(inRank0Nodes);
        String[] totalOrder = new String[g.size()];
        for (int i = 0; i < totalOrder.length; ++i) {
            Node n = (Node)inRank0Nodes.getSuccessor(0);
            totalOrder[i] = (String)n.getElement();
            inRank0Nodes.removeSuccessor(0);
            ArrayList newRank0Nodes = g.removeNode(n);
            Iterator it = newRank0Nodes.iterator();
            while (it.hasNext()) {
                inRank0Nodes.addSuccessor((GraphNode)it.next());
            }
        }
        return new TotalTypeOrder(totalOrder, this.ts);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Graph {
        private final HashMap<String, Node> nodeMap = new HashMap();

        private Graph() {
        }

        private int size() {
            return this.nodeMap.size();
        }

        private Node getNode(String name) {
            Node node = this.nodeMap.get(name);
            if (node == null) {
                node = new Node(name);
                this.nodeMap.put(name, node);
            }
            return node;
        }

        private Graph copy(Node inRank0nodes) {
            String key;
            Graph copy = new Graph();
            for (Map.Entry<String, Node> entry : this.nodeMap.entrySet()) {
                key = entry.getKey();
                copy.nodeMap.put(key, copy.getNode(key));
            }
            for (Map.Entry<String, Node> entry : this.nodeMap.entrySet()) {
                int i;
                key = entry.getKey();
                Node origNode = entry.getValue();
                Node copyNode = copy.nodeMap.get(key);
                for (i = 0; i < origNode.inRank(); ++i) {
                    key = (String)origNode.getPredecessor(i).getElement();
                    copyNode.addPredecessor(copy.getNode(key));
                }
                for (i = 0; i < origNode.outRank(); ++i) {
                    key = (String)origNode.getSuccessor(i).getElement();
                    copyNode.addSuccessor(copy.getNode(key));
                }
                if (origNode.inRank() != 0) continue;
                inRank0nodes.addSuccessor(origNode);
            }
            return copy;
        }

        private ArrayList<Node> removeNode(Node node) {
            ArrayList<Node> rank0s = new ArrayList<Node>();
            this.nodeMap.remove(node.getElement());
            int max2 = node.outRank();
            for (int i = 0; i < max2; ++i) {
                Node n = (Node)node.getSuccessor(i);
                n.removeAncestor(node);
                if (n.inRank() != 0) continue;
                rank0s.add(n);
            }
            return rank0s;
        }

        private boolean pathFromTo(Node n1, Node n2) {
            HashMap<Node, Node> map2 = new HashMap<Node, Node>();
            return this.pathFromTo(n1, n2, map2);
        }

        private boolean pathFromTo(Node n1, Node n2, HashMap<Node, Node> map2) {
            if (n1 == n2) {
                return true;
            }
            if (map2.containsKey(n1)) {
                return false;
            }
            map2.put(n1, n1);
            for (int i = 0; i < n1.outRank(); ++i) {
                if (!this.pathFromTo((Node)n1.getSuccessor(i), n2, map2)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node
    extends GraphNode {
        private Node(Object o) {
            super(o);
        }

        private void removeAncestor(Node node) {
            this.predecessors.remove(node);
        }

        private int outRank() {
            return this.getNbrSucc();
        }

        private int inRank() {
            return this.getNbrPred();
        }

        private ArrayList<GraphNode> getAllPredecessors() {
            return this.predecessors;
        }

        private ArrayList<GraphNode> getAllSuccessors() {
            return this.successors;
        }

        private void removeSuccessor(int i) {
            this.successors.remove(i);
        }

        private void addAllPredecessors(ArrayList<? extends GraphNode> pred) {
            for (Node node : pred) {
                if (LinearTypeOrderBuilderImpl.this.order.pathFromTo(this, node)) continue;
                node.connect(this);
            }
        }

        private void addAllSuccessors(ArrayList<? extends GraphNode> successors1) {
            for (Node node : successors1) {
                if (LinearTypeOrderBuilderImpl.this.order.pathFromTo(node, this)) continue;
                this.connect(node);
            }
        }

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class TotalTypeOrder
    implements LinearTypeOrder {
        private int[] order;
        private int[] typeCodeToOrder;

        private TotalTypeOrder(String[] typeList, TypeSystem ts) throws CASException {
            this(TotalTypeOrder.encodeTypeList(typeList, ts), ts);
        }

        private static int[] encodeTypeList(String[] typeList, TypeSystem ts) throws CASException {
            int[] a = new int[typeList.length];
            LowLevelTypeSystem llts = (LowLevelTypeSystem)((Object)ts);
            for (int i = 0; i < a.length; ++i) {
                int t = llts.ll_getCodeForTypeName(typeList[i]);
                if (t == 0) {
                    CASException e = new CASException("TYPEORDER_UNKNOWN_TYPE", new String[]{typeList[i]});
                    throw e;
                }
                a[i] = t;
            }
            return a;
        }

        private TotalTypeOrder(int[] typeList, TypeSystem ts) {
            TypeSystemImpl tsi = (TypeSystemImpl)ts;
            this.order = typeList;
            this.typeCodeToOrder = new int[this.order.length + tsi.getSmallestType()];
            for (int i = 0; i < this.order.length; ++i) {
                this.typeCodeToOrder[this.order[i]] = i;
            }
        }

        public boolean lessThan(Type t1, Type t2) {
            return this.lessThan(((TypeImpl)t1).getCode(), ((TypeImpl)t2).getCode());
        }

        public boolean lessThan(int t1, int t2) {
            return this.typeCodeToOrder[t1] < this.typeCodeToOrder[t2];
        }

        public int[] getOrder() {
            return this.order;
        }
    }
}

