/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CommonArrayFSImpl;
import org.apache.uima.cas.impl.FSGenerator;

public class FloatArrayFSImpl
extends CommonArrayFSImpl
implements FloatArrayFS {
    public FloatArrayFSImpl(int addr, CASImpl cas) {
        super(cas, addr);
    }

    static FSGenerator generator() {
        return new FloatArrayFSGenerator();
    }

    public float get(int i) {
        this.casImpl.checkArrayBounds(this.addr, i);
        return this.casImpl.ll_getFloatArrayValue(this.addr, i);
    }

    public void set(int i, float value2) throws ArrayIndexOutOfBoundsException {
        this.casImpl.checkArrayBounds(this.addr, i);
        this.casImpl.ll_setFloatArrayValue(this.addr, i, value2);
    }

    public void copyFromArray(float[] src, int srcOffset, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, destOffset, length);
        int[] heap = this.casImpl.getHeap().heap;
        destOffset += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < length; ++i) {
            heap[i + destOffset] = CASImpl.float2int(src[i + srcOffset]);
        }
    }

    public void copyToArray(int srcOffset, float[] dest, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        int[] heap = this.casImpl.getHeap().heap;
        srcOffset += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = CASImpl.int2float(heap[i + srcOffset]);
        }
    }

    public float[] toArray() {
        int size2 = this.size();
        float[] outArray = new float[size2];
        this.copyToArray(0, outArray, 0, size2);
        return outArray;
    }

    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        int[] heap = this.casImpl.getHeap().heap;
        srcOffset += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Float.toString(CASImpl.int2float(heap[i + srcOffset]));
        }
    }

    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.casImpl.checkArrayBounds(this.addr, destOffset, length);
        int[] heap = this.casImpl.getHeap().heap;
        destOffset += this.casImpl.getArrayStartAddress(this.addr);
        for (int i = 0; i < length; ++i) {
            heap[i + destOffset] = CASImpl.float2int(Float.parseFloat(src[i + srcOffset]));
        }
    }

    private static class FloatArrayFSGenerator
    implements FSGenerator {
        private FloatArrayFSGenerator() {
        }

        public FeatureStructure createFS(int addr, CASImpl cas) {
            return new FloatArrayFSImpl(addr, cas);
        }
    }
}

