/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.TypeSystemImpl;

public class FeatureImpl
implements Feature {
    private final int code;
    private final String name;
    private final TypeSystemImpl ts;
    private final boolean isMultipleRefsAllowed;

    FeatureImpl(int code, String name, TypeSystemImpl ts, boolean isMultipleRefsAllowed) {
        this.code = code;
        this.name = name;
        this.ts = ts;
        this.isMultipleRefsAllowed = isMultipleRefsAllowed;
    }

    public int getCode() {
        return this.code;
    }

    public Type getDomain() {
        return this.ts.ll_getTypeForCode(this.ts.intro(this.code));
    }

    public Type getRange() {
        return this.ts.ll_getTypeForCode(this.ts.range(this.code));
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public String getShortName() {
        return this.name.substring(this.name.indexOf(58) + 1, this.name.length());
    }

    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    public int compareTo(Feature o) {
        if (this == o) {
            return 0;
        }
        FeatureImpl f2 = (FeatureImpl)o;
        return this.code < f2.code ? -1 : 1;
    }

    public boolean isMultipleReferencesAllowed() {
        return this.isMultipleRefsAllowed;
    }
}

