/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.apache.uima.cas.FSIndex;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.admin.FSIndexComparator;
import org.apache.uima.cas.admin.LinearTypeOrder;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FSIndexImpl;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.LinearTypeOrderBuilderImpl;
import org.apache.uima.cas.impl.StringTypeImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CASMgrSerializer
implements Serializable {
    public static final int SOURCE_JEDI = 0;
    public static final int SOURCE_TAF = 1;
    static final long serialVersionUID = 5549299679614131956L;
    public int[] typeOrder;
    public String[] indexNames;
    public int[] nameToIndexMap;
    public int[] indexingStrategy;
    public int[] comparatorIndex;
    public int[] comparators;
    public String[] typeNames = null;
    public String[] featureNames = null;
    public int[] typeInheritance;
    public int[] featDecls;
    public int topTypeCode;
    public int[] featureOffsets;
    public int[] stringSubtypes;
    public String[] stringSubtypeValues;
    public int[] stringSubtypeValuePos;
    public int source = 0;

    public void addIndexRepository(FSIndexRepositoryImpl ir) {
        this.typeOrder = ir.getDefaultTypeOrder().getOrder();
        ArrayList<String> names = new ArrayList<String>();
        Iterator<String> namesIt = ir.getLabels();
        while (namesIt.hasNext()) {
            String name = namesIt.next();
            if (ir.getIndex(name).getIndexingStrategy() == 3) continue;
            names.add(name);
        }
        int numNames = names.size();
        this.indexNames = new String[numNames];
        for (int i = 0; i < numNames; ++i) {
            String label;
            this.indexNames[i] = label = (String)names.get(i);
        }
        this.nameToIndexMap = new int[numNames];
        Vector<FSIndex<FeatureStructure>> indexVector = new Vector<FSIndex<FeatureStructure>>();
        for (int i = 0; i < numNames; ++i) {
            FSIndex<FeatureStructure> index = ir.getIndex(this.indexNames[i]);
            int pos = indexVector.indexOf(index);
            if (pos < 0) {
                indexVector.add(index);
                pos = indexVector.size() - 1;
            }
            this.nameToIndexMap[i] = pos;
        }
        int numIndexes = indexVector.size();
        this.indexingStrategy = new int[numIndexes];
        for (int i = 0; i < numIndexes; ++i) {
            this.indexingStrategy[i] = ((FSIndex)indexVector.get(i)).getIndexingStrategy();
        }
        this.comparatorIndex = new int[numIndexes];
        IntVector comps = new IntVector();
        int compPos = 0;
        for (int i = 0; i < numIndexes; ++i) {
            this.comparatorIndex[i] = compPos;
            FSIndexComparator comp = ((FSIndexImpl)indexVector.get(i)).getComparator();
            comps.add(((TypeImpl)comp.getType()).getCode());
            int numCompFeats = comp.getNumberOfKeys();
            for (int j = 0; j < numCompFeats; ++j) {
                switch (comp.getKeyType(j)) {
                    case 0: {
                        comps.add(((FeatureImpl)comp.getKeyFeature(j)).getCode());
                        break;
                    }
                    case 1: {
                        comps.add(0);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Internal serialization error.");
                    }
                }
                comps.add(comp.getKeyComparator(j));
            }
            compPos += 1 + 2 * numCompFeats;
        }
        this.comparators = comps.toArray();
    }

    public void addTypeSystem(TypeSystemImpl ts) {
        this.typeNames = CASMgrSerializer.symbolTable2StringArray(ts.getTypeNameST());
        this.encodeTypeInheritance(ts);
        this.encodeFeatureDecls(ts);
        this.encodeStringSubtypes(ts);
    }

    private void encodeStringSubtypes(TypeSystemImpl ts) {
        int i;
        Vector<Type> list2 = this.getStringSubtypes(ts);
        int size2 = list2.size();
        this.stringSubtypes = new int[size2];
        this.stringSubtypeValuePos = new int[size2];
        ArrayList<String> strVals = new ArrayList<String>();
        int pos = 0;
        for (i = 0; i < size2; ++i) {
            int typeCode;
            StringTypeImpl type = (StringTypeImpl)list2.get(i);
            this.stringSubtypes[i] = typeCode = type.getCode();
            this.stringSubtypeValuePos[i] = pos;
            String[] stringSet = ts.ll_getStringSet(typeCode);
            pos += stringSet.length;
            for (int j = 0; j < stringSet.length; ++j) {
                strVals.add(stringSet[j]);
            }
        }
        this.stringSubtypeValues = new String[strVals.size()];
        for (i = 0; i < strVals.size(); ++i) {
            this.stringSubtypeValues[i] = (String)strVals.get(i);
        }
    }

    private Vector<Type> getStringSubtypes(TypeSystemImpl ts) {
        return ts.getDirectlySubsumedTypes(ts.getType("uima.cas.String"));
    }

    static String[] symbolTable2StringArray(SymbolTable st) {
        int max2 = st.size();
        int offset = st.getStart();
        Object[] ar = new String[max2 + offset];
        Arrays.fill(ar, 0, offset, null);
        int j = offset;
        for (int i = 0; i < max2; ++i) {
            ar[j] = st.getSymbol(j);
            ++j;
        }
        return ar;
    }

    private void encodeFeatureDecls(TypeSystemImpl ts) {
        int max2 = ts.getSmallestFeature() + ts.getNumberOfFeatures();
        this.featureNames = new String[max2];
        this.featDecls = new int[max2 * 3];
        for (int i = ts.getSmallestFeature(); i < max2; ++i) {
            Feature f2 = ts.ll_getFeatureForCode(i);
            this.featureNames[i] = f2.getShortName();
            this.featDecls[i * 3] = ((TypeImpl)f2.getDomain()).getCode();
            this.featDecls[i * 3 + 1] = ((TypeImpl)f2.getRange()).getCode();
            this.featDecls[i * 3 + 2] = f2.isMultipleReferencesAllowed() ? 1 : 0;
        }
    }

    private void encodeTypeInheritance(TypeSystemImpl ts) {
        int max2 = ts.getSmallestType() + ts.getNumberOfTypes();
        this.typeInheritance = new int[max2];
        for (int i = ts.getSmallestType() + 1; i < max2; ++i) {
            TypeImpl parent = (TypeImpl)ts.getParent(ts.ll_getTypeForCode(i));
            this.typeInheritance[i] = parent.getCode();
        }
    }

    private int isStringSubtype(int type) {
        for (int i = 0; i < this.stringSubtypes.length; ++i) {
            if (this.stringSubtypes[i] != type) continue;
            return i;
        }
        return -1;
    }

    private String[] getSubarray(String[] array, int from2, int to2) {
        String[] sub = new String[to2 - from2];
        for (int i = from2; i < to2; ++i) {
            sub[i - from2] = array[i];
        }
        return sub;
    }

    private String[] getStringArray(int pos) {
        int end = pos == this.stringSubtypes.length - 1 ? this.stringSubtypeValues.length : this.stringSubtypeValuePos[pos + 1];
        return this.getSubarray(this.stringSubtypeValues, this.stringSubtypeValuePos[pos], end);
    }

    public TypeSystemImpl getTypeSystem() {
        String name;
        TypeSystemImpl ts = new TypeSystemImpl();
        for (int i = 2; i < this.typeNames.length; ++i) {
            name = this.typeNames[i];
            int pos = this.isStringSubtype(i);
            if (pos >= 0) {
                ts.addStringSubtype(name, this.getStringArray(pos));
                continue;
            }
            if (TypeSystemImpl.isArrayTypeNameButNotBuiltIn(name)) {
                ts.getArrayType(ts.getType(TypeSystemImpl.getArrayComponentName(name)));
                continue;
            }
            ts.addType(name, this.typeInheritance[i]);
        }
        int max2 = this.featureNames.length;
        for (int i = 1; i < max2; ++i) {
            name = this.featureNames[i];
            ts.addFeature(name, this.featDecls[i * 3], this.featDecls[i * 3 + 1], this.featDecls[i * 3 + 2] == 1);
        }
        return ts;
    }

    public FSIndexRepositoryImpl getIndexRepository(CASImpl cas) {
        int i;
        FSIndexRepositoryImpl ir = new FSIndexRepositoryImpl(cas);
        ir.setDefaultTypeOrder(LinearTypeOrderBuilderImpl.createTypeOrder(this.typeOrder, cas.getTypeSystem()));
        int max2 = this.indexNames.length;
        int pos = 0;
        if (this.nameToIndexMap == null) {
            this.nameToIndexMap = new int[max2];
            for (i = 0; i < max2; ++i) {
                this.nameToIndexMap[i] = i;
            }
        }
        for (i = 0; i < max2; ++i) {
            FSIndexComparator comp = ir.createComparator();
            pos = this.comparatorIndex[this.nameToIndexMap[i]];
            Type type = cas.getTypeSystemImpl().ll_getTypeForCode(this.comparators[pos]);
            comp.setType(type);
            ++pos;
            int next2 = this.nameToIndexMap[i] + 1;
            int maxComp = next2 < max2 ? this.comparatorIndex[next2] : this.comparators.length;
            TypeSystemImpl tsi = (TypeSystemImpl)cas.getTypeSystem();
            while (pos < maxComp) {
                if (this.comparators[pos] > 0) {
                    Feature feat = tsi.ll_getFeatureForCode(this.comparators[pos]);
                    comp.addKey(feat, this.comparators[++pos]);
                } else {
                    LinearTypeOrder order = ir.getDefaultTypeOrder();
                    comp.addKey(order, this.comparators[++pos]);
                }
                ++pos;
            }
            ir.createIndex(comp, this.indexNames[i], this.indexingStrategy[this.nameToIndexMap[i]]);
        }
        ir.commit();
        return ir;
    }
}

