/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.TypeOrFeature;
import org.apache.uima.analysis_engine.impl.TypeOrFeature_impl;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.Language;
import org.apache.uima.resource.metadata.Capability;
import org.apache.uima.resource.metadata.impl.MetaDataObject_impl;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResultSpecification_impl
extends MetaDataObject_impl
implements ResultSpecification {
    private static final long serialVersionUID = 8516517600467270594L;
    private static final int UNSPECIFIED_LANGUAGE_INDEX = 0;
    private static final char LANGUAGE_SEPARATOR = '-';
    private boolean needsCompilation = true;
    private final Map<String, Integer> lang2int;
    private final Map<String, ToF_Languages> name2tof_langs;
    private final Map<String, ToF_Languages> withSubtypesName2tof_langs;
    private static final String[] mDefaultLanguage = new String[]{"x-unspecified"};
    private TypeSystem mTypeSystem;

    public ResultSpecification_impl() {
        this.name2tof_langs = new HashMap<String, ToF_Languages>();
        this.withSubtypesName2tof_langs = new HashMap<String, ToF_Languages>();
        this.lang2int = new HashMap<String, Integer>();
        this.lang2int.put("x-unspecified", 0);
    }

    public ResultSpecification_impl(TypeSystem aTypeSystem) {
        this();
        this.mTypeSystem = aTypeSystem;
    }

    private ResultSpecification_impl(ResultSpecification_impl original) {
        this.name2tof_langs = new HashMap<String, ToF_Languages>(original.name2tof_langs.size());
        this.withSubtypesName2tof_langs = new HashMap<String, ToF_Languages>(original.withSubtypesName2tof_langs.size());
        this.lang2int = new HashMap<String, Integer>(original.lang2int);
        for (Map.Entry<String, ToF_Languages> entry : original.name2tof_langs.entrySet()) {
            ToF_Languages tof_langs = entry.getValue();
            this.name2tof_langs.put(entry.getKey(), new ToF_Languages(tof_langs.tof, (BitSet)tof_langs.languages.clone()));
        }
        this.mTypeSystem = original.mTypeSystem;
    }

    private int getBaseLanguageIndex(String language) {
        return this.getLanguageIndex(this.getBaseLanguage(language));
    }

    private int getLanguageIndex(String language) {
        Integer r = this.lang2int.get(language);
        if (null == r) {
            int i = this.lang2int.size();
            this.lang2int.put(language, i);
            return i;
        }
        return r;
    }

    private void compileIfNeeded() {
        if (this.needsCompilation) {
            this.compile();
        }
    }

    private String getBaseLanguage(String language) {
        String baseLanguage = language;
        int index = language.indexOf(45);
        if (index > -1) {
            baseLanguage = language.substring(0, index);
        }
        return baseLanguage;
    }

    @Override
    public TypeOrFeature[] getResultTypesAndFeatures() {
        TypeOrFeature[] arr = new TypeOrFeature[this.name2tof_langs.size()];
        int i = 0;
        for (ToF_Languages tof_langs : this.name2tof_langs.values()) {
            arr[i++] = tof_langs.tof;
        }
        return arr;
    }

    private Map<String, ToF_Languages> availName2tof_langs() {
        if (this.needsCompilation) {
            return this.name2tof_langs;
        }
        return this.withSubtypesName2tof_langs;
    }

    @Override
    public TypeOrFeature[] getResultTypesAndFeatures(String language) {
        int languageIndex = this.getLanguageIndex(language);
        int baseLanguageIndex = this.getBaseLanguageIndex(language);
        ArrayList<TypeOrFeature> foundToF = new ArrayList<TypeOrFeature>();
        for (Map.Entry<String, ToF_Languages> entry : this.name2tof_langs.entrySet()) {
            if (!this.languageMatches(entry.getValue(), languageIndex, baseLanguageIndex)) continue;
            foundToF.add(entry.getValue().tof);
        }
        return foundToF.toArray(new TypeOrFeature[foundToF.size()]);
    }

    private String[] normalizeLanguages(String[] languages) {
        if (null == languages) {
            return mDefaultLanguage;
        }
        for (String lang : languages) {
            if (!lang.equals("x-unspecified")) continue;
            return mDefaultLanguage;
        }
        return languages;
    }

    private void setNeedsCompilation() {
        this.needsCompilation = true;
        if (0 != this.withSubtypesName2tof_langs.size()) {
            this.withSubtypesName2tof_langs.clear();
        }
    }

    private void addTypeOrFeatureInternal(TypeOrFeature tof, String[] languages) {
        languages = this.normalizeLanguages(languages);
        ToF_Languages tof_langs = this.name2tof_langs.get(tof.getName());
        if (null == tof_langs) {
            this.name2tof_langs.put(tof.getName(), new ToF_Languages(tof, languages));
            this.setNeedsCompilation();
            return;
        }
        tof_langs.tof.setAllAnnotatorFeatures(tof.isAllAnnotatorFeatures());
        BitSet langBitSet = tof_langs.languages;
        langBitSet.clear();
        for (String lang : languages) {
            langBitSet.set(this.getLanguageIndex(lang));
        }
        this.setNeedsCompilation();
    }

    private TypeOrFeature createTypeOrFeature(String name, boolean isType, boolean aAllAnnotatorFeatures) {
        TypeOrFeature_impl r = new TypeOrFeature_impl();
        r.setType(isType);
        r.setName(name);
        if (isType) {
            r.setAllAnnotatorFeatures(aAllAnnotatorFeatures);
        }
        return r;
    }

    private void addResultTypeOrFeatureAddLanguage(String name, boolean isType, boolean allAnnotatorFeatures, String[] languages) {
        ToF_Languages tof_langs = this.name2tof_langs.get(name);
        if (null == tof_langs) {
            this.addTypeOrFeatureInternal(this.createTypeOrFeature(name, isType, allAnnotatorFeatures), languages);
            this.setNeedsCompilation();
            return;
        }
        this.addResultTypeOrFeatureAddLanguageCommon(tof_langs, allAnnotatorFeatures, languages);
    }

    private void addResultTypeOrFeatureAddLanguage(TypeOrFeature tof, String[] languages) {
        ToF_Languages tof_langs = this.name2tof_langs.get(tof.getName());
        if (null == tof_langs) {
            this.addTypeOrFeatureInternal(tof, languages);
            this.setNeedsCompilation();
            return;
        }
        this.addResultTypeOrFeatureAddLanguageCommon(tof_langs, tof.isAllAnnotatorFeatures(), languages);
    }

    private void addResultTypeOrFeatureAddLanguageCommon(ToF_Languages tof_langs, boolean allAnnotatorFeatures, String[] languages) {
        if (allAnnotatorFeatures && !tof_langs.tof.isAllAnnotatorFeatures()) {
            tof_langs.tof.setAllAnnotatorFeatures(true);
            this.setNeedsCompilation();
        }
        languages = this.normalizeLanguages(languages);
        BitSet langBitSet = tof_langs.languages;
        if (languages == mDefaultLanguage) {
            if (!langBitSet.get(0)) {
                langBitSet.clear();
                langBitSet.set(0);
                this.setNeedsCompilation();
            }
            return;
        }
        for (String lang : languages) {
            langBitSet.set(this.getLanguageIndex(lang));
        }
        this.setNeedsCompilation();
    }

    private void addResultType(String name, boolean allAnnotatorFeatures, BitSet languages) {
        ToF_Languages tof_langs = this.withSubtypesName2tof_langs.get(name);
        if (null == tof_langs) {
            this.withSubtypesName2tof_langs.put(name, new ToF_Languages(this.createTypeOrFeature(name, true, allAnnotatorFeatures), (BitSet)languages.clone()));
            return;
        }
        if (allAnnotatorFeatures && !tof_langs.tof.isAllAnnotatorFeatures()) {
            tof_langs.tof.setAllAnnotatorFeatures(true);
        }
        tof_langs.languages.or(languages);
    }

    @Override
    public void setResultTypesAndFeatures(TypeOrFeature[] aTypesAndFeatures) {
        this.setResultTypesAndFeatures(aTypesAndFeatures, mDefaultLanguage);
    }

    @Override
    public void setResultTypesAndFeatures(TypeOrFeature[] aTypesAndFeatures, String[] aLanguageIDs) {
        this.name2tof_langs.clear();
        for (TypeOrFeature tof : aTypesAndFeatures) {
            this.name2tof_langs.put(tof.getName(), new ToF_Languages(tof, this.normalizeLanguages(aLanguageIDs)));
        }
        this.setNeedsCompilation();
    }

    @Override
    public void addResultTypeOrFeature(TypeOrFeature aTypeOrFeature) {
        this.addTypeOrFeatureInternal(aTypeOrFeature, mDefaultLanguage);
    }

    @Override
    public void addResultTypeOrFeature(TypeOrFeature aTypeOrFeature, String[] aLanguageIDs) {
        this.addTypeOrFeatureInternal(aTypeOrFeature, aLanguageIDs);
    }

    @Override
    public void addResultType(String aTypeName, boolean aAllAnnotatorFeatures) {
        this.addTypeOrFeatureInternal(this.createTypeOrFeature(aTypeName, true, aAllAnnotatorFeatures), mDefaultLanguage);
    }

    @Override
    public void addResultType(String aTypeName, boolean aAllAnnotatorFeatures, String[] aLanguageIDs) {
        this.addResultTypeOrFeatureAddLanguage(aTypeName, true, aAllAnnotatorFeatures, aLanguageIDs);
    }

    @Override
    public void addResultFeature(String aFullFeatureName) {
        this.addResultFeature(aFullFeatureName, mDefaultLanguage);
    }

    @Override
    public void addResultFeature(String aFullFeatureName, String[] aLanguageIDs) {
        this.addResultTypeOrFeatureAddLanguage(aFullFeatureName, false, false, aLanguageIDs);
    }

    @Override
    public void compile(TypeSystem aTypeSystem) {
        this.setTypeSystem(aTypeSystem);
        this.compileIfNeeded();
    }

    private void compile() {
        if (null == this.mTypeSystem) {
            return;
        }
        this.needsCompilation = false;
        for (ToF_Languages tof_langs : this.name2tof_langs.values()) {
            TypeOrFeature tof = tof_langs.tof;
            this.addResultType(tof.getName(), tof.isAllAnnotatorFeatures(), tof_langs.languages);
            if (!tof.isType()) continue;
            this.compileTypeRecursively(this.mTypeSystem.getType(tof.getName()), tof.isAllAnnotatorFeatures(), tof_langs.languages);
        }
    }

    private void compileTypeRecursively(Type type, boolean allFeatures, BitSet languages) {
        if (null != type) {
            for (Type subType : this.mTypeSystem.getDirectSubtypes(type)) {
                String subTypeName = subType.getName();
                this.addResultType(subTypeName, allFeatures, languages);
                this.compileTypeRecursively(subType, allFeatures, languages);
            }
        }
    }

    @Override
    public boolean containsType(String aTypeName) {
        return this.containsType(aTypeName, "x-unspecified");
    }

    @Override
    public boolean containsType(String aTypeName, String language) {
        language = Language.normalize(language);
        if (aTypeName.indexOf(58) != -1) {
            return false;
        }
        this.compileIfNeeded();
        return this.languageMatches(this.availName2tof_langs().get(aTypeName), language);
    }

    @Override
    public boolean containsFeature(String aFullFeatureName) {
        return this.containsFeature(aFullFeatureName, "x-unspecified");
    }

    @Override
    public boolean containsFeature(String aFullFeatureName, String language) {
        language = Language.normalize(language);
        int typeEndPosition = aFullFeatureName.indexOf(58);
        if (typeEndPosition == -1) {
            return false;
        }
        this.compileIfNeeded();
        ToF_Languages tof_langs = this.name2tof_langs.get(aFullFeatureName);
        if (this.languageMatches(tof_langs, language)) {
            return true;
        }
        tof_langs = this.availName2tof_langs().get(aFullFeatureName.substring(0, typeEndPosition));
        if (null != tof_langs && tof_langs.tof.isAllAnnotatorFeatures() && this.languageMatches(tof_langs, language)) {
            if (null != this.mTypeSystem) {
                return null != this.mTypeSystem.getFeatureByFullName(aFullFeatureName);
            }
            return true;
        }
        return false;
    }

    private boolean languageMatches(ToF_Languages tof_langs, String language) {
        if (null == tof_langs) {
            return false;
        }
        BitSet languages = tof_langs.languages;
        if (languages.get(0) || languages.get(this.getLanguageIndex(language))) {
            return true;
        }
        String baseLanguage = this.getBaseLanguage(language);
        return baseLanguage != language && languages.get(this.getLanguageIndex(baseLanguage));
    }

    private boolean languageMatches(ToF_Languages tof_langs, int languageIndex, int baseLanguageIndex) {
        if (null == tof_langs) {
            return false;
        }
        BitSet languages = tof_langs.languages;
        if (languages.get(0) || languages.get(languageIndex)) {
            return true;
        }
        return baseLanguageIndex != languageIndex && languages.get(baseLanguageIndex);
    }

    @Override
    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo("resultSpecification", null, new PropertyXmlInfo[]{new PropertyXmlInfo("resultTypesAndFeatures", null)});
    }

    @Override
    public void addCapabilities(Capability[] capabilities) {
        this.addCapabilities(capabilities, true);
    }

    @Override
    public void addCapabilities(Capability[] capabilities, boolean outputs) {
        if (null == capabilities) {
            return;
        }
        for (Capability capability : capabilities) {
            TypeOrFeature[] tofs = outputs ? capability.getOutputs() : capability.getInputs();
            String[] supportedLanguages = capability.getLanguagesSupported();
            if (null == supportedLanguages || supportedLanguages.length == 0) {
                supportedLanguages = mDefaultLanguage;
            }
            for (TypeOrFeature tof : tofs) {
                this.addResultTypeOrFeatureAddLanguage(tof, supportedLanguages);
            }
        }
        this.setNeedsCompilation();
    }

    @Override
    public void removeTypeOrFeature(TypeOrFeature aTypeOrFeature) {
        this.name2tof_langs.remove(aTypeOrFeature.getName());
        this.setNeedsCompilation();
    }

    @Override
    public Object clone() {
        return new ResultSpecification_impl(this);
    }

    @Override
    public void setTypeSystem(TypeSystem ts) {
        if (this.mTypeSystem == ts) {
            return;
        }
        this.mTypeSystem = ts;
        this.setNeedsCompilation();
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.mTypeSystem;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("org.apache.uima.analysis_engine.impl.ResultSpecification_impl:\n);");
        sb.append("needsCompilation = ").append(this.needsCompilation).append("\n");
        sb.append("lang2int = ").append(this.lang2int).append("\n");
        sb.append("name2tof_langs = ").append(this.name2tof_langs).append("\n");
        sb.append("withSubtypesName2tof_langs = ").append(this.withSubtypesName2tof_langs).append("\n");
        sb.append("mTypeSystem = ").append(this.mTypeSystem).append("\n");
        return sb.toString();
    }

    private class ToF_Languages
    implements Cloneable {
        public TypeOrFeature tof;
        public BitSet languages;

        ToF_Languages(TypeOrFeature aTof, String[] aLanguages) {
            this.tof = aTof;
            this.languages = new BitSet();
            for (String lang : aLanguages) {
                this.languages.set(ResultSpecification_impl.this.getLanguageIndex(lang));
            }
        }

        ToF_Languages(TypeOrFeature aTof, BitSet aLanguages) {
            this.tof = aTof;
            this.languages = aLanguages;
        }

        public Object clone() {
            return new ToF_Languages((TypeOrFeature)this.tof.clone(), (BitSet)this.languages.clone());
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.languages == null ? 0 : this.languages.hashCode());
            result2 = 31 * result2 + (this.tof == null ? 0 : this.tof.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ToF_Languages other = (ToF_Languages)obj;
            if (this.languages == null ? other.languages != null : !this.languages.equals(other.languages)) {
                return false;
            }
            return !(this.tof == null ? other.tof != null : !this.tof.equals(other.tof));
        }
    }
}

