/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.CasIterator;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.impl.AnalysisEngineImplBase;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.impl.ChildUimaContext_impl;
import org.apache.uima.pear.tools.PackageBrowser;
import org.apache.uima.resource.PearSpecifier;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceManagerPearWrapper;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Level;
import org.apache.uima.util.ProcessTrace;
import org.apache.uima.util.XMLInputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PearAnalysisEngineWrapper
extends AnalysisEngineImplBase {
    private static Map<ResourceManager, Map<StringPair, ResourceManager>> cachedResourceManagers = new WeakHashMap<ResourceManager, Map<StringPair, ResourceManager>>(4);
    private AnalysisEngine ae = null;

    private Map<StringPair, ResourceManager> createRMmap(StringPair sp2, ResourceManager rm) {
        HashMap<StringPair, ResourceManager> result2 = new HashMap<StringPair, ResourceManager>(4);
        result2.put(sp2, rm);
        UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "createRMmap", "org.apache.uima.impl.log_messages", "UIMA_pear_runtime_create_RM_map", new Object[]{sp2.classPath, sp2.dataPath});
        return result2;
    }

    private synchronized ResourceManager createRM(StringPair sp2, PackageBrowser pkgBrowser, ResourceManager parentResourceManager) throws MalformedURLException {
        ResourceManager rsrcMgr;
        if (null == parentResourceManager) {
            rsrcMgr = UIMAFramework.newDefaultResourceManager();
        } else {
            rsrcMgr = UIMAFramework.newDefaultResourceManagerPearWrapper();
            ((ResourceManagerPearWrapper)rsrcMgr).initializeFromParentResourceManager(parentResourceManager);
        }
        rsrcMgr.setExtensionClassPath(sp2.classPath, true);
        UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "createRM", "org.apache.uima.impl.log_messages", "UIMA_pear_runtime_set_classpath__CONFIG", new Object[]{sp2.classPath, pkgBrowser.getRootDirectory().getName()});
        if (sp2.dataPath != null) {
            rsrcMgr.setDataPath(sp2.dataPath);
            UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "createRM", "org.apache.uima.impl.log_messages", "UIMA_pear_runtime_set_datapath__CONFIG", new Object[]{sp2.dataPath, pkgBrowser.getRootDirectory().getName()});
        }
        return rsrcMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initialize(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        if (!(aSpecifier instanceof PearSpecifier)) {
            return false;
        }
        PearSpecifier pearSpec = (PearSpecifier)aSpecifier;
        String pearRootDirPath = pearSpec.getPearPath();
        try {
            UimaContextAdmin uimaContext;
            ResourceManager innerRM;
            ResourceManager applicationRM;
            File pearRootDir = new File(pearRootDirPath);
            PackageBrowser pkgBrowser = new PackageBrowser(pearRootDir);
            Properties systemProps = System.getProperties();
            Properties props = pkgBrowser.getComponentEnvVars();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String systemPropValue;
                String key = (String)entry.getKey();
                String value2 = (String)entry.getValue();
                if (systemProps.containsKey(key) && !(systemPropValue = (String)systemProps.get(key)).equals(value2)) {
                    UIMAFramework.getLogger(this.getClass()).logrb(Level.WARNING, this.getClass().getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_pear_runtime_system_var_already_set__WARNING", new Object[]{key + "=" + systemPropValue, key + "=" + value2, pkgBrowser.getRootDirectory().getName()});
                }
                System.setProperty(key, value2);
                UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_pear_runtime_set_system_var__CONFIG", new Object[]{key + "=" + value2, pkgBrowser.getRootDirectory().getName()});
            }
            ResourceManager resourceManager = applicationRM = aAdditionalParams == null ? null : (ResourceManager)aAdditionalParams.get("RESOURCE_MANAGER");
            if (null == applicationRM) {
                UimaContextAdmin uimaContext2;
                UimaContextAdmin uimaContextAdmin = uimaContext2 = aAdditionalParams == null ? null : (UimaContextAdmin)aAdditionalParams.get("UIMA_CONTEXT");
                if (null != uimaContext2) {
                    applicationRM = uimaContext2.getResourceManager();
                }
            }
            String classPath = pkgBrowser.buildComponentRuntimeClassPath();
            String dataPath = pkgBrowser.getComponentDataPath();
            StringPair sp2 = new StringPair(classPath, dataPath);
            Map<ResourceManager, Map<StringPair, ResourceManager>> map2 = cachedResourceManagers;
            synchronized (map2) {
                Map<StringPair, ResourceManager> c1 = cachedResourceManagers.get(applicationRM);
                if (null == c1) {
                    innerRM = this.createRM(sp2, pkgBrowser, applicationRM);
                    cachedResourceManagers.put(applicationRM, this.createRMmap(sp2, innerRM));
                } else {
                    innerRM = c1.get(sp2);
                    if (null == innerRM) {
                        innerRM = this.createRM(sp2, pkgBrowser, applicationRM);
                        c1.put(sp2, innerRM);
                        UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_pear_runtime_add_RM_map", new Object[]{sp2.classPath, sp2.dataPath});
                    }
                }
            }
            XMLInputSource in = new XMLInputSource(pkgBrowser.getInstallationDescriptor().getMainComponentDesc());
            ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
            UimaContextAdmin uimaContextAdmin = uimaContext = aAdditionalParams == null ? null : (UimaContextAdmin)aAdditionalParams.get("UIMA_CONTEXT");
            if (null != uimaContext) {
                ((ChildUimaContext_impl)uimaContext).setPearResourceManager(innerRM);
            }
            HashMap<String, Object> clonedAdditionalParameters = aAdditionalParams == null ? new HashMap<String, Object>() : new HashMap<String, Object>(aAdditionalParams);
            clonedAdditionalParameters.remove("RESOURCE_MANAGER");
            this.ae = UIMAFramework.produceAnalysisEngine(specifier, innerRM, clonedAdditionalParameters);
        }
        catch (IOException ex) {
            throw new ResourceInitializationException(ex);
        }
        catch (InvalidXMLException ex) {
            throw new ResourceInitializationException(ex);
        }
        super.initialize(aSpecifier, aAdditionalParams);
        UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "initialize", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_init_successful__CONFIG", new Object[]{this.ae.getAnalysisEngineMetaData().getName()});
        return true;
    }

    @Override
    public AnalysisEngineMetaData getAnalysisEngineMetaData() {
        return (AnalysisEngineMetaData)this.getMetaData();
    }

    @Override
    public ResourceMetaData getMetaData() {
        return this.ae.getMetaData();
    }

    @Override
    public void batchProcessComplete() throws AnalysisEngineProcessException {
        this.ae.batchProcessComplete();
    }

    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        this.ae.collectionProcessComplete();
    }

    @Override
    public CasIterator processAndOutputNewCASes(CAS aCAS) throws AnalysisEngineProcessException {
        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINE, this.getClass().getName(), "processAndOutputNewCASes", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_begin__FINE", new Object[]{this.ae.getAnalysisEngineMetaData().getName()});
        CasIterator result2 = this.ae.processAndOutputNewCASes(aCAS);
        UIMAFramework.getLogger(this.getClass()).logrb(Level.FINE, this.getClass().getName(), "processAndOutputNewCASes", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_process_end__FINE", new Object[]{this.ae.getAnalysisEngineMetaData().getName()});
        return result2;
    }

    @Override
    public void destroy() {
        UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "destroy", "org.apache.uima.impl.log_messages", "UIMA_analysis_engine_destroyed__CONFIG", new Object[]{this.ae.getAnalysisEngineMetaData().getName()});
        this.ae.destroy();
    }

    @Override
    public void reconfigure() throws ResourceConfigurationException {
        this.ae.reconfigure();
    }

    @Override
    protected void buildProcessTraceFromMBeanStats(ProcessTrace trace) {
        ((AnalysisEngineImplBase)this.ae).buildProcessTraceFromMBeanStats(trace);
    }

    @Override
    protected void enterBatchProcessComplete() {
        ((AnalysisEngineImplBase)this.ae).enterBatchProcessComplete();
    }

    @Override
    protected void enterCollectionProcessComplete() {
        ((AnalysisEngineImplBase)this.ae).enterCollectionProcessComplete();
    }

    @Override
    protected void enterProcess() {
        ((AnalysisEngineImplBase)this.ae).enterProcess();
    }

    @Override
    protected void exitBatchProcessComplete() {
        ((AnalysisEngineImplBase)this.ae).exitBatchProcessComplete();
    }

    @Override
    protected void exitCollectionProcessComplete() {
        ((AnalysisEngineImplBase)this.ae).exitCollectionProcessComplete();
    }

    @Override
    protected void exitProcess() {
        ((AnalysisEngineImplBase)this.ae).exitProcess();
    }

    @Override
    protected String getMBeanNamePrefix() {
        return ((AnalysisEngineImplBase)this.ae).getMBeanNamePrefix();
    }

    @Override
    protected Object getMBeanServer() {
        return ((AnalysisEngineImplBase)this.ae).getMBeanServer();
    }

    @Override
    public Properties getPerformanceTuningSettings() {
        return this.ae.getPerformanceTuningSettings();
    }

    @Override
    protected boolean isProcessTraceEnabled() {
        return ((AnalysisEngineImplBase)this.ae).isProcessTraceEnabled();
    }

    @Override
    protected void setPerformanceTuningSettings(Properties aSettings) {
        ((AnalysisEngineImplBase)this.ae).setPerformanceTuningSettings(aSettings);
    }

    @Override
    public UimaContext getUimaContext() {
        return this.ae.getUimaContext();
    }

    @Override
    public UimaContextAdmin getUimaContextAdmin() {
        return this.ae.getUimaContextAdmin();
    }

    @Override
    protected void setMetaData(ResourceMetaData aMetaData) {
        ((AnalysisEngineImplBase)this.ae).setMetaData(aMetaData);
    }

    @Override
    public void setResultSpecification(ResultSpecification resultSpec) {
        this.ae.setResultSpecification(resultSpec);
    }

    @Override
    public void batchProcessComplete(ProcessTrace trace) throws ResourceProcessException, IOException {
        this.ae.batchProcessComplete(trace);
    }

    @Override
    public void collectionProcessComplete(ProcessTrace trace) throws ResourceProcessException, IOException {
        this.ae.collectionProcessComplete(trace);
    }

    @Override
    public ResultSpecification createResultSpecification() {
        return this.ae.createResultSpecification();
    }

    @Override
    public ResultSpecification createResultSpecification(TypeSystem typeSystem) {
        return this.ae.createResultSpecification(typeSystem);
    }

    @Override
    public ProcessingResourceMetaData getProcessingResourceMetaData() {
        return this.ae.getProcessingResourceMetaData();
    }

    @Override
    public synchronized CAS newCAS() throws ResourceInitializationException {
        return this.ae.newCAS();
    }

    @Override
    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        this.ae.typeSystemInit(typeSystem);
    }

    private static class StringPair {
        private String classPath;
        private String dataPath;

        public StringPair(String classPath, String dataPath) {
            this.classPath = classPath;
            this.dataPath = dataPath;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.classPath == null ? 0 : this.classPath.hashCode());
            result2 = 31 * result2 + (this.dataPath == null ? 0 : this.dataPath.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringPair other = (StringPair)obj;
            if (this.classPath == null ? other.classPath != null : !this.classPath.equals(other.classPath)) {
                return false;
            }
            return !(this.dataPath == null ? other.dataPath != null : !this.dataPath.equals(other.dataPath));
        }
    }
}

