/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.soap.axis11;

import java.io.IOException;
import java.io.Serializable;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axis.Message;
import org.apache.axis.Part;
import org.apache.axis.attachments.Attachments;
import org.apache.axis.attachments.OctetStream;
import org.apache.axis.attachments.OctetStreamDataSource;
import org.apache.axis.encoding.Base64;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.uima.internal.util.SerializationUtils;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class BinarySerializer_Axis11
implements Serializer {
    private static final long serialVersionUID = -1968145589342023832L;
    private boolean mUseAttachments;

    public BinarySerializer_Axis11() {
        this(true);
    }

    public BinarySerializer_Axis11(boolean aUseAttachments) {
        this.mUseAttachments = aUseAttachments;
    }

    public void serialize(QName name, Attributes attributes, Object value2, SerializationContext context) throws IOException {
        if (value2 instanceof Serializable) {
            boolean useAttachments;
            byte[] bytes = SerializationUtils.serialize((Serializable)value2);
            Message msg = context.getCurrentMessage();
            Attachments attachments = msg.getAttachmentsImpl();
            boolean bl = useAttachments = attachments != null && this.mUseAttachments;
            if (useAttachments) {
                boolean bl2 = useAttachments = !context.getMessageContext().getPastPivot() || context.getMessageContext().getRequestMessage().getAttachments().hasNext();
            }
            if (useAttachments) {
                SOAPConstants soapConstants = context.getMessageContext().getSOAPConstants();
                DataHandler dataHandler = new DataHandler(new OctetStreamDataSource("test", new OctetStream(bytes)));
                Part attachmentPart = attachments.createAttachmentPart(dataHandler);
                AttributesImpl attrs = new AttributesImpl();
                if (attributes != null && 0 < attributes.getLength()) {
                    attrs.setAttributes(attributes);
                }
                int typeIndex = -1;
                typeIndex = attrs.getIndex("http://www.w3.org/2001/XMLSchema-instance", "type");
                if (typeIndex != -1) {
                    attrs.removeAttribute(typeIndex);
                }
                attrs.addAttribute("", soapConstants.getAttrHref(), soapConstants.getAttrHref(), "CDATA", attachmentPart.getContentIdRef());
                context.startElement(name, attrs);
                context.endElement();
            } else {
                context.startElement(name, attributes);
                String base64str = Base64.encode(bytes);
                context.writeChars(base64str.toCharArray(), 0, base64str.length());
                context.endElement();
            }
        } else {
            throw new IOException(value2.getClass().getName() + " is not serializable.");
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        return null;
    }
}

