/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.attachments.AttachmentUtils;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.uima.adapter.soap.AxisResourceServiceStub;
import org.apache.uima.adapter.soap.BinaryDeserializerFactory;
import org.apache.uima.adapter.soap.BinarySerializerFactory;
import org.apache.uima.adapter.soap.XmlDeserializerFactory;
import org.apache.uima.adapter.soap.XmlSerializerFactory;
import org.apache.uima.analysis_engine.AnalysisEngineServiceStub;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.service.impl.ServiceDataCargo;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.resource.ResourceServiceException;

public class AxisAnalysisEngineServiceStub
extends AxisResourceServiceStub
implements AnalysisEngineServiceStub {
    private boolean mUseAttachments;

    public AxisAnalysisEngineServiceStub(String aEndpoint, Integer aTimeout) throws MalformedURLException {
        this(aEndpoint, aTimeout, false);
    }

    public AxisAnalysisEngineServiceStub(String aEndpoint, Integer aTimeout, boolean aUseAttachments) throws MalformedURLException {
        super(aEndpoint, aTimeout);
        this.mUseAttachments = aUseAttachments;
    }

    public void callProcess(CAS aCAS) throws ResourceServiceException {
        QName operationQName = new QName("http://uima.apache.org/analysis_engine", "process");
        QName resultSpecTypeQName = new QName("http://uima.apache.org/analysis_engine", "resultSpecification");
        QName serviceDataCargoTypeQName = new QName("http://uima.apache.org/analysis_engine", "serviceDataCargo");
        try {
            Service service = new Service();
            Call call = (Call)service.createCall();
            call.setTargetEndpointAddress(this.getServiceEndpoint());
            call.setTimeout(this.getTimeout());
            call.setOperationName(operationQName);
            call.registerTypeMapping(ResultSpecification.class, resultSpecTypeQName, new XmlSerializerFactory(), new XmlDeserializerFactory());
            call.registerTypeMapping(ServiceDataCargo.class, serviceDataCargoTypeQName, new BinarySerializerFactory(this.mUseAttachments), new BinaryDeserializerFactory());
            ServiceDataCargo dataCargo = new ServiceDataCargo(aCAS, null);
            Object result2 = call.invoke(new Object[]{dataCargo, null});
            ServiceDataCargo resultCargo = null;
            if (result2 instanceof AttachmentPart) {
                ObjectInputStream objStream = null;
                try {
                    DataHandler dataHandler = AttachmentUtils.getActivationDataHandler((AttachmentPart)result2);
                    Object content = dataHandler.getContent();
                    objStream = new ObjectInputStream((InputStream)content);
                    resultCargo = (ServiceDataCargo)objStream.readObject();
                }
                catch (IOException e) {
                    throw new ResourceServiceException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new ResourceServiceException(e);
                }
                finally {
                    if (objStream != null) {
                        try {
                            objStream.close();
                        }
                        catch (IOException e) {
                            throw new ResourceServiceException(e);
                        }
                    }
                }
            }
            if (result2 instanceof ServiceDataCargo) {
                resultCargo = (ServiceDataCargo)result2;
            } else {
                throw new ResourceServiceException("unexpected_service_return_value_type", new Object[]{ServiceDataCargo.class.getName(), resultCargo == null ? "null" : resultCargo.getClass().getName()});
            }
            resultCargo.unmarshalCas(aCAS, false);
        }
        catch (ServiceException e) {
            throw new ResourceServiceException(e);
        }
        catch (RemoteException e) {
            throw new ResourceServiceException(e);
        }
        catch (CASException e) {
            throw new ResourceServiceException(e);
        }
    }

    public void destroy() {
    }

    public void callBatchProcessComplete() throws ResourceServiceException {
    }

    public void callCollectionProcessComplete() throws ResourceServiceException {
    }
}

