/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public final class BitVector
implements Cloneable {
    private byte[] bits;
    private int size;
    private int count;
    private static final byte[] BYTE_COUNTS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BitVector(int n) {
        this.size = n;
        this.bits = new byte[(this.size >> 3) + 1];
        this.count = 0;
    }

    BitVector(byte[] bits2, int size2) {
        this.bits = bits2;
        this.size = size2;
        this.count = -1;
    }

    public Object clone() {
        byte[] copyBits = new byte[this.bits.length];
        System.arraycopy(this.bits, 0, copyBits, 0, this.bits.length);
        BitVector clone2 = new BitVector(copyBits, this.size);
        clone2.count = this.count;
        return clone2;
    }

    public final void set(int bit) {
        if (bit >= this.size) {
            throw new ArrayIndexOutOfBoundsException(bit);
        }
        int n = bit >> 3;
        this.bits[n] = (byte)(this.bits[n] | 1 << (bit & 7));
        this.count = -1;
    }

    public final boolean getAndSet(int bit) {
        if (bit >= this.size) {
            throw new ArrayIndexOutOfBoundsException(bit);
        }
        int flag = 1 << (bit & 7);
        int pos = bit >> 3;
        byte v = this.bits[pos];
        if ((flag & v) != 0) {
            return true;
        }
        this.bits[pos] = (byte)(v | flag);
        if (this.count != -1) {
            ++this.count;
        }
        return false;
    }

    public final void clear(int bit) {
        if (bit >= this.size) {
            throw new ArrayIndexOutOfBoundsException(bit);
        }
        int n = bit >> 3;
        this.bits[n] = (byte)(this.bits[n] & ~(1 << (bit & 7)));
        this.count = -1;
    }

    public final boolean get(int bit) {
        if (!($assertionsDisabled || bit >= 0 && bit < this.size)) {
            throw new AssertionError((Object)("bit " + bit + " is out of bounds 0.." + (this.size - 1)));
        }
        return (this.bits[bit >> 3] & 1 << (bit & 7)) != 0;
    }

    public final int size() {
        return this.size;
    }

    public final int count() {
        if (this.count == -1) {
            int c = 0;
            int end = this.bits.length;
            for (int i = 0; i < end; ++i) {
                c += BYTE_COUNTS[this.bits[i] & 0xFF];
            }
            this.count = c;
        }
        return this.count;
    }

    public final int getRecomputedCount() {
        int c = 0;
        int end = this.bits.length;
        for (int i = 0; i < end; ++i) {
            c += BYTE_COUNTS[this.bits[i] & 0xFF];
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(Directory d, String name) throws IOException {
        IndexOutput output2 = d.createOutput(name);
        try {
            if (this.isSparse()) {
                this.writeDgaps(output2);
            } else {
                this.writeBits(output2);
            }
        }
        finally {
            output2.close();
        }
    }

    private void writeBits(IndexOutput output2) throws IOException {
        output2.writeInt(this.size());
        output2.writeInt(this.count());
        output2.writeBytes(this.bits, this.bits.length);
    }

    private void writeDgaps(IndexOutput output2) throws IOException {
        output2.writeInt(-1);
        output2.writeInt(this.size());
        output2.writeInt(this.count());
        int last2 = 0;
        int n = this.count();
        int m = this.bits.length;
        for (int i = 0; i < m && n > 0; ++i) {
            if (this.bits[i] == 0) continue;
            output2.writeVInt(i - last2);
            output2.writeByte(this.bits[i]);
            last2 = i;
            n -= BYTE_COUNTS[this.bits[i] & 0xFF];
        }
    }

    private boolean isSparse() {
        int factor = 10;
        if (this.bits.length < 128) {
            return factor * (4 + 16 * this.count()) < this.size();
        }
        if (this.bits.length < 16384) {
            return factor * (4 + 24 * this.count()) < this.size();
        }
        if (this.bits.length < 0x200000) {
            return factor * (4 + 32 * this.count()) < this.size();
        }
        if (this.bits.length < 0x10000000) {
            return factor * (4 + 40 * this.count()) < this.size();
        }
        return factor * (4 + 48 * this.count()) < this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitVector(Directory d, String name) throws IOException {
        IndexInput input2 = d.openInput(name);
        try {
            this.size = input2.readInt();
            if (this.size == -1) {
                this.readDgaps(input2);
            } else {
                this.readBits(input2);
            }
        }
        finally {
            input2.close();
        }
    }

    private void readBits(IndexInput input2) throws IOException {
        this.count = input2.readInt();
        this.bits = new byte[(this.size >> 3) + 1];
        input2.readBytes(this.bits, 0, this.bits.length);
    }

    private void readDgaps(IndexInput input2) throws IOException {
        this.size = input2.readInt();
        this.count = input2.readInt();
        this.bits = new byte[(this.size >> 3) + 1];
        int last2 = 0;
        for (int n = this.count(); n > 0; n -= BYTE_COUNTS[this.bits[last2] & 0xFF]) {
            this.bits[last2 += input2.readVInt()] = input2.readByte();
        }
    }

    public BitVector subset(int start, int end) {
        if (start < 0 || end > this.size() || end < start) {
            throw new IndexOutOfBoundsException();
        }
        if (end == start) {
            return new BitVector(0);
        }
        byte[] bits2 = new byte[(end - start - 1 >>> 3) + 1];
        int s = start >>> 3;
        for (int i = 0; i < bits2.length; ++i) {
            int cur = 0xFF & this.bits[i + s];
            int next2 = i + s + 1 >= this.bits.length ? 0 : 0xFF & this.bits[i + s + 1];
            bits2[i] = (byte)(cur >>> (start & 7) | next2 << 8 - (start & 7));
        }
        int bitsToClear = (bits2.length * 8 - (end - start)) % 8;
        int n = bits2.length - 1;
        bits2[n] = (byte)(bits2[n] & ~(255 << 8 - bitsToClear));
        return new BitVector(bits2, end - start);
    }

    static {
        $assertionsDisabled = !BitVector.class.desiredAssertionStatus();
        BYTE_COUNTS = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    }
}

