/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.lucene.store.RAMDirectory;

public class RAMFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected ArrayList buffers = new ArrayList();
    long length;
    RAMDirectory directory;
    protected long sizeInBytes;
    private long lastModified = System.currentTimeMillis();

    protected RAMFile() {
    }

    RAMFile(RAMDirectory directory) {
        this.directory = directory;
    }

    public synchronized long getLength() {
        return this.length;
    }

    protected synchronized void setLength(long length) {
        this.length = length;
    }

    public synchronized long getLastModified() {
        return this.lastModified;
    }

    protected synchronized void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] addBuffer(int size2) {
        byte[] buffer = this.newBuffer(size2);
        Serializable serializable2 = this;
        synchronized (serializable2) {
            this.buffers.add(buffer);
            this.sizeInBytes += (long)size2;
        }
        if (this.directory != null) {
            serializable2 = this.directory;
            synchronized (serializable2) {
                this.directory.sizeInBytes += (long)size2;
            }
        }
        return buffer;
    }

    protected final synchronized byte[] getBuffer(int index) {
        return (byte[])this.buffers.get(index);
    }

    protected final synchronized int numBuffers() {
        return this.buffers.size();
    }

    protected byte[] newBuffer(int size2) {
        return new byte[size2];
    }

    public synchronized long getSizeInBytes() {
        return this.sizeInBytes;
    }
}

