/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.UnicodeUtil;

public abstract class IndexOutput {
    private static int COPY_BUFFER_SIZE;
    private byte[] copyBuffer;
    static final /* synthetic */ boolean $assertionsDisabled;

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] b, int length) throws IOException {
        this.writeBytes(b, 0, length);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeInt(int i) throws IOException {
        this.writeByte((byte)(i >> 24));
        this.writeByte((byte)(i >> 16));
        this.writeByte((byte)(i >> 8));
        this.writeByte((byte)i);
    }

    public void writeVInt(int i) throws IOException {
        while ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public void writeLong(long i) throws IOException {
        this.writeInt((int)(i >> 32));
        this.writeInt((int)i);
    }

    public void writeVLong(long i) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public void writeString(String s) throws IOException {
        UnicodeUtil.UTF8Result utf8Result = new UnicodeUtil.UTF8Result();
        UnicodeUtil.UTF16toUTF8(s, 0, s.length(), utf8Result);
        this.writeVInt(utf8Result.length);
        this.writeBytes(utf8Result.result, 0, utf8Result.length);
    }

    public void writeChars(String s, int start, int length) throws IOException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char code = s.charAt(i);
            if (code >= '\u0001' && code <= '\u007f') {
                this.writeByte((byte)code);
                continue;
            }
            if (code >= '\u0080' && code <= '\u07ff' || code == '\u0000') {
                this.writeByte((byte)(0xC0 | code >> 6));
                this.writeByte((byte)(0x80 | code & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xE0 | code >>> 12));
            this.writeByte((byte)(0x80 | code >> 6 & 0x3F));
            this.writeByte((byte)(0x80 | code & 0x3F));
        }
    }

    public void writeChars(char[] s, int start, int length) throws IOException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char code = s[i];
            if (code >= '\u0001' && code <= '\u007f') {
                this.writeByte((byte)code);
                continue;
            }
            if (code >= '\u0080' && code <= '\u07ff' || code == '\u0000') {
                this.writeByte((byte)(0xC0 | code >> 6));
                this.writeByte((byte)(0x80 | code & 0x3F));
                continue;
            }
            this.writeByte((byte)(0xE0 | code >>> 12));
            this.writeByte((byte)(0x80 | code >> 6 & 0x3F));
            this.writeByte((byte)(0x80 | code & 0x3F));
        }
    }

    public void copyBytes(IndexInput input2, long numBytes) throws IOException {
        if (!$assertionsDisabled && numBytes < 0L) {
            throw new AssertionError((Object)("numBytes=" + numBytes));
        }
        long left = numBytes;
        if (this.copyBuffer == null) {
            this.copyBuffer = new byte[COPY_BUFFER_SIZE];
        }
        while (left > 0L) {
            int toCopy = left > (long)COPY_BUFFER_SIZE ? COPY_BUFFER_SIZE : (int)left;
            input2.readBytes(this.copyBuffer, 0, toCopy);
            this.writeBytes(this.copyBuffer, 0, toCopy);
            left -= (long)toCopy;
        }
    }

    public abstract void flush() throws IOException;

    public abstract void close() throws IOException;

    public abstract long getFilePointer();

    public abstract void seek(long var1) throws IOException;

    public abstract long length() throws IOException;

    public void setLength(long length) throws IOException {
    }

    public void writeStringStringMap(Map map2) throws IOException {
        if (map2 == null) {
            this.writeInt(0);
        } else {
            this.writeInt(map2.size());
            Iterator it = map2.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.writeString((String)entry.getKey());
                this.writeString((String)entry.getValue());
            }
        }
    }

    static {
        $assertionsDisabled = !IndexOutput.class.desiredAssertionStatus();
        COPY_BUFFER_SIZE = 16384;
    }
}

