/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.ToStringUtils;

public class FieldMaskingSpanQuery
extends SpanQuery {
    private SpanQuery maskedQuery;
    private String field;

    public FieldMaskingSpanQuery(SpanQuery maskedQuery, String maskedField) {
        this.maskedQuery = maskedQuery;
        this.field = maskedField;
    }

    public String getField() {
        return this.field;
    }

    public SpanQuery getMaskedQuery() {
        return this.maskedQuery;
    }

    public Spans getSpans(IndexReader reader) throws IOException {
        return this.maskedQuery.getSpans(reader);
    }

    public Collection getTerms() {
        return this.maskedQuery.getTerms();
    }

    public void extractTerms(Set terms) {
        this.maskedQuery.extractTerms(terms);
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return this.maskedQuery.createWeight(searcher);
    }

    public Similarity getSimilarity(Searcher searcher) {
        return this.maskedQuery.getSimilarity(searcher);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        FieldMaskingSpanQuery clone2 = null;
        SpanQuery rewritten = (SpanQuery)this.maskedQuery.rewrite(reader);
        if (rewritten != this.maskedQuery) {
            clone2 = (FieldMaskingSpanQuery)this.clone();
            clone2.maskedQuery = rewritten;
        }
        if (clone2 != null) {
            return clone2;
        }
        return this;
    }

    public String toString(String field2) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("mask(");
        buffer.append(this.maskedQuery.toString(field2));
        buffer.append(")");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        buffer.append(" as ");
        buffer.append(this.field);
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof FieldMaskingSpanQuery)) {
            return false;
        }
        FieldMaskingSpanQuery other = (FieldMaskingSpanQuery)o;
        return this.getField().equals(other.getField()) && this.getBoost() == other.getBoost() && this.getMaskedQuery().equals(other.getMaskedQuery());
    }

    public int hashCode() {
        return this.getMaskedQuery().hashCode() ^ this.getField().hashCode() ^ Float.floatToRawIntBits(this.getBoost());
    }
}

