/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.lucene.search.SortField;

public class Sort
implements Serializable {
    public static final Sort RELEVANCE = new Sort();
    public static final Sort INDEXORDER = new Sort(SortField.FIELD_DOC);
    SortField[] fields;

    public Sort() {
        this(SortField.FIELD_SCORE);
    }

    public Sort(String field2) {
        this.setSort(field2, false);
    }

    public Sort(String field2, boolean reverse2) {
        this.setSort(field2, reverse2);
    }

    public Sort(String[] fields) {
        this.setSort(fields);
    }

    public Sort(SortField field2) {
        this.setSort(field2);
    }

    public Sort(SortField[] fields) {
        this.setSort(fields);
    }

    public final void setSort(String field2) {
        this.setSort(field2, false);
    }

    public void setSort(String field2, boolean reverse2) {
        this.fields = new SortField[]{new SortField(field2, 2, reverse2)};
    }

    public void setSort(String[] fieldnames) {
        int n = fieldnames.length;
        SortField[] nfields = new SortField[n];
        for (int i = 0; i < n; ++i) {
            nfields[i] = new SortField(fieldnames[i], 2);
        }
        this.fields = nfields;
    }

    public void setSort(SortField field2) {
        this.fields = new SortField[]{field2};
    }

    public void setSort(SortField[] fields) {
        this.fields = fields;
    }

    public SortField[] getSort() {
        return this.fields;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.fields.length; ++i) {
            buffer.append(this.fields[i].toString());
            if (i + 1 >= this.fields.length) continue;
            buffer.append(',');
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Sort)) {
            return false;
        }
        Sort other = (Sort)o;
        return Arrays.equals(this.fields, other.fields);
    }

    public int hashCode() {
        return 1168832101 + ((Object)Arrays.asList(this.fields)).hashCode();
    }
}

