/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.text.Collator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;

public class RangeQuery
extends Query {
    private final TermRangeQuery delegate;

    public RangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive2) {
        this(lowerTerm, upperTerm, inclusive2, null);
    }

    public RangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive2, Collator collator) {
        if (lowerTerm == null && upperTerm == null) {
            throw new IllegalArgumentException("At least one term must be non-null");
        }
        if (lowerTerm != null && upperTerm != null && lowerTerm.field() != upperTerm.field()) {
            throw new IllegalArgumentException("Both terms must have the same field");
        }
        this.delegate = new TermRangeQuery(lowerTerm == null ? upperTerm.field() : lowerTerm.field(), lowerTerm == null ? null : lowerTerm.text(), upperTerm == null ? null : upperTerm.text(), inclusive2, inclusive2, collator);
        this.delegate.setRewriteMethod(TermRangeQuery.SCORING_BOOLEAN_QUERY_REWRITE);
    }

    public void setBoost(float b) {
        super.setBoost(b);
        this.delegate.setBoost(b);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this.delegate.rewrite(reader);
    }

    public String getField() {
        return this.delegate.getField();
    }

    public Term getLowerTerm() {
        String term = this.delegate.getLowerTerm();
        return term == null ? null : new Term(this.getField(), term);
    }

    public Term getUpperTerm() {
        String term = this.delegate.getUpperTerm();
        return term == null ? null : new Term(this.getField(), term);
    }

    public boolean isInclusive() {
        return this.delegate.includesLower() && this.delegate.includesUpper();
    }

    public Collator getCollator() {
        return this.delegate.getCollator();
    }

    public String toString(String field2) {
        return this.delegate.toString(field2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeQuery)) {
            return false;
        }
        RangeQuery other = (RangeQuery)o;
        return this.delegate.equals(other.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

