/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.OpenBitSet;

public class MultiTermQueryWrapperFilter
extends Filter {
    protected final MultiTermQuery query;

    protected MultiTermQueryWrapperFilter(MultiTermQuery query) {
        this.query = query;
    }

    public String toString() {
        return this.query.toString();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass().equals(o.getClass())) {
            return this.query.equals(((MultiTermQueryWrapperFilter)o).query);
        }
        return false;
    }

    public final int hashCode() {
        return this.query.hashCode();
    }

    public int getTotalNumberOfTerms() {
        return this.query.getTotalNumberOfTerms();
    }

    public void clearTotalNumberOfTerms() {
        this.query.clearTotalNumberOfTerms();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BitSet bits(IndexReader reader) throws IOException {
        BitSet bitSet;
        FilteredTermEnum enumerator = this.query.getEnum(reader);
        try {
            final BitSet bitSet2 = new BitSet(reader.maxDoc());
            new TermGenerator(){

                public void handleDoc(int doc) {
                    bitSet2.set(doc);
                }
            }.generate(reader, enumerator);
            bitSet = bitSet2;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ((TermEnum)enumerator).close();
            throw throwable;
        }
        ((TermEnum)enumerator).close();
        return bitSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        FilteredTermEnum enumerator;
        block3: {
            DocIdSet docIdSet;
            enumerator = this.query.getEnum(reader);
            try {
                if (((TermEnum)enumerator).term() != null) break block3;
                docIdSet = DocIdSet.EMPTY_DOCIDSET;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                ((TermEnum)enumerator).close();
                throw throwable;
            }
            ((TermEnum)enumerator).close();
            return docIdSet;
        }
        final OpenBitSet bitSet = new OpenBitSet(reader.maxDoc());
        new TermGenerator(){

            public void handleDoc(int doc) {
                bitSet.set(doc);
            }
        }.generate(reader, enumerator);
        OpenBitSet openBitSet = bitSet;
        Object var6_6 = null;
        ((TermEnum)enumerator).close();
        return openBitSet;
    }

    abstract class TermGenerator {
        TermGenerator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generate(IndexReader reader, TermEnum enumerator) throws IOException {
            int[] docs = new int[32];
            int[] freqs = new int[32];
            TermDocs termDocs = reader.termDocs();
            try {
                Term term;
                int termCount = 0;
                while ((term = enumerator.term()) != null) {
                    int count2;
                    ++termCount;
                    termDocs.seek(term);
                    while ((count2 = termDocs.read(docs, freqs)) != 0) {
                        for (int i = 0; i < count2; ++i) {
                            this.handleDoc(docs[i]);
                        }
                    }
                    if (enumerator.next()) continue;
                }
                MultiTermQueryWrapperFilter.this.query.incTotalNumberOfTerms(termCount);
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                termDocs.close();
                throw throwable;
            }
            termDocs.close();
        }

        public abstract void handleDoc(int var1);
    }
}

