/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitDoc;
import org.apache.lucene.search.HitIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.Weight;

public final class Hits {
    private Weight weight;
    private Searcher searcher;
    private Filter filter = null;
    private Sort sort = null;
    private int length;
    private Vector hitDocs = new Vector();
    private HitDoc first;
    private HitDoc last;
    private int numDocs = 0;
    private int maxDocs = 200;
    private int nDeletions;
    private int lengthAtStart;
    private int nDeletedHits = 0;
    boolean debugCheckedForDeletions = false;

    Hits(Searcher s, Query q, Filter f2) throws IOException {
        this.weight = q.weight(s);
        this.searcher = s;
        this.filter = f2;
        this.nDeletions = this.countDeletions(s);
        this.getMoreDocs(50);
        this.lengthAtStart = this.length;
    }

    Hits(Searcher s, Query q, Filter f2, Sort o) throws IOException {
        this.weight = q.weight(s);
        this.searcher = s;
        this.filter = f2;
        this.sort = o;
        this.nDeletions = this.countDeletions(s);
        this.getMoreDocs(50);
        this.lengthAtStart = this.length;
    }

    private int countDeletions(Searcher s) throws IOException {
        int cnt = -1;
        if (s instanceof IndexSearcher) {
            cnt = s.maxDoc() - ((IndexSearcher)s).getIndexReader().numDocs();
        }
        return cnt;
    }

    private final void getMoreDocs(int min2) throws IOException {
        if (this.hitDocs.size() > min2) {
            min2 = this.hitDocs.size();
        }
        int n = min2 * 2;
        TopDocs topDocs = this.sort == null ? this.searcher.search(this.weight, this.filter, n) : this.searcher.search(this.weight, this.filter, n, this.sort);
        this.length = topDocs.totalHits;
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        float scoreNorm = 1.0f;
        if (this.length > 0 && topDocs.getMaxScore() > 1.0f) {
            scoreNorm = 1.0f / topDocs.getMaxScore();
        }
        int start = this.hitDocs.size() - this.nDeletedHits;
        int nDels2 = this.countDeletions(this.searcher);
        this.debugCheckedForDeletions = false;
        if (this.nDeletions < 0 || nDels2 > this.nDeletions) {
            this.nDeletedHits = 0;
            this.debugCheckedForDeletions = true;
            int i2 = 0;
            for (int i1 = 0; i1 < this.hitDocs.size() && i2 < scoreDocs.length; ++i1) {
                int id1 = ((HitDoc)this.hitDocs.get((int)i1)).id;
                int id2 = scoreDocs[i2].doc;
                if (id1 == id2) {
                    ++i2;
                    continue;
                }
                ++this.nDeletedHits;
            }
            start = i2;
        }
        int end = scoreDocs.length < this.length ? scoreDocs.length : this.length;
        this.length += this.nDeletedHits;
        for (int i = start; i < end; ++i) {
            this.hitDocs.addElement(new HitDoc(scoreDocs[i].score * scoreNorm, scoreDocs[i].doc));
        }
        this.nDeletions = nDels2;
    }

    public final int length() {
        return this.length;
    }

    public final Document doc(int n) throws CorruptIndexException, IOException {
        HitDoc hitDoc = this.hitDoc(n);
        this.remove(hitDoc);
        this.addToFront(hitDoc);
        if (this.numDocs > this.maxDocs) {
            HitDoc oldLast = this.last;
            this.remove(this.last);
            oldLast.doc = null;
        }
        if (hitDoc.doc == null) {
            hitDoc.doc = this.searcher.doc(hitDoc.id);
        }
        return hitDoc.doc;
    }

    public final float score(int n) throws IOException {
        return this.hitDoc((int)n).score;
    }

    public final int id(int n) throws IOException {
        return this.hitDoc((int)n).id;
    }

    public Iterator iterator() {
        return new HitIterator(this);
    }

    private final HitDoc hitDoc(int n) throws IOException {
        if (n >= this.lengthAtStart) {
            throw new IndexOutOfBoundsException("Not a valid hit number: " + n);
        }
        if (n >= this.hitDocs.size()) {
            this.getMoreDocs(n);
        }
        if (n >= this.length) {
            throw new ConcurrentModificationException("Not a valid hit number: " + n);
        }
        return (HitDoc)this.hitDocs.elementAt(n);
    }

    private final void addToFront(HitDoc hitDoc) {
        if (this.first == null) {
            this.last = hitDoc;
        } else {
            this.first.prev = hitDoc;
        }
        hitDoc.next = this.first;
        this.first = hitDoc;
        hitDoc.prev = null;
        ++this.numDocs;
    }

    private final void remove(HitDoc hitDoc) {
        if (hitDoc.doc == null) {
            return;
        }
        if (hitDoc.next == null) {
            this.last = hitDoc.prev;
        } else {
            hitDoc.next.prev = hitDoc.prev;
        }
        if (hitDoc.prev == null) {
            this.first = hitDoc.next;
        } else {
            hitDoc.prev.next = hitDoc.next;
        }
        --this.numDocs;
    }
}

