/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class FilteredQuery
extends Query {
    Query query;
    Filter filter;

    public FilteredQuery(Query query, Filter filter2) {
        this.query = query;
        this.filter = filter2;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        final Weight weight = this.query.createWeight(searcher);
        final Similarity similarity = this.query.getSimilarity(searcher);
        return new Weight(){
            private float value;

            public float getValue() {
                return this.value;
            }

            public float sumOfSquaredWeights() throws IOException {
                return weight.sumOfSquaredWeights() * FilteredQuery.this.getBoost() * FilteredQuery.this.getBoost();
            }

            public void normalize(float v) {
                weight.normalize(v);
                this.value = weight.getValue() * FilteredQuery.this.getBoost();
            }

            public Explanation explain(IndexReader ir, int i) throws IOException {
                Filter f2;
                DocIdSet docIdSet;
                DocIdSetIterator docIdSetIterator;
                Explanation inner2 = weight.explain(ir, i);
                if (FilteredQuery.this.getBoost() != 1.0f) {
                    Explanation preBoost = inner2;
                    inner2 = new Explanation(inner2.getValue() * FilteredQuery.this.getBoost(), "product of:");
                    inner2.addDetail(new Explanation(FilteredQuery.this.getBoost(), "boost"));
                    inner2.addDetail(preBoost);
                }
                DocIdSetIterator docIdSetIterator2 = docIdSetIterator = (docIdSet = (f2 = FilteredQuery.this.filter).getDocIdSet(ir)) == null ? DocIdSet.EMPTY_DOCIDSET.iterator() : docIdSet.iterator();
                if (docIdSetIterator == null) {
                    docIdSetIterator = DocIdSet.EMPTY_DOCIDSET.iterator();
                }
                if (docIdSetIterator.advance(i) == i) {
                    return inner2;
                }
                Explanation result2 = new Explanation(0.0f, "failure to match filter: " + f2.toString());
                result2.addDetail(inner2);
                return result2;
            }

            public Query getQuery() {
                return FilteredQuery.this;
            }

            public Scorer scorer(IndexReader indexReader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
                final Scorer scorer = weight.scorer(indexReader, true, false);
                if (scorer == null) {
                    return null;
                }
                DocIdSet docIdSet = FilteredQuery.this.filter.getDocIdSet(indexReader);
                if (docIdSet == null) {
                    return null;
                }
                final DocIdSetIterator docIdSetIterator = docIdSet.iterator();
                if (docIdSetIterator == null) {
                    return null;
                }
                return new Scorer(similarity){
                    private int doc;
                    {
                        super(x0);
                        this.doc = -1;
                    }

                    private int advanceToCommon(int scorerDoc, int disiDoc) throws IOException {
                        while (scorerDoc != disiDoc) {
                            if (scorerDoc < disiDoc) {
                                scorerDoc = scorer.advance(disiDoc);
                                continue;
                            }
                            disiDoc = docIdSetIterator.advance(scorerDoc);
                        }
                        return scorerDoc;
                    }

                    public boolean next() throws IOException {
                        return this.nextDoc() != Integer.MAX_VALUE;
                    }

                    public int nextDoc() throws IOException {
                        int scorerDoc;
                        int disiDoc = docIdSetIterator.nextDoc();
                        this.doc = disiDoc != Integer.MAX_VALUE && (scorerDoc = scorer.nextDoc()) != Integer.MAX_VALUE && this.advanceToCommon(scorerDoc, disiDoc) != Integer.MAX_VALUE ? scorer.docID() : Integer.MAX_VALUE;
                        return this.doc;
                    }

                    public int doc() {
                        return scorer.doc();
                    }

                    public int docID() {
                        return this.doc;
                    }

                    public boolean skipTo(int i) throws IOException {
                        return this.advance(i) != Integer.MAX_VALUE;
                    }

                    public int advance(int target) throws IOException {
                        int scorerDoc;
                        int disiDoc = docIdSetIterator.advance(target);
                        this.doc = disiDoc != Integer.MAX_VALUE && (scorerDoc = scorer.advance(disiDoc)) != Integer.MAX_VALUE && this.advanceToCommon(scorerDoc, disiDoc) != Integer.MAX_VALUE ? scorer.docID() : Integer.MAX_VALUE;
                        return this.doc;
                    }

                    public float score() throws IOException {
                        return FilteredQuery.this.getBoost() * scorer.score();
                    }

                    public Explanation explain(int i) throws IOException {
                        Explanation exp = scorer.explain(i);
                        if (docIdSetIterator.advance(i) == i) {
                            exp.setDescription("allowed by filter: " + exp.getDescription());
                            exp.setValue(FilteredQuery.this.getBoost() * exp.getValue());
                        } else {
                            exp.setDescription("removed by filter: " + exp.getDescription());
                            exp.setValue(0.0f);
                        }
                        return exp;
                    }
                };
            }
        };
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.query.rewrite(reader);
        if (rewritten != this.query) {
            FilteredQuery clone2 = (FilteredQuery)this.clone();
            clone2.query = rewritten;
            return clone2;
        }
        return this;
    }

    public Query getQuery() {
        return this.query;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void extractTerms(Set terms) {
        this.getQuery().extractTerms(terms);
    }

    public String toString(String s) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("filtered(");
        buffer.append(this.query.toString(s));
        buffer.append(")->");
        buffer.append(this.filter);
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof FilteredQuery) {
            FilteredQuery fq = (FilteredQuery)o;
            return this.query.equals(fq.query) && this.filter.equals(fq.filter) && this.getBoost() == fq.getBoost();
        }
        return false;
    }

    public int hashCode() {
        return this.query.hashCode() ^ this.filter.hashCode() + Float.floatToRawIntBits(this.getBoost());
    }
}

