/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.NumericUtils;

public abstract class FieldCacheRangeFilter
extends Filter {
    final String field;
    final FieldCache.Parser parser;
    final Object lowerVal;
    final Object upperVal;
    final boolean includeLower;
    final boolean includeUpper;
    static /* synthetic */ Class class$org$apache$lucene$search$FieldCacheRangeFilter;

    private FieldCacheRangeFilter(String field2, FieldCache.Parser parser, Object lowerVal, Object upperVal, boolean includeLower, boolean includeUpper) {
        this.field = field2;
        this.parser = parser;
        this.lowerVal = lowerVal;
        this.upperVal = upperVal;
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    public abstract DocIdSet getDocIdSet(IndexReader var1) throws IOException;

    public static FieldCacheRangeFilter newStringRange(String field2, String lowerVal, String upperVal, boolean includeLower, boolean includeUpper) {
        return new FieldCacheRangeFilter(field2, null, lowerVal, upperVal, includeLower, includeUpper){
            static final /* synthetic */ boolean $assertionsDisabled;

            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                int inclusiveUpperPoint;
                int inclusiveLowerPoint;
                final FieldCache.StringIndex fcsi = FieldCache.DEFAULT.getStringIndex(reader, this.field);
                int lowerPoint = fcsi.binarySearchLookup((String)this.lowerVal);
                int upperPoint = fcsi.binarySearchLookup((String)this.upperVal);
                if (lowerPoint == 0) {
                    if (!$assertionsDisabled && this.lowerVal != null) {
                        throw new AssertionError();
                    }
                    inclusiveLowerPoint = 1;
                } else {
                    inclusiveLowerPoint = this.includeLower && lowerPoint > 0 ? lowerPoint : (lowerPoint > 0 ? lowerPoint + 1 : Math.max(1, -lowerPoint - 1));
                }
                if (upperPoint == 0) {
                    if (!$assertionsDisabled && this.upperVal != null) {
                        throw new AssertionError();
                    }
                    inclusiveUpperPoint = Integer.MAX_VALUE;
                } else {
                    inclusiveUpperPoint = this.includeUpper && upperPoint > 0 ? upperPoint : (upperPoint > 0 ? upperPoint - 1 : -upperPoint - 2);
                }
                if (inclusiveUpperPoint <= 0 || inclusiveLowerPoint > inclusiveUpperPoint) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                if (!($assertionsDisabled || inclusiveLowerPoint > 0 && inclusiveUpperPoint > 0)) {
                    throw new AssertionError();
                }
                return new FieldCacheDocIdSet(reader, false){

                    final boolean matchDoc(int doc) {
                        return fcsi.order[doc] >= inclusiveLowerPoint && fcsi.order[doc] <= inclusiveUpperPoint;
                    }
                };
            }

            static {
                $assertionsDisabled = !(class$org$apache$lucene$search$FieldCacheRangeFilter == null ? (class$org$apache$lucene$search$FieldCacheRangeFilter = FieldCacheRangeFilter.class$("org.apache.lucene.search.FieldCacheRangeFilter")) : class$org$apache$lucene$search$FieldCacheRangeFilter).desiredAssertionStatus();
            }
        };
    }

    public static FieldCacheRangeFilter newByteRange(String field2, Byte lowerVal, Byte upperVal, boolean includeLower, boolean includeUpper) {
        return FieldCacheRangeFilter.newByteRange(field2, null, lowerVal, upperVal, includeLower, includeUpper);
    }

    public static FieldCacheRangeFilter newByteRange(String field2, FieldCache.ByteParser parser, Byte lowerVal, Byte upperVal, boolean includeLower, boolean includeUpper) {
        return new FieldCacheRangeFilter(field2, parser, lowerVal, upperVal, includeLower, includeUpper){

            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                byte inclusiveUpperPoint;
                byte inclusiveLowerPoint;
                int i;
                if (this.lowerVal != null) {
                    i = ((Number)this.lowerVal).byteValue();
                    if (!this.includeLower && i == 127) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    inclusiveLowerPoint = (byte)(this.includeLower ? i : i + 1);
                } else {
                    inclusiveLowerPoint = -128;
                }
                if (this.upperVal != null) {
                    i = ((Number)this.upperVal).byteValue();
                    if (!this.includeUpper && i == -128) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    inclusiveUpperPoint = (byte)(this.includeUpper ? i : i - 1);
                } else {
                    inclusiveUpperPoint = 127;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                final byte[] values2 = FieldCache.DEFAULT.getBytes(reader, this.field, (FieldCache.ByteParser)this.parser);
                return new FieldCacheDocIdSet(reader, inclusiveLowerPoint <= 0 && inclusiveUpperPoint >= 0){

                    boolean matchDoc(int doc) {
                        return values2[doc] >= inclusiveLowerPoint && values2[doc] <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static FieldCacheRangeFilter newShortRange(String field2, Short lowerVal, Short upperVal, boolean includeLower, boolean includeUpper) {
        return FieldCacheRangeFilter.newShortRange(field2, null, lowerVal, upperVal, includeLower, includeUpper);
    }

    public static FieldCacheRangeFilter newShortRange(String field2, FieldCache.ShortParser parser, Short lowerVal, Short upperVal, boolean includeLower, boolean includeUpper) {
        return new FieldCacheRangeFilter(field2, parser, lowerVal, upperVal, includeLower, includeUpper){

            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                short inclusiveUpperPoint;
                short inclusiveLowerPoint;
                int i;
                if (this.lowerVal != null) {
                    i = ((Number)this.lowerVal).shortValue();
                    if (!this.includeLower && i == Short.MAX_VALUE) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    inclusiveLowerPoint = (short)(this.includeLower ? i : i + 1);
                } else {
                    inclusiveLowerPoint = Short.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    i = ((Number)this.upperVal).shortValue();
                    if (!this.includeUpper && i == Short.MIN_VALUE) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    inclusiveUpperPoint = (short)(this.includeUpper ? i : i - 1);
                } else {
                    inclusiveUpperPoint = Short.MAX_VALUE;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                final short[] values2 = FieldCache.DEFAULT.getShorts(reader, this.field, (FieldCache.ShortParser)this.parser);
                return new FieldCacheDocIdSet(reader, inclusiveLowerPoint <= 0 && inclusiveUpperPoint >= 0){

                    boolean matchDoc(int doc) {
                        return values2[doc] >= inclusiveLowerPoint && values2[doc] <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static FieldCacheRangeFilter newIntRange(String field2, Integer lowerVal, Integer upperVal, boolean includeLower, boolean includeUpper) {
        return FieldCacheRangeFilter.newIntRange(field2, null, lowerVal, upperVal, includeLower, includeUpper);
    }

    public static FieldCacheRangeFilter newIntRange(String field2, FieldCache.IntParser parser, Integer lowerVal, Integer upperVal, boolean includeLower, boolean includeUpper) {
        return new FieldCacheRangeFilter(field2, parser, lowerVal, upperVal, includeLower, includeUpper){

            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                int inclusiveUpperPoint;
                int inclusiveLowerPoint;
                int i;
                if (this.lowerVal != null) {
                    i = ((Number)this.lowerVal).intValue();
                    if (!this.includeLower && i == Integer.MAX_VALUE) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    inclusiveLowerPoint = this.includeLower ? i : i + 1;
                } else {
                    inclusiveLowerPoint = Integer.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    i = ((Number)this.upperVal).intValue();
                    if (!this.includeUpper && i == Integer.MIN_VALUE) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    inclusiveUpperPoint = this.includeUpper ? i : i - 1;
                } else {
                    inclusiveUpperPoint = Integer.MAX_VALUE;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                final int[] values2 = FieldCache.DEFAULT.getInts(reader, this.field, (FieldCache.IntParser)this.parser);
                return new FieldCacheDocIdSet(reader, inclusiveLowerPoint <= 0 && inclusiveUpperPoint >= 0){

                    boolean matchDoc(int doc) {
                        return values2[doc] >= inclusiveLowerPoint && values2[doc] <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static FieldCacheRangeFilter newLongRange(String field2, Long lowerVal, Long upperVal, boolean includeLower, boolean includeUpper) {
        return FieldCacheRangeFilter.newLongRange(field2, null, lowerVal, upperVal, includeLower, includeUpper);
    }

    public static FieldCacheRangeFilter newLongRange(String field2, FieldCache.LongParser parser, Long lowerVal, Long upperVal, boolean includeLower, boolean includeUpper) {
        return new FieldCacheRangeFilter(field2, parser, lowerVal, upperVal, includeLower, includeUpper){

            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                long inclusiveUpperPoint;
                long inclusiveLowerPoint;
                long i;
                if (this.lowerVal != null) {
                    i = ((Number)this.lowerVal).longValue();
                    if (!this.includeLower && i == Long.MAX_VALUE) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    inclusiveLowerPoint = this.includeLower ? i : i + 1L;
                } else {
                    inclusiveLowerPoint = Long.MIN_VALUE;
                }
                if (this.upperVal != null) {
                    i = ((Number)this.upperVal).longValue();
                    if (!this.includeUpper && i == Long.MIN_VALUE) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    inclusiveUpperPoint = this.includeUpper ? i : i - 1L;
                } else {
                    inclusiveUpperPoint = Long.MAX_VALUE;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                final long[] values2 = FieldCache.DEFAULT.getLongs(reader, this.field, (FieldCache.LongParser)this.parser);
                return new FieldCacheDocIdSet(reader, inclusiveLowerPoint <= 0L && inclusiveUpperPoint >= 0L){

                    boolean matchDoc(int doc) {
                        return values2[doc] >= inclusiveLowerPoint && values2[doc] <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static FieldCacheRangeFilter newFloatRange(String field2, Float lowerVal, Float upperVal, boolean includeLower, boolean includeUpper) {
        return FieldCacheRangeFilter.newFloatRange(field2, null, lowerVal, upperVal, includeLower, includeUpper);
    }

    public static FieldCacheRangeFilter newFloatRange(String field2, FieldCache.FloatParser parser, Float lowerVal, Float upperVal, boolean includeLower, boolean includeUpper) {
        return new FieldCacheRangeFilter(field2, parser, lowerVal, upperVal, includeLower, includeUpper){

            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                float inclusiveUpperPoint;
                float inclusiveLowerPoint;
                int i;
                float f2;
                if (this.lowerVal != null) {
                    f2 = ((Number)this.lowerVal).floatValue();
                    if (!this.includeUpper && f2 > 0.0f && Float.isInfinite(f2)) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    i = NumericUtils.floatToSortableInt(f2);
                    inclusiveLowerPoint = NumericUtils.sortableIntToFloat(this.includeLower ? i : i + 1);
                } else {
                    inclusiveLowerPoint = Float.NEGATIVE_INFINITY;
                }
                if (this.upperVal != null) {
                    f2 = ((Number)this.upperVal).floatValue();
                    if (!this.includeUpper && f2 < 0.0f && Float.isInfinite(f2)) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    i = NumericUtils.floatToSortableInt(f2);
                    inclusiveUpperPoint = NumericUtils.sortableIntToFloat(this.includeUpper ? i : i - 1);
                } else {
                    inclusiveUpperPoint = Float.POSITIVE_INFINITY;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                final float[] values2 = FieldCache.DEFAULT.getFloats(reader, this.field, (FieldCache.FloatParser)this.parser);
                return new FieldCacheDocIdSet(reader, inclusiveLowerPoint <= 0.0f && inclusiveUpperPoint >= 0.0f){

                    boolean matchDoc(int doc) {
                        return values2[doc] >= inclusiveLowerPoint && values2[doc] <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public static FieldCacheRangeFilter newDoubleRange(String field2, Double lowerVal, Double upperVal, boolean includeLower, boolean includeUpper) {
        return FieldCacheRangeFilter.newDoubleRange(field2, null, lowerVal, upperVal, includeLower, includeUpper);
    }

    public static FieldCacheRangeFilter newDoubleRange(String field2, FieldCache.DoubleParser parser, Double lowerVal, Double upperVal, boolean includeLower, boolean includeUpper) {
        return new FieldCacheRangeFilter(field2, parser, lowerVal, upperVal, includeLower, includeUpper){

            public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
                double inclusiveUpperPoint;
                double inclusiveLowerPoint;
                long i;
                double f2;
                if (this.lowerVal != null) {
                    f2 = ((Number)this.lowerVal).doubleValue();
                    if (!this.includeUpper && f2 > 0.0 && Double.isInfinite(f2)) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    i = NumericUtils.doubleToSortableLong(f2);
                    inclusiveLowerPoint = NumericUtils.sortableLongToDouble(this.includeLower ? i : i + 1L);
                } else {
                    inclusiveLowerPoint = Double.NEGATIVE_INFINITY;
                }
                if (this.upperVal != null) {
                    f2 = ((Number)this.upperVal).doubleValue();
                    if (!this.includeUpper && f2 < 0.0 && Double.isInfinite(f2)) {
                        return DocIdSet.EMPTY_DOCIDSET;
                    }
                    i = NumericUtils.doubleToSortableLong(f2);
                    inclusiveUpperPoint = NumericUtils.sortableLongToDouble(this.includeUpper ? i : i - 1L);
                } else {
                    inclusiveUpperPoint = Double.POSITIVE_INFINITY;
                }
                if (inclusiveLowerPoint > inclusiveUpperPoint) {
                    return DocIdSet.EMPTY_DOCIDSET;
                }
                final double[] values2 = FieldCache.DEFAULT.getDoubles(reader, this.field, (FieldCache.DoubleParser)this.parser);
                return new FieldCacheDocIdSet(reader, inclusiveLowerPoint <= 0.0 && inclusiveUpperPoint >= 0.0){

                    boolean matchDoc(int doc) {
                        return values2[doc] >= inclusiveLowerPoint && values2[doc] <= inclusiveUpperPoint;
                    }
                };
            }
        };
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer(this.field).append(":");
        return sb.append(this.includeLower ? (char)'[' : '{').append(this.lowerVal == null ? "*" : this.lowerVal.toString()).append(" TO ").append(this.upperVal == null ? "*" : this.upperVal.toString()).append(this.includeUpper ? (char)']' : '}').toString();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldCacheRangeFilter)) {
            return false;
        }
        FieldCacheRangeFilter other = (FieldCacheRangeFilter)o;
        if (!this.field.equals(other.field) || this.includeLower != other.includeLower || this.includeUpper != other.includeUpper) {
            return false;
        }
        if (this.lowerVal != null ? !this.lowerVal.equals(other.lowerVal) : other.lowerVal != null) {
            return false;
        }
        if (this.upperVal != null ? !this.upperVal.equals(other.upperVal) : other.upperVal != null) {
            return false;
        }
        return !(this.parser != null ? !this.parser.equals(other.parser) : other.parser != null);
    }

    public final int hashCode() {
        int h = this.field.hashCode();
        h ^= this.lowerVal != null ? this.lowerVal.hashCode() : 550356204;
        h = h << 1 | h >>> 31;
        h ^= this.upperVal != null ? this.upperVal.hashCode() : -1674416163;
        h ^= this.parser != null ? this.parser.hashCode() : -1572457324;
        return h ^= (this.includeLower ? 1549299360 : -365038026) ^ (this.includeUpper ? 1721088258 : 1948649653);
    }

    static abstract class FieldCacheDocIdSet
    extends DocIdSet {
        private final IndexReader reader;
        private boolean mayUseTermDocs;

        FieldCacheDocIdSet(IndexReader reader, boolean mayUseTermDocs) {
            this.reader = reader;
            this.mayUseTermDocs = mayUseTermDocs;
        }

        abstract boolean matchDoc(int var1) throws ArrayIndexOutOfBoundsException;

        public boolean isCacheable() {
            return !this.mayUseTermDocs || !this.reader.hasDeletions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DocIdSetIterator iterator() throws IOException {
            TermDocs termDocs;
            IndexReader indexReader = this.reader;
            synchronized (indexReader) {
                termDocs = this.isCacheable() ? null : this.reader.termDocs(null);
            }
            if (termDocs != null) {
                return new DocIdSetIterator(){
                    private int doc = -1;

                    public boolean next() throws IOException {
                        return this.nextDoc() != Integer.MAX_VALUE;
                    }

                    public boolean skipTo(int target) throws IOException {
                        return this.advance(target) != Integer.MAX_VALUE;
                    }

                    public int doc() {
                        return termDocs.doc();
                    }

                    public int docID() {
                        return this.doc;
                    }

                    public int nextDoc() throws IOException {
                        do {
                            if (termDocs.next()) continue;
                            this.doc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        } while (!FieldCacheDocIdSet.this.matchDoc(this.doc = termDocs.doc()));
                        return this.doc;
                    }

                    public int advance(int target) throws IOException {
                        if (!termDocs.skipTo(target)) {
                            this.doc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }
                        while (!FieldCacheDocIdSet.this.matchDoc(this.doc = termDocs.doc())) {
                            if (termDocs.next()) continue;
                            this.doc = Integer.MAX_VALUE;
                            return Integer.MAX_VALUE;
                        }
                        return this.doc;
                    }
                };
            }
            return new DocIdSetIterator(){
                private int doc = -1;

                public boolean next() throws IOException {
                    return this.nextDoc() != Integer.MAX_VALUE;
                }

                public boolean skipTo(int target) throws IOException {
                    return this.advance(target) != Integer.MAX_VALUE;
                }

                public int doc() {
                    return this.doc;
                }

                public int docID() {
                    return this.doc;
                }

                public int nextDoc() {
                    try {
                        do {
                            ++this.doc;
                        } while (!FieldCacheDocIdSet.this.matchDoc(this.doc));
                        return this.doc;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                }

                public int advance(int target) {
                    try {
                        this.doc = target;
                        while (!FieldCacheDocIdSet.this.matchDoc(this.doc)) {
                            ++this.doc;
                        }
                        return this.doc;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                }
            };
        }
    }
}

