/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.DisjunctionMaxScorer;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class DisjunctionMaxQuery
extends Query {
    private ArrayList disjuncts = new ArrayList();
    private float tieBreakerMultiplier = 0.0f;

    public DisjunctionMaxQuery(float tieBreakerMultiplier) {
        this.tieBreakerMultiplier = tieBreakerMultiplier;
    }

    public DisjunctionMaxQuery(Collection disjuncts, float tieBreakerMultiplier) {
        this.tieBreakerMultiplier = tieBreakerMultiplier;
        this.add(disjuncts);
    }

    public void add(Query query) {
        this.disjuncts.add(query);
    }

    public void add(Collection disjuncts) {
        this.disjuncts.addAll(disjuncts);
    }

    public Iterator iterator() {
        return this.disjuncts.iterator();
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new DisjunctionMaxWeight(searcher);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        int numDisjunctions = this.disjuncts.size();
        if (numDisjunctions == 1) {
            Query singleton = (Query)this.disjuncts.get(0);
            Query result2 = singleton.rewrite(reader);
            if (this.getBoost() != 1.0f) {
                if (result2 == singleton) {
                    result2 = (Query)result2.clone();
                }
                result2.setBoost(this.getBoost() * result2.getBoost());
            }
            return result2;
        }
        DisjunctionMaxQuery clone2 = null;
        for (int i = 0; i < numDisjunctions; ++i) {
            Query clause = (Query)this.disjuncts.get(i);
            Query rewrite = clause.rewrite(reader);
            if (rewrite == clause) continue;
            if (clone2 == null) {
                clone2 = (DisjunctionMaxQuery)this.clone();
            }
            clone2.disjuncts.set(i, rewrite);
        }
        if (clone2 != null) {
            return clone2;
        }
        return this;
    }

    public Object clone() {
        DisjunctionMaxQuery clone2 = (DisjunctionMaxQuery)super.clone();
        clone2.disjuncts = (ArrayList)this.disjuncts.clone();
        return clone2;
    }

    public void extractTerms(Set terms) {
        Iterator iter2 = this.disjuncts.iterator();
        while (iter2.hasNext()) {
            ((Query)iter2.next()).extractTerms(terms);
        }
    }

    public String toString(String field2) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        int numDisjunctions = this.disjuncts.size();
        for (int i = 0; i < numDisjunctions; ++i) {
            Query subquery = (Query)this.disjuncts.get(i);
            if (subquery instanceof BooleanQuery) {
                buffer.append("(");
                buffer.append(subquery.toString(field2));
                buffer.append(")");
            } else {
                buffer.append(subquery.toString(field2));
            }
            if (i == numDisjunctions - 1) continue;
            buffer.append(" | ");
        }
        buffer.append(")");
        if (this.tieBreakerMultiplier != 0.0f) {
            buffer.append("~");
            buffer.append(this.tieBreakerMultiplier);
        }
        if ((double)this.getBoost() != 1.0) {
            buffer.append("^");
            buffer.append(this.getBoost());
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof DisjunctionMaxQuery)) {
            return false;
        }
        DisjunctionMaxQuery other = (DisjunctionMaxQuery)o;
        return this.getBoost() == other.getBoost() && this.tieBreakerMultiplier == other.tieBreakerMultiplier && this.disjuncts.equals(other.disjuncts);
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) + Float.floatToIntBits(this.tieBreakerMultiplier) + this.disjuncts.hashCode();
    }

    protected class DisjunctionMaxWeight
    extends Weight {
        protected Similarity similarity;
        protected ArrayList weights = new ArrayList();

        public DisjunctionMaxWeight(Searcher searcher) throws IOException {
            this.similarity = searcher.getSimilarity();
            Iterator iter2 = DisjunctionMaxQuery.this.disjuncts.iterator();
            while (iter2.hasNext()) {
                this.weights.add(((Query)iter2.next()).createWeight(searcher));
            }
        }

        public Query getQuery() {
            return DisjunctionMaxQuery.this;
        }

        public float getValue() {
            return DisjunctionMaxQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() throws IOException {
            float max2 = 0.0f;
            float sum2 = 0.0f;
            Iterator iter2 = this.weights.iterator();
            while (iter2.hasNext()) {
                float sub = ((Weight)iter2.next()).sumOfSquaredWeights();
                sum2 += sub;
                max2 = Math.max(max2, sub);
            }
            float boost = DisjunctionMaxQuery.this.getBoost();
            return ((sum2 - max2) * DisjunctionMaxQuery.this.tieBreakerMultiplier * DisjunctionMaxQuery.this.tieBreakerMultiplier + max2) * boost * boost;
        }

        public void normalize(float norm) {
            norm *= DisjunctionMaxQuery.this.getBoost();
            Iterator iter2 = this.weights.iterator();
            while (iter2.hasNext()) {
                ((Weight)iter2.next()).normalize(norm);
            }
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer[] scorers = new Scorer[this.weights.size()];
            int idx = 0;
            Iterator iter2 = this.weights.iterator();
            while (iter2.hasNext()) {
                Weight w = (Weight)iter2.next();
                Scorer subScorer = w.scorer(reader, true, false);
                if (subScorer == null || subScorer.nextDoc() == Integer.MAX_VALUE) continue;
                scorers[idx++] = subScorer;
            }
            if (idx == 0) {
                return null;
            }
            DisjunctionMaxScorer result2 = new DisjunctionMaxScorer(DisjunctionMaxQuery.this.tieBreakerMultiplier, this.similarity, scorers, idx);
            return result2;
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            if (DisjunctionMaxQuery.this.disjuncts.size() == 1) {
                return ((Weight)this.weights.get(0)).explain(reader, doc);
            }
            ComplexExplanation result2 = new ComplexExplanation();
            float max2 = 0.0f;
            float sum2 = 0.0f;
            result2.setDescription(DisjunctionMaxQuery.this.tieBreakerMultiplier == 0.0f ? "max of:" : "max plus " + DisjunctionMaxQuery.this.tieBreakerMultiplier + " times others of:");
            Iterator iter2 = this.weights.iterator();
            while (iter2.hasNext()) {
                Explanation e = ((Weight)iter2.next()).explain(reader, doc);
                if (!e.isMatch()) continue;
                result2.setMatch(Boolean.TRUE);
                result2.addDetail(e);
                sum2 += e.getValue();
                max2 = Math.max(max2, e.getValue());
            }
            result2.setValue(max2 + (sum2 - max2) * DisjunctionMaxQuery.this.tieBreakerMultiplier);
            return result2;
        }
    }
}

