/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.SpanFilter;
import org.apache.lucene.search.SpanFilterResult;

public class CachingSpanFilter
extends SpanFilter {
    protected SpanFilter filter;
    private final CachingWrapperFilter.FilterCache cache;
    int hitCount;
    int missCount;

    public CachingSpanFilter(SpanFilter filter2) {
        this(filter2, CachingWrapperFilter.DeletesMode.RECACHE);
    }

    public CachingSpanFilter(SpanFilter filter2, CachingWrapperFilter.DeletesMode deletesMode) {
        this.filter = filter2;
        if (deletesMode == CachingWrapperFilter.DeletesMode.DYNAMIC) {
            throw new IllegalArgumentException("DeletesMode.DYNAMIC is not supported");
        }
        this.cache = new CachingWrapperFilter.FilterCache(deletesMode){

            protected Object mergeDeletes(IndexReader r, Object value2) {
                throw new IllegalStateException("DeletesMode.DYNAMIC is not supported");
            }
        };
    }

    public BitSet bits(IndexReader reader) throws IOException {
        SpanFilterResult result2 = this.getCachedResult(reader);
        return result2 != null ? result2.getBits() : null;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        SpanFilterResult result2 = this.getCachedResult(reader);
        return result2 != null ? result2.getDocIdSet() : null;
    }

    private SpanFilterResult getCachedResult(IndexReader reader) throws IOException {
        Object delCoreKey;
        Object coreKey = reader.getFieldCacheKey();
        SpanFilterResult result2 = (SpanFilterResult)this.cache.get(reader, coreKey, delCoreKey = reader.hasDeletions() ? reader.getDeletesCacheKey() : coreKey);
        if (result2 != null) {
            ++this.hitCount;
            return result2;
        }
        ++this.missCount;
        result2 = this.filter.bitSpans(reader);
        this.cache.put(coreKey, delCoreKey, result2);
        return result2;
    }

    public SpanFilterResult bitSpans(IndexReader reader) throws IOException {
        return this.getCachedResult(reader);
    }

    public String toString() {
        return "CachingSpanFilter(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingSpanFilter)) {
            return false;
        }
        return this.filter.equals(((CachingSpanFilter)o).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }
}

