/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanScorer;
import org.apache.lucene.search.BooleanScorer2;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SimilarityDelegator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;

public class BooleanQuery
extends Query {
    private static int maxClauseCount = 1024;
    private ArrayList clauses = new ArrayList();
    private boolean disableCoord;
    protected int minNrShouldMatch = 0;
    private static boolean allowDocsOutOfOrder = true;

    public static int getMaxClauseCount() {
        return maxClauseCount;
    }

    public static void setMaxClauseCount(int maxClauseCount) {
        if (maxClauseCount < 1) {
            throw new IllegalArgumentException("maxClauseCount must be >= 1");
        }
        BooleanQuery.maxClauseCount = maxClauseCount;
    }

    public BooleanQuery() {
    }

    public BooleanQuery(boolean disableCoord) {
        this.disableCoord = disableCoord;
    }

    public boolean isCoordDisabled() {
        return this.disableCoord;
    }

    public Similarity getSimilarity(Searcher searcher) {
        Similarity result2 = super.getSimilarity(searcher);
        if (this.disableCoord) {
            result2 = new SimilarityDelegator(result2){

                public float coord(int overlap, int maxOverlap) {
                    return 1.0f;
                }
            };
        }
        return result2;
    }

    public void setMinimumNumberShouldMatch(int min2) {
        this.minNrShouldMatch = min2;
    }

    public int getMinimumNumberShouldMatch() {
        return this.minNrShouldMatch;
    }

    public void add(Query query, BooleanClause.Occur occur) {
        this.add(new BooleanClause(query, occur));
    }

    public void add(BooleanClause clause) {
        if (this.clauses.size() >= maxClauseCount) {
            throw new TooManyClauses();
        }
        this.clauses.add(clause);
    }

    public BooleanClause[] getClauses() {
        return this.clauses.toArray(new BooleanClause[this.clauses.size()]);
    }

    public List clauses() {
        return this.clauses;
    }

    public static void setAllowDocsOutOfOrder(boolean allow) {
        allowDocsOutOfOrder = allow;
    }

    public static boolean getAllowDocsOutOfOrder() {
        return allowDocsOutOfOrder;
    }

    public static void setUseScorer14(boolean use14) {
        BooleanQuery.setAllowDocsOutOfOrder(use14);
    }

    public static boolean getUseScorer14() {
        return BooleanQuery.getAllowDocsOutOfOrder();
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new BooleanWeight(searcher);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        BooleanClause c;
        if (this.minNrShouldMatch == 0 && this.clauses.size() == 1 && !(c = (BooleanClause)this.clauses.get(0)).isProhibited()) {
            Query query = c.getQuery().rewrite(reader);
            if (this.getBoost() != 1.0f) {
                if (query == c.getQuery()) {
                    query = (Query)query.clone();
                }
                query.setBoost(this.getBoost() * query.getBoost());
            }
            return query;
        }
        BooleanQuery clone2 = null;
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause c2 = (BooleanClause)this.clauses.get(i);
            Query query = c2.getQuery().rewrite(reader);
            if (query == c2.getQuery()) continue;
            if (clone2 == null) {
                clone2 = (BooleanQuery)this.clone();
            }
            clone2.clauses.set(i, new BooleanClause(query, c2.getOccur()));
        }
        if (clone2 != null) {
            return clone2;
        }
        return this;
    }

    public void extractTerms(Set terms) {
        Iterator i = this.clauses.iterator();
        while (i.hasNext()) {
            BooleanClause clause = (BooleanClause)i.next();
            clause.getQuery().extractTerms(terms);
        }
    }

    public Object clone() {
        BooleanQuery clone2 = (BooleanQuery)super.clone();
        clone2.clauses = (ArrayList)this.clauses.clone();
        return clone2;
    }

    public String toString(String field2) {
        boolean needParens;
        StringBuffer buffer = new StringBuffer();
        boolean bl = needParens = (double)this.getBoost() != 1.0 || this.getMinimumNumberShouldMatch() > 0;
        if (needParens) {
            buffer.append("(");
        }
        for (int i = 0; i < this.clauses.size(); ++i) {
            BooleanClause c = (BooleanClause)this.clauses.get(i);
            if (c.isProhibited()) {
                buffer.append("-");
            } else if (c.isRequired()) {
                buffer.append("+");
            }
            Query subQuery = c.getQuery();
            if (subQuery != null) {
                if (subQuery instanceof BooleanQuery) {
                    buffer.append("(");
                    buffer.append(subQuery.toString(field2));
                    buffer.append(")");
                } else {
                    buffer.append(subQuery.toString(field2));
                }
            } else {
                buffer.append("null");
            }
            if (i == this.clauses.size() - 1) continue;
            buffer.append(" ");
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.getMinimumNumberShouldMatch() > 0) {
            buffer.append('~');
            buffer.append(this.getMinimumNumberShouldMatch());
        }
        if (this.getBoost() != 1.0f) {
            buffer.append(ToStringUtils.boost(this.getBoost()));
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BooleanQuery)) {
            return false;
        }
        BooleanQuery other = (BooleanQuery)o;
        return this.getBoost() == other.getBoost() && this.clauses.equals(other.clauses) && this.getMinimumNumberShouldMatch() == other.getMinimumNumberShouldMatch() && this.disableCoord == other.disableCoord;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.clauses.hashCode() + this.getMinimumNumberShouldMatch() + (this.disableCoord ? 17 : 0);
    }

    protected class BooleanWeight
    extends Weight {
        protected Similarity similarity;
        protected ArrayList weights;

        public BooleanWeight(Searcher searcher) throws IOException {
            this.similarity = BooleanQuery.this.getSimilarity(searcher);
            this.weights = new ArrayList(BooleanQuery.this.clauses.size());
            for (int i = 0; i < BooleanQuery.this.clauses.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.get(i);
                this.weights.add(c.getQuery().createWeight(searcher));
            }
        }

        public Query getQuery() {
            return BooleanQuery.this;
        }

        public float getValue() {
            return BooleanQuery.this.getBoost();
        }

        public float sumOfSquaredWeights() throws IOException {
            float sum2 = 0.0f;
            for (int i = 0; i < this.weights.size(); ++i) {
                BooleanClause c = (BooleanClause)BooleanQuery.this.clauses.get(i);
                Weight w = (Weight)this.weights.get(i);
                float s = w.sumOfSquaredWeights();
                if (c.isProhibited()) continue;
                sum2 += s;
            }
            return sum2 *= BooleanQuery.this.getBoost() * BooleanQuery.this.getBoost();
        }

        public void normalize(float norm) {
            norm *= BooleanQuery.this.getBoost();
            Iterator iter2 = this.weights.iterator();
            while (iter2.hasNext()) {
                Weight w = (Weight)iter2.next();
                w.normalize(norm);
            }
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            int minShouldMatch = BooleanQuery.this.getMinimumNumberShouldMatch();
            ComplexExplanation sumExpl = new ComplexExplanation();
            sumExpl.setDescription("sum of:");
            int coord = 0;
            int maxCoord = 0;
            float sum2 = 0.0f;
            boolean fail = false;
            int shouldMatchCount = 0;
            Iterator wIter = this.weights.iterator();
            Iterator cIter = BooleanQuery.this.clauses.iterator();
            while (wIter.hasNext()) {
                Explanation r;
                Weight w = (Weight)wIter.next();
                BooleanClause c = (BooleanClause)cIter.next();
                if (w.scorer(reader, true, true) == null) continue;
                Explanation e = w.explain(reader, doc);
                if (!c.isProhibited()) {
                    ++maxCoord;
                }
                if (e.isMatch()) {
                    if (!c.isProhibited()) {
                        sumExpl.addDetail(e);
                        sum2 += e.getValue();
                        ++coord;
                    } else {
                        r = new Explanation(0.0f, "match on prohibited clause (" + c.getQuery().toString() + ")");
                        r.addDetail(e);
                        sumExpl.addDetail(r);
                        fail = true;
                    }
                    if (c.getOccur() != BooleanClause.Occur.SHOULD) continue;
                    ++shouldMatchCount;
                    continue;
                }
                if (!c.isRequired()) continue;
                r = new Explanation(0.0f, "no match on required clause (" + c.getQuery().toString() + ")");
                r.addDetail(e);
                sumExpl.addDetail(r);
                fail = true;
            }
            if (fail) {
                sumExpl.setMatch(Boolean.FALSE);
                sumExpl.setValue(0.0f);
                sumExpl.setDescription("Failure to meet condition(s) of required/prohibited clause(s)");
                return sumExpl;
            }
            if (shouldMatchCount < minShouldMatch) {
                sumExpl.setMatch(Boolean.FALSE);
                sumExpl.setValue(0.0f);
                sumExpl.setDescription("Failure to match minimum number of optional clauses: " + minShouldMatch);
                return sumExpl;
            }
            sumExpl.setMatch(0 < coord ? Boolean.TRUE : Boolean.FALSE);
            sumExpl.setValue(sum2);
            float coordFactor = this.similarity.coord(coord, maxCoord);
            if (coordFactor == 1.0f) {
                return sumExpl;
            }
            ComplexExplanation result2 = new ComplexExplanation(sumExpl.isMatch(), sum2 * coordFactor, "product of:");
            result2.addDetail(sumExpl);
            result2.addDetail(new Explanation(coordFactor, "coord(" + coord + "/" + maxCoord + ")"));
            return result2;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            ArrayList<Scorer> required = new ArrayList<Scorer>();
            ArrayList<Scorer> prohibited = new ArrayList<Scorer>();
            ArrayList<Scorer> optional = new ArrayList<Scorer>();
            Iterator wIter = this.weights.iterator();
            Iterator cIter = BooleanQuery.this.clauses.iterator();
            while (wIter.hasNext()) {
                Weight w = (Weight)wIter.next();
                BooleanClause c = (BooleanClause)cIter.next();
                Scorer subScorer = w.scorer(reader, true, false);
                if (subScorer == null) {
                    if (!c.isRequired()) continue;
                    return null;
                }
                if (c.isRequired()) {
                    required.add(subScorer);
                    continue;
                }
                if (c.isProhibited()) {
                    prohibited.add(subScorer);
                    continue;
                }
                optional.add(subScorer);
            }
            if (!(scoreDocsInOrder |= !allowDocsOutOfOrder) && topScorer && required.size() == 0 && prohibited.size() < 32) {
                return new BooleanScorer(this.similarity, BooleanQuery.this.minNrShouldMatch, optional, prohibited);
            }
            if (required.size() == 0 && optional.size() == 0) {
                return null;
            }
            if (optional.size() < BooleanQuery.this.minNrShouldMatch) {
                return null;
            }
            return new BooleanScorer2(this.similarity, BooleanQuery.this.minNrShouldMatch, required, prohibited, optional);
        }

        public boolean scoresDocsOutOfOrder() {
            int numProhibited = 0;
            Iterator cIter = BooleanQuery.this.clauses.iterator();
            while (cIter.hasNext()) {
                BooleanClause c = (BooleanClause)cIter.next();
                if (c.isRequired()) {
                    return false;
                }
                if (!c.isProhibited()) continue;
                ++numProhibited;
            }
            return numProhibited <= 32;
        }
    }

    public static class TooManyClauses
    extends RuntimeException {
        public String getMessage() {
            return "maxClauseCount is set to " + maxClauseCount;
        }
    }
}

