/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldsWriter;
import org.apache.lucene.index.StoredFieldsWriter;
import org.apache.lucene.store.IndexOutput;

final class StoredFieldsWriterPerThread {
    final FieldsWriter localFieldsWriter;
    final StoredFieldsWriter storedFieldsWriter;
    final DocumentsWriter.DocState docState;
    StoredFieldsWriter.PerDoc doc;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StoredFieldsWriterPerThread(DocumentsWriter.DocState docState, StoredFieldsWriter storedFieldsWriter) throws IOException {
        this.storedFieldsWriter = storedFieldsWriter;
        this.docState = docState;
        this.localFieldsWriter = new FieldsWriter((IndexOutput)null, (IndexOutput)null, storedFieldsWriter.fieldInfos);
    }

    public void startDocument() {
        if (this.doc != null) {
            this.doc.reset();
            this.doc.docID = this.docState.docID;
        }
    }

    public void addField(Fieldable field2, FieldInfo fieldInfo) throws IOException {
        if (this.doc == null) {
            this.doc = this.storedFieldsWriter.getPerDoc();
            this.doc.docID = this.docState.docID;
            this.localFieldsWriter.setFieldsStream(this.doc.fdt);
            if (!$assertionsDisabled && this.doc.numStoredFields != 0) {
                throw new AssertionError((Object)("doc.numStoredFields=" + this.doc.numStoredFields));
            }
            if (!$assertionsDisabled && 0L != this.doc.fdt.length()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && 0L != this.doc.fdt.getFilePointer()) {
                throw new AssertionError();
            }
        }
        this.localFieldsWriter.writeField(fieldInfo, field2);
        if (!$assertionsDisabled && !this.docState.testPoint("StoredFieldsWriterPerThread.processFields.writeField")) {
            throw new AssertionError();
        }
        ++this.doc.numStoredFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentsWriter.DocWriter finishDocument() {
        try {
            StoredFieldsWriter.PerDoc perDoc = this.doc;
            Object var3_2 = null;
            this.doc = null;
            return perDoc;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.doc = null;
            throw throwable;
        }
    }

    public void abort() {
        if (this.doc != null) {
            this.doc.abort();
            this.doc = null;
        }
    }

    static {
        $assertionsDisabled = !StoredFieldsWriterPerThread.class.desiredAssertionStatus();
    }
}

