/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Serializable;
import org.apache.lucene.util.ArrayUtil;

public class Payload
implements Serializable,
Cloneable {
    protected byte[] data;
    protected int offset;
    protected int length;

    public Payload() {
    }

    public Payload(byte[] data2) {
        this(data2, 0, data2.length);
    }

    public Payload(byte[] data2, int offset, int length) {
        if (offset < 0 || offset + length > data2.length) {
            throw new IllegalArgumentException();
        }
        this.data = data2;
        this.offset = offset;
        this.length = length;
    }

    public void setData(byte[] data2) {
        this.setData(data2, 0, data2.length);
    }

    public void setData(byte[] data2, int offset, int length) {
        this.data = data2;
        this.offset = offset;
        this.length = length;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getOffset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public byte byteAt(int index) {
        if (0 <= index && index < this.length) {
            return this.data[this.offset + index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public byte[] toByteArray() {
        byte[] retArray = new byte[this.length];
        System.arraycopy(this.data, this.offset, retArray, 0, this.length);
        return retArray;
    }

    public void copyTo(byte[] target, int targetOffset) {
        if (this.length > target.length + targetOffset) {
            throw new ArrayIndexOutOfBoundsException();
        }
        System.arraycopy(this.data, this.offset, target, targetOffset, this.length);
    }

    public Object clone() {
        try {
            Payload clone2 = (Payload)super.clone();
            if (this.offset == 0 && this.length == this.data.length) {
                clone2.data = (byte[])this.data.clone();
            } else {
                clone2.data = this.toByteArray();
                clone2.offset = 0;
            }
            return clone2;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Payload) {
            Payload other = (Payload)obj;
            if (this.length == other.length) {
                for (int i = 0; i < this.length; ++i) {
                    if (this.data[this.offset + i] == other.data[other.offset + i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return ArrayUtil.hashCode(this.data, this.offset, this.offset + this.length);
    }
}

