/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.store.Directory;

public class FilterIndexReader
extends IndexReader {
    protected IndexReader in;

    public FilterIndexReader(IndexReader in) {
        this.in = in;
    }

    public Directory directory() {
        return this.in.directory();
    }

    public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
        this.ensureOpen();
        return this.in.getTermFreqVectors(docNumber);
    }

    public TermFreqVector getTermFreqVector(int docNumber, String field2) throws IOException {
        this.ensureOpen();
        return this.in.getTermFreqVector(docNumber, field2);
    }

    public void getTermFreqVector(int docNumber, String field2, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        this.in.getTermFreqVector(docNumber, field2, mapper);
    }

    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        this.in.getTermFreqVector(docNumber, mapper);
    }

    public int numDocs() {
        return this.in.numDocs();
    }

    public int maxDoc() {
        return this.in.maxDoc();
    }

    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        return this.in.document(n, fieldSelector);
    }

    public boolean isDeleted(int n) {
        return this.in.isDeleted(n);
    }

    public boolean hasDeletions() {
        return this.in.hasDeletions();
    }

    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        this.in.undeleteAll();
    }

    public boolean hasNorms(String field2) throws IOException {
        this.ensureOpen();
        return this.in.hasNorms(field2);
    }

    public byte[] norms(String f2) throws IOException {
        this.ensureOpen();
        return this.in.norms(f2);
    }

    public void norms(String f2, byte[] bytes, int offset) throws IOException {
        this.ensureOpen();
        this.in.norms(f2, bytes, offset);
    }

    protected void doSetNorm(int d, String f2, byte b) throws CorruptIndexException, IOException {
        this.in.setNorm(d, f2, b);
    }

    public TermEnum terms() throws IOException {
        this.ensureOpen();
        return this.in.terms();
    }

    public TermEnum terms(Term t) throws IOException {
        this.ensureOpen();
        return this.in.terms(t);
    }

    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        return this.in.docFreq(t);
    }

    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return this.in.termDocs();
    }

    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        return this.in.termDocs(term);
    }

    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return this.in.termPositions();
    }

    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.in.deleteDocument(n);
    }

    protected void doCommit() throws IOException {
        this.doCommit(null);
    }

    protected void doCommit(Map commitUserData) throws IOException {
        this.in.commit(commitUserData);
    }

    protected void doClose() throws IOException {
        this.in.close();
        FieldCache.DEFAULT.purge(this);
    }

    public Collection getFieldNames(IndexReader.FieldOption fieldNames) {
        this.ensureOpen();
        return this.in.getFieldNames(fieldNames);
    }

    public long getVersion() {
        this.ensureOpen();
        return this.in.getVersion();
    }

    public boolean isCurrent() throws CorruptIndexException, IOException {
        this.ensureOpen();
        return this.in.isCurrent();
    }

    public boolean isOptimized() {
        this.ensureOpen();
        return this.in.isOptimized();
    }

    public IndexReader[] getSequentialSubReaders() {
        return this.in.getSequentialSubReaders();
    }

    public Object getFieldCacheKey() {
        return this.in.getFieldCacheKey();
    }

    public Object getDeletesCacheKey() {
        return this.in.getDeletesCacheKey();
    }

    public static class FilterTermEnum
    extends TermEnum {
        protected TermEnum in;

        public FilterTermEnum(TermEnum in) {
            this.in = in;
        }

        public boolean next() throws IOException {
            return this.in.next();
        }

        public Term term() {
            return this.in.term();
        }

        public int docFreq() {
            return this.in.docFreq();
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    public static class FilterTermPositions
    extends FilterTermDocs
    implements TermPositions {
        public FilterTermPositions(TermPositions in) {
            super(in);
        }

        public int nextPosition() throws IOException {
            return ((TermPositions)this.in).nextPosition();
        }

        public int getPayloadLength() {
            return ((TermPositions)this.in).getPayloadLength();
        }

        public byte[] getPayload(byte[] data2, int offset) throws IOException {
            return ((TermPositions)this.in).getPayload(data2, offset);
        }

        public boolean isPayloadAvailable() {
            return ((TermPositions)this.in).isPayloadAvailable();
        }
    }

    public static class FilterTermDocs
    implements TermDocs {
        protected TermDocs in;

        public FilterTermDocs(TermDocs in) {
            this.in = in;
        }

        public void seek(Term term) throws IOException {
            this.in.seek(term);
        }

        public void seek(TermEnum termEnum) throws IOException {
            this.in.seek(termEnum);
        }

        public int doc() {
            return this.in.doc();
        }

        public int freq() {
            return this.in.freq();
        }

        public boolean next() throws IOException {
            return this.in.next();
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            return this.in.read(docs, freqs);
        }

        public boolean skipTo(int i) throws IOException {
            return this.in.skipTo(i);
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

