/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocInverterPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.InvertedDocConsumerPerField;
import org.apache.lucene.index.InvertedDocEndConsumerPerField;

final class DocInverterPerField
extends DocFieldConsumerPerField {
    private final DocInverterPerThread perThread;
    private final FieldInfo fieldInfo;
    final InvertedDocConsumerPerField consumer;
    final InvertedDocEndConsumerPerField endConsumer;
    final DocumentsWriter.DocState docState;
    final FieldInvertState fieldState;
    static /* synthetic */ Class class$org$apache$lucene$analysis$tokenattributes$OffsetAttribute;
    static /* synthetic */ Class class$org$apache$lucene$analysis$tokenattributes$PositionIncrementAttribute;

    public DocInverterPerField(DocInverterPerThread perThread, FieldInfo fieldInfo) {
        this.perThread = perThread;
        this.fieldInfo = fieldInfo;
        this.docState = perThread.docState;
        this.fieldState = perThread.fieldState;
        this.consumer = perThread.consumer.addField(this, fieldInfo);
        this.endConsumer = perThread.endConsumer.addField(this, fieldInfo);
    }

    void abort() {
        this.consumer.abort();
        this.endConsumer.abort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFields(Fieldable[] fields, int count2) throws IOException {
        this.fieldState.reset(this.docState.doc.getBoost());
        int maxFieldLength = this.docState.maxFieldLength;
        boolean doInvert = this.consumer.start(fields, count2);
        for (int i = 0; i < count2; ++i) {
            Fieldable field2 = fields[i];
            if (field2.isIndexed() && doInvert) {
                boolean anyToken;
                if (this.fieldState.length > 0) {
                    this.fieldState.position += this.docState.analyzer.getPositionIncrementGap(this.fieldInfo.name);
                }
                if (!field2.isTokenized()) {
                    Object var12_17;
                    String stringValue = field2.stringValue();
                    int valueLength = stringValue.length();
                    this.perThread.singleTokenTokenStream.reinit(stringValue, 0, valueLength);
                    this.fieldState.attributeSource = this.perThread.singleTokenTokenStream;
                    this.consumer.start(field2);
                    boolean success2 = false;
                    try {
                        this.consumer.add();
                        success2 = true;
                        var12_17 = null;
                        if (!success2) {
                            this.docState.docWriter.setAborting();
                        }
                    }
                    catch (Throwable throwable) {
                        var12_17 = null;
                        if (!success2) {
                            this.docState.docWriter.setAborting();
                        }
                        throw throwable;
                    }
                    this.fieldState.offset += valueLength;
                    ++this.fieldState.length;
                    ++this.fieldState.position;
                    anyToken = valueLength > 0;
                } else {
                    Object var21_25;
                    TokenStream stream;
                    TokenStream streamValue = field2.tokenStreamValue();
                    if (streamValue != null) {
                        stream = streamValue;
                    } else {
                        Reader reader;
                        Reader readerValue = field2.readerValue();
                        if (readerValue != null) {
                            reader = readerValue;
                        } else {
                            String stringValue = field2.stringValue();
                            if (stringValue == null) {
                                throw new IllegalArgumentException("field must have either TokenStream, String or Reader value");
                            }
                            this.perThread.stringReader.init(stringValue);
                            reader = this.perThread.stringReader;
                        }
                        stream = this.docState.analyzer.reusableTokenStream(this.fieldInfo.name, reader);
                    }
                    stream.reset();
                    int startLength = this.fieldState.length;
                    boolean allowMinus1Position = this.docState.allowMinus1Position;
                    try {
                        int offsetEnd = this.fieldState.offset - 1;
                        boolean hasMoreTokens = stream.incrementToken();
                        this.fieldState.attributeSource = stream;
                        OffsetAttribute offsetAttribute = (OffsetAttribute)this.fieldState.attributeSource.addAttribute(class$org$apache$lucene$analysis$tokenattributes$OffsetAttribute == null ? DocInverterPerField.class$("org.apache.lucene.analysis.tokenattributes.OffsetAttribute") : class$org$apache$lucene$analysis$tokenattributes$OffsetAttribute);
                        PositionIncrementAttribute posIncrAttribute = (PositionIncrementAttribute)this.fieldState.attributeSource.addAttribute(class$org$apache$lucene$analysis$tokenattributes$PositionIncrementAttribute == null ? DocInverterPerField.class$("org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute") : class$org$apache$lucene$analysis$tokenattributes$PositionIncrementAttribute);
                        this.consumer.start(field2);
                        while (hasMoreTokens) {
                            Object var19_24;
                            int posIncr = posIncrAttribute.getPositionIncrement();
                            this.fieldState.position += posIncr;
                            if (allowMinus1Position || this.fieldState.position > 0) {
                                --this.fieldState.position;
                            }
                            if (posIncr == 0) {
                                ++this.fieldState.numOverlap;
                            }
                            boolean success3 = false;
                            try {
                                this.consumer.add();
                                success3 = true;
                                var19_24 = null;
                                if (!success3) {
                                    this.docState.docWriter.setAborting();
                                }
                            }
                            catch (Throwable throwable) {
                                var19_24 = null;
                                if (!success3) {
                                    this.docState.docWriter.setAborting();
                                }
                                throw throwable;
                            }
                            ++this.fieldState.position;
                            offsetEnd = this.fieldState.offset + offsetAttribute.endOffset();
                            if (++this.fieldState.length >= maxFieldLength) {
                                if (this.docState.infoStream == null) break;
                                this.docState.infoStream.println("maxFieldLength " + maxFieldLength + " reached for field " + this.fieldInfo.name + ", ignoring following tokens");
                                break;
                            }
                            hasMoreTokens = stream.incrementToken();
                        }
                        stream.end();
                        this.fieldState.offset += offsetAttribute.endOffset();
                        anyToken = this.fieldState.length > startLength;
                        var21_25 = null;
                    }
                    catch (Throwable throwable) {
                        var21_25 = null;
                        stream.close();
                        throw throwable;
                    }
                    stream.close();
                    {
                    }
                }
                if (anyToken) {
                    this.fieldState.offset += this.docState.analyzer.getOffsetGap(field2);
                }
                this.fieldState.boost *= field2.getBoost();
            }
            fields[i] = null;
        }
        this.consumer.finish();
        this.endConsumer.finish();
    }
}

