/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.ReadOnlyDirectoryReader;
import org.apache.lucene.index.ReadOnlySegmentReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMergeInfo;
import org.apache.lucene.index.SegmentMergeQueue;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StaleReaderException;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockObtainFailedException;

class DirectoryReader
extends IndexReader
implements Cloneable {
    protected Directory directory;
    protected boolean readOnly;
    IndexWriter writer;
    private IndexDeletionPolicy deletionPolicy;
    private final HashSet synced = new HashSet();
    private Lock writeLock;
    private SegmentInfos segmentInfos;
    private SegmentInfos segmentInfosStart;
    private boolean stale;
    private final int termInfosIndexDivisor;
    private boolean rollbackHasChanges;
    private SegmentInfos rollbackSegmentInfos;
    private SegmentReader[] subReaders;
    private int[] starts;
    private Map normsCache = new HashMap();
    private int maxDoc = 0;
    private int numDocs = -1;
    private boolean hasDeletions = false;
    private byte[] ones;
    static final /* synthetic */ boolean $assertionsDisabled;

    static IndexReader open(Directory directory, final IndexDeletionPolicy deletionPolicy, IndexCommit commit2, final boolean readOnly, final int termInfosIndexDivisor) throws CorruptIndexException, IOException {
        return (IndexReader)new SegmentInfos.FindSegmentsFile(directory){

            protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                SegmentInfos infos = new SegmentInfos();
                infos.read(this.directory, segmentFileName);
                if (readOnly) {
                    return new ReadOnlyDirectoryReader(this.directory, infos, deletionPolicy, termInfosIndexDivisor);
                }
                return new DirectoryReader(this.directory, infos, deletionPolicy, false, termInfosIndexDivisor);
            }
        }.run(commit2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryReader(Directory directory, SegmentInfos sis, IndexDeletionPolicy deletionPolicy, boolean readOnly, int termInfosIndexDivisor) throws IOException {
        this.directory = directory;
        this.readOnly = readOnly;
        this.segmentInfos = sis;
        this.deletionPolicy = deletionPolicy;
        this.termInfosIndexDivisor = termInfosIndexDivisor;
        if (!readOnly) {
            this.synced.addAll(sis.files(directory, true));
        }
        SegmentReader[] readers = new SegmentReader[sis.size()];
        for (int i = sis.size() - 1; i >= 0; --i) {
            Throwable ignore2;
            Object var10_9;
            boolean success2 = false;
            try {
                readers[i] = SegmentReader.get(readOnly, sis.info(i), termInfosIndexDivisor);
                success2 = true;
                var10_9 = null;
                if (success2) continue;
                ++i;
            }
            catch (Throwable throwable) {
                var10_9 = null;
                if (!success2) {
                    ++i;
                    while (i < sis.size()) {
                        try {
                            readers[i].close();
                        }
                        catch (Throwable ignore2) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                throw throwable;
            }
            while (i < sis.size()) {
                try {
                    readers[i].close();
                }
                catch (Throwable ignore2) {
                    // empty catch block
                }
                ++i;
            }
            continue;
        }
        this.initialize(readers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryReader(IndexWriter writer, SegmentInfos infos, int termInfosIndexDivisor) throws IOException {
        this.directory = writer.getDirectory();
        this.readOnly = true;
        this.segmentInfos = infos;
        this.segmentInfosStart = (SegmentInfos)infos.clone();
        this.termInfosIndexDivisor = termInfosIndexDivisor;
        if (!this.readOnly) {
            this.synced.addAll(infos.files(this.directory, true));
        }
        int numSegments = infos.size();
        SegmentReader[] readers = new SegmentReader[numSegments];
        Directory dir2 = writer.getDirectory();
        int upto = 0;
        for (int i = 0; i < numSegments; ++i) {
            Throwable ignore2;
            Object var12_12;
            boolean success2 = false;
            try {
                SegmentInfo info = infos.info(i);
                if (info.dir == dir2) {
                    readers[upto++] = writer.readerPool.getReadOnlyClone(info, true, termInfosIndexDivisor);
                }
                success2 = true;
                var12_12 = null;
                if (success2) continue;
                --upto;
            }
            catch (Throwable throwable) {
                var12_12 = null;
                if (!success2) {
                    --upto;
                    while (upto >= 0) {
                        try {
                            readers[upto].close();
                        }
                        catch (Throwable ignore2) {
                            // empty catch block
                        }
                        --upto;
                    }
                }
                throw throwable;
            }
            while (upto >= 0) {
                try {
                    readers[upto].close();
                }
                catch (Throwable ignore2) {
                    // empty catch block
                }
                --upto;
            }
            continue;
        }
        this.writer = writer;
        if (upto < readers.length) {
            SegmentReader[] newReaders = new SegmentReader[upto];
            System.arraycopy(readers, 0, newReaders, 0, upto);
            readers = newReaders;
        }
        this.initialize(readers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectoryReader(Directory directory, SegmentInfos infos, SegmentReader[] oldReaders, int[] oldStarts, Map oldNormsCache, boolean readOnly, boolean doClone, int termInfosIndexDivisor) throws IOException {
        this.directory = directory;
        this.readOnly = readOnly;
        this.segmentInfos = infos;
        this.termInfosIndexDivisor = termInfosIndexDivisor;
        if (!readOnly) {
            this.synced.addAll(infos.files(directory, true));
        }
        HashMap<String, Integer> segmentReaders = new HashMap<String, Integer>();
        if (oldReaders != null) {
            for (int i = 0; i < oldReaders.length; ++i) {
                segmentReaders.put(oldReaders[i].getSegmentName(), new Integer(i));
            }
        }
        SegmentReader[] newReaders = new SegmentReader[infos.size()];
        boolean[] readerShared = new boolean[infos.size()];
        for (int i = infos.size() - 1; i >= 0; --i) {
            IOException ignore2;
            Object var17_20;
            Integer oldReaderIndex = (Integer)segmentReaders.get(infos.info((int)i).name);
            newReaders[i] = oldReaderIndex == null ? null : oldReaders[oldReaderIndex];
            boolean success2 = false;
            try {
                SegmentReader newReader;
                if (newReaders[i] == null || infos.info(i).getUseCompoundFile() != newReaders[i].getSegmentInfo().getUseCompoundFile()) {
                    if (!$assertionsDisabled && doClone) {
                        throw new AssertionError();
                    }
                    newReader = SegmentReader.get(readOnly, infos.info(i), termInfosIndexDivisor);
                } else {
                    newReader = newReaders[i].reopenSegment(infos.info(i), doClone, readOnly);
                }
                if (newReader == newReaders[i]) {
                    readerShared[i] = true;
                    newReader.incRef();
                } else {
                    readerShared[i] = false;
                    newReaders[i] = newReader;
                }
                success2 = true;
                var17_20 = null;
                if (success2) continue;
                ++i;
            }
            catch (Throwable throwable) {
                var17_20 = null;
                if (!success2) {
                    ++i;
                    while (i < infos.size()) {
                        if (newReaders[i] != null) {
                            try {
                                if (!readerShared[i]) {
                                    newReaders[i].close();
                                } else {
                                    newReaders[i].decRef();
                                }
                            }
                            catch (IOException ignore2) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                }
                throw throwable;
            }
            while (i < infos.size()) {
                if (newReaders[i] != null) {
                    try {
                        if (!readerShared[i]) {
                            newReaders[i].close();
                        } else {
                            newReaders[i].decRef();
                        }
                    }
                    catch (IOException ignore2) {
                        // empty catch block
                    }
                }
                ++i;
            }
            continue;
        }
        this.initialize(newReaders);
        if (oldNormsCache != null) {
            Iterator it = oldNormsCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String field2 = (String)entry.getKey();
                if (!this.hasNorms(field2)) continue;
                byte[] oldBytes = (byte[])entry.getValue();
                byte[] bytes = new byte[this.maxDoc()];
                for (int i = 0; i < this.subReaders.length; ++i) {
                    Integer oldReaderIndex = (Integer)segmentReaders.get(this.subReaders[i].getSegmentName());
                    if (oldReaderIndex != null && (oldReaders[oldReaderIndex] == this.subReaders[i] || oldReaders[oldReaderIndex.intValue()].norms.get(field2) == this.subReaders[i].norms.get(field2))) {
                        System.arraycopy(oldBytes, oldStarts[oldReaderIndex], bytes, this.starts[i], this.starts[i + 1] - this.starts[i]);
                        continue;
                    }
                    this.subReaders[i].norms(field2, bytes, this.starts[i]);
                }
                this.normsCache.put(field2, bytes);
            }
        }
    }

    private void initialize(SegmentReader[] subReaders) {
        this.subReaders = subReaders;
        this.starts = new int[subReaders.length + 1];
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = this.maxDoc;
            this.maxDoc += subReaders[i].maxDoc();
            if (!subReaders[i].hasDeletions()) continue;
            this.hasDeletions = true;
        }
        this.starts[subReaders.length] = this.maxDoc;
    }

    public final synchronized Object clone() {
        try {
            return this.clone(this.readOnly);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public final synchronized IndexReader clone(boolean openReadOnly) throws CorruptIndexException, IOException {
        DirectoryReader newReader = this.doReopen((SegmentInfos)this.segmentInfos.clone(), true, openReadOnly);
        if (this != newReader) {
            newReader.deletionPolicy = this.deletionPolicy;
        }
        newReader.writer = this.writer;
        if (!openReadOnly && this.writeLock != null) {
            if (!$assertionsDisabled && this.writer != null) {
                throw new AssertionError();
            }
            newReader.writeLock = this.writeLock;
            newReader.hasChanges = this.hasChanges;
            newReader.hasDeletions = this.hasDeletions;
            this.writeLock = null;
            this.hasChanges = false;
        }
        return newReader;
    }

    public final IndexReader reopen() throws CorruptIndexException, IOException {
        return this.doReopen(this.readOnly, null);
    }

    public final IndexReader reopen(boolean openReadOnly) throws CorruptIndexException, IOException {
        return this.doReopen(openReadOnly, null);
    }

    public final IndexReader reopen(IndexCommit commit2) throws CorruptIndexException, IOException {
        return this.doReopen(true, commit2);
    }

    private final IndexReader doReopenFromWriter(boolean openReadOnly, IndexCommit commit2) throws CorruptIndexException, IOException {
        if (!$assertionsDisabled && !this.readOnly) {
            throw new AssertionError();
        }
        if (!openReadOnly) {
            throw new IllegalArgumentException("a reader obtained from IndexWriter.getReader() can only be reopened with openReadOnly=true (got false)");
        }
        if (commit2 != null) {
            throw new IllegalArgumentException("a reader obtained from IndexWriter.getReader() cannot currently accept a commit");
        }
        return this.writer.getReader();
    }

    private IndexReader doReopen(boolean openReadOnly, IndexCommit commit2) throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (!$assertionsDisabled && commit2 != null && !openReadOnly) {
            throw new AssertionError();
        }
        if (this.writer != null) {
            return this.doReopenFromWriter(openReadOnly, commit2);
        }
        return this.doReopenNoWriter(openReadOnly, commit2);
    }

    private synchronized IndexReader doReopenNoWriter(final boolean openReadOnly, IndexCommit commit2) throws CorruptIndexException, IOException {
        if (commit2 == null) {
            if (this.hasChanges) {
                if (!$assertionsDisabled && this.readOnly) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && this.writeLock == null) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !this.isCurrent()) {
                    throw new AssertionError();
                }
                if (openReadOnly) {
                    return this.clone(openReadOnly);
                }
                return this;
            }
            if (this.isCurrent()) {
                if (openReadOnly != this.readOnly) {
                    return this.clone(openReadOnly);
                }
                return this;
            }
        } else {
            if (this.directory != commit2.getDirectory()) {
                throw new IOException("the specified commit does not match the specified Directory");
            }
            if (this.segmentInfos != null && commit2.getSegmentsFileName().equals(this.segmentInfos.getCurrentSegmentFileName())) {
                if (this.readOnly != openReadOnly) {
                    return this.clone(openReadOnly);
                }
                return this;
            }
        }
        return (IndexReader)new SegmentInfos.FindSegmentsFile(this.directory){

            protected Object doBody(String segmentFileName) throws CorruptIndexException, IOException {
                SegmentInfos infos = new SegmentInfos();
                infos.read(this.directory, segmentFileName);
                return DirectoryReader.this.doReopen(infos, false, openReadOnly);
            }
        }.run(commit2);
    }

    private synchronized DirectoryReader doReopen(SegmentInfos infos, boolean doClone, boolean openReadOnly) throws CorruptIndexException, IOException {
        DirectoryReader reader = openReadOnly ? new ReadOnlyDirectoryReader(this.directory, infos, this.subReaders, this.starts, this.normsCache, doClone, this.termInfosIndexDivisor) : new DirectoryReader(this.directory, infos, this.subReaders, this.starts, this.normsCache, false, doClone, this.termInfosIndexDivisor);
        reader.setDisableFakeNorms(this.getDisableFakeNorms());
        return reader;
    }

    public long getVersion() {
        this.ensureOpen();
        return this.segmentInfos.getVersion();
    }

    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVectors(n - this.starts[i]);
    }

    public TermFreqVector getTermFreqVector(int n, String field2) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].getTermFreqVector(n - this.starts[i], field2);
    }

    public void getTermFreqVector(int docNumber, String field2, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(docNumber);
        this.subReaders[i].getTermFreqVector(docNumber - this.starts[i], field2, mapper);
    }

    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        this.ensureOpen();
        int i = this.readerIndex(docNumber);
        this.subReaders[i].getTermFreqVector(docNumber - this.starts[i], mapper);
    }

    public boolean isOptimized() {
        this.ensureOpen();
        return this.segmentInfos.size() == 1 && !this.hasDeletions();
    }

    public int numDocs() {
        if (this.numDocs == -1) {
            int n = 0;
            for (int i = 0; i < this.subReaders.length; ++i) {
                n += this.subReaders[i].numDocs();
            }
            this.numDocs = n;
        }
        return this.numDocs;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        int i = this.readerIndex(n);
        return this.subReaders[i].document(n - this.starts[i], fieldSelector);
    }

    public boolean isDeleted(int n) {
        int i = this.readerIndex(n);
        return this.subReaders[i].isDeleted(n - this.starts[i]);
    }

    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    protected void doDelete(int n) throws CorruptIndexException, IOException {
        this.numDocs = -1;
        int i = this.readerIndex(n);
        this.subReaders[i].deleteDocument(n - this.starts[i]);
        this.hasDeletions = true;
    }

    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].undeleteAll();
        }
        this.hasDeletions = false;
        this.numDocs = -1;
    }

    private int readerIndex(int n) {
        return DirectoryReader.readerIndex(n, this.starts, this.subReaders.length);
    }

    static final int readerIndex(int n, int[] starts2, int numSubReaders) {
        int lo = 0;
        int hi = numSubReaders - 1;
        while (hi >= lo) {
            int mid = lo + hi >>> 1;
            int midValue = starts2[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < numSubReaders && starts2[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    public boolean hasNorms(String field2) throws IOException {
        this.ensureOpen();
        for (int i = 0; i < this.subReaders.length; ++i) {
            if (!this.subReaders[i].hasNorms(field2)) continue;
            return true;
        }
        return false;
    }

    private byte[] fakeNorms() {
        if (this.ones == null) {
            this.ones = SegmentReader.createFakeNorms(this.maxDoc());
        }
        return this.ones;
    }

    public synchronized byte[] norms(String field2) throws IOException {
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field2);
        if (bytes != null) {
            return bytes;
        }
        if (!this.hasNorms(field2)) {
            return this.getDisableFakeNorms() ? null : this.fakeNorms();
        }
        bytes = new byte[this.maxDoc()];
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].norms(field2, bytes, this.starts[i]);
        }
        this.normsCache.put(field2, bytes);
        return bytes;
    }

    public synchronized void norms(String field2, byte[] result2, int offset) throws IOException {
        this.ensureOpen();
        byte[] bytes = (byte[])this.normsCache.get(field2);
        if (bytes == null && !this.hasNorms(field2)) {
            Arrays.fill(result2, offset, result2.length, DefaultSimilarity.encodeNorm(1.0f));
        } else if (bytes != null) {
            System.arraycopy(bytes, 0, result2, offset, this.maxDoc());
        } else {
            for (int i = 0; i < this.subReaders.length; ++i) {
                this.subReaders[i].norms(field2, result2, offset + this.starts[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetNorm(int n, String field2, byte value2) throws CorruptIndexException, IOException {
        Map map2 = this.normsCache;
        synchronized (map2) {
            this.normsCache.remove(field2);
        }
        int i = this.readerIndex(n);
        this.subReaders[i].setNorm(n - this.starts[i], field2, value2);
    }

    public TermEnum terms() throws IOException {
        this.ensureOpen();
        return new MultiTermEnum(this, this.subReaders, this.starts, null);
    }

    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        return new MultiTermEnum(this, this.subReaders, this.starts, term);
    }

    public int docFreq(Term t) throws IOException {
        this.ensureOpen();
        int total = 0;
        for (int i = 0; i < this.subReaders.length; ++i) {
            total += this.subReaders[i].docFreq(t);
        }
        return total;
    }

    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new MultiTermDocs(this, this.subReaders, this.starts);
    }

    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new MultiTermPositions(this, this.subReaders, this.starts);
    }

    protected void acquireWriteLock() throws StaleReaderException, CorruptIndexException, LockObtainFailedException, IOException {
        if (this.readOnly) {
            ReadOnlySegmentReader.noWrite();
        }
        if (this.segmentInfos != null) {
            this.ensureOpen();
            if (this.stale) {
                throw new StaleReaderException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
            }
            if (this.writeLock == null) {
                Lock writeLock = this.directory.makeLock("write.lock");
                if (!writeLock.obtain(IndexWriter.WRITE_LOCK_TIMEOUT)) {
                    throw new LockObtainFailedException("Index locked for write: " + writeLock);
                }
                this.writeLock = writeLock;
                if (SegmentInfos.readCurrentVersion(this.directory) > this.segmentInfos.getVersion()) {
                    this.stale = true;
                    this.writeLock.release();
                    this.writeLock = null;
                    throw new StaleReaderException("IndexReader out of date and no longer valid for delete, undelete, or setNorm operations");
                }
            }
        }
    }

    protected void doCommit() throws IOException {
        this.doCommit(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit(Map commitUserData) throws IOException {
        if (this.hasChanges) {
            IndexFileDeleter deleter;
            block8: {
                this.segmentInfos.setUserData(commitUserData);
                deleter = new IndexFileDeleter(this.directory, this.deletionPolicy == null ? new KeepOnlyLastCommitDeletionPolicy() : this.deletionPolicy, this.segmentInfos, null, null);
                this.startCommit();
                boolean success2 = false;
                try {
                    for (int i = 0; i < this.subReaders.length; ++i) {
                        this.subReaders[i].commit();
                    }
                    Iterator it = this.segmentInfos.files(this.directory, false).iterator();
                    while (it.hasNext()) {
                        String fileName = (String)it.next();
                        if (this.synced.contains(fileName)) continue;
                        if (!$assertionsDisabled && !this.directory.fileExists(fileName)) {
                            throw new AssertionError();
                        }
                        this.directory.sync(fileName);
                        this.synced.add(fileName);
                    }
                    this.segmentInfos.commit(this.directory);
                    success2 = true;
                    Object var7_7 = null;
                    if (success2) break block8;
                    this.rollbackCommit();
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (!success2) {
                        this.rollbackCommit();
                        deleter.refresh();
                    }
                    throw throwable;
                }
                deleter.refresh();
                {
                }
            }
            deleter.checkpoint(this.segmentInfos, true);
            deleter.close();
            if (this.writeLock != null) {
                this.writeLock.release();
                this.writeLock = null;
            }
        }
        this.hasChanges = false;
    }

    void startCommit() {
        this.rollbackHasChanges = this.hasChanges;
        this.rollbackSegmentInfos = (SegmentInfos)this.segmentInfos.clone();
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].startCommit();
        }
    }

    void rollbackCommit() {
        int i;
        this.hasChanges = this.rollbackHasChanges;
        for (i = 0; i < this.segmentInfos.size(); ++i) {
            this.segmentInfos.info(i).reset(this.rollbackSegmentInfos.info(i));
        }
        this.rollbackSegmentInfos = null;
        for (i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].rollbackCommit();
        }
    }

    public Map getCommitUserData() {
        this.ensureOpen();
        return this.segmentInfos.getUserData();
    }

    public boolean isCurrent() throws CorruptIndexException, IOException {
        this.ensureOpen();
        if (this.writer == null || this.writer.isClosed()) {
            return SegmentInfos.readCurrentVersion(this.directory) == this.segmentInfos.getVersion();
        }
        return this.writer.nrtIsCurrent(this.segmentInfosStart);
    }

    protected synchronized void doClose() throws IOException {
        IOException ioe = null;
        this.normsCache = null;
        for (int i = 0; i < this.subReaders.length; ++i) {
            try {
                this.subReaders[i].decRef();
                continue;
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        FieldCache.DEFAULT.purge(this);
        if (ioe != null) {
            throw ioe;
        }
    }

    public Collection getFieldNames(IndexReader.FieldOption fieldNames) {
        this.ensureOpen();
        return DirectoryReader.getFieldNames(fieldNames, this.subReaders);
    }

    static Collection getFieldNames(IndexReader.FieldOption fieldNames, IndexReader[] subReaders) {
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < subReaders.length; ++i) {
            IndexReader reader = subReaders[i];
            Collection names = reader.getFieldNames(fieldNames);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }

    public IndexReader[] getSequentialSubReaders() {
        return this.subReaders;
    }

    public void setDisableFakeNorms(boolean disableFakeNorms) {
        super.setDisableFakeNorms(disableFakeNorms);
        for (int i = 0; i < this.subReaders.length; ++i) {
            this.subReaders[i].setDisableFakeNorms(disableFakeNorms);
        }
    }

    public Directory directory() {
        return this.directory;
    }

    public int getTermInfosIndexDivisor() {
        return this.termInfosIndexDivisor;
    }

    public IndexCommit getIndexCommit() throws IOException {
        return new ReaderCommit(this.segmentInfos, this.directory);
    }

    public static Collection listCommits(Directory dir2) throws IOException {
        String[] files = dir2.listAll();
        ArrayList<ReaderCommit> commits = new ArrayList<ReaderCommit>();
        SegmentInfos latest = new SegmentInfos();
        latest.read(dir2);
        long currentGen = latest.getGeneration();
        commits.add(new ReaderCommit(latest, dir2));
        for (int i = 0; i < files.length; ++i) {
            String fileName = files[i];
            if (!fileName.startsWith("segments") || fileName.equals("segments.gen") || SegmentInfos.generationFromSegmentsFileName(fileName) >= currentGen) continue;
            SegmentInfos sis = new SegmentInfos();
            try {
                sis.read(dir2, fileName);
            }
            catch (FileNotFoundException fnfe) {
                sis = null;
            }
            if (sis == null) continue;
            commits.add(new ReaderCommit(sis, dir2));
        }
        return commits;
    }

    static {
        $assertionsDisabled = !DirectoryReader.class.desiredAssertionStatus();
    }

    static class MultiTermPositions
    extends MultiTermDocs
    implements TermPositions {
        public MultiTermPositions(IndexReader topReader, IndexReader[] r, int[] s) {
            super(topReader, r, s);
        }

        protected TermDocs termDocs(IndexReader reader) throws IOException {
            return reader.termPositions();
        }

        public int nextPosition() throws IOException {
            return ((TermPositions)this.current).nextPosition();
        }

        public int getPayloadLength() {
            return ((TermPositions)this.current).getPayloadLength();
        }

        public byte[] getPayload(byte[] data2, int offset) throws IOException {
            return ((TermPositions)this.current).getPayload(data2, offset);
        }

        public boolean isPayloadAvailable() {
            return ((TermPositions)this.current).isPayloadAvailable();
        }
    }

    static class MultiTermDocs
    implements TermDocs {
        IndexReader topReader;
        protected IndexReader[] readers;
        protected int[] starts;
        protected Term term;
        protected int base = 0;
        protected int pointer = 0;
        private TermDocs[] readerTermDocs;
        protected TermDocs current;
        private MultiTermEnum tenum;
        int matchingSegmentPos;
        SegmentMergeInfo smi;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MultiTermDocs(IndexReader topReader, IndexReader[] r, int[] s) {
            this.topReader = topReader;
            this.readers = r;
            this.starts = s;
            this.readerTermDocs = new TermDocs[r.length];
        }

        public int doc() {
            return this.base + this.current.doc();
        }

        public int freq() {
            return this.current.freq();
        }

        public void seek(Term term) {
            this.term = term;
            this.base = 0;
            this.pointer = 0;
            this.current = null;
            this.tenum = null;
            this.smi = null;
            this.matchingSegmentPos = 0;
        }

        public void seek(TermEnum termEnum) throws IOException {
            this.seek(termEnum.term());
            if (termEnum instanceof MultiTermEnum) {
                this.tenum = (MultiTermEnum)termEnum;
                if (this.topReader != this.tenum.topReader) {
                    this.tenum = null;
                }
            }
        }

        public boolean next() throws IOException {
            while (true) {
                if (this.current != null && this.current.next()) {
                    return true;
                }
                if (this.pointer >= this.readers.length) break;
                if (this.tenum != null) {
                    this.smi = this.tenum.matchingSegments[this.matchingSegmentPos++];
                    if (this.smi == null) {
                        this.pointer = this.readers.length;
                        return false;
                    }
                    this.pointer = this.smi.ord;
                }
                this.base = this.starts[this.pointer];
                this.current = this.termDocs(this.pointer++);
            }
            return false;
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            int end;
            while (true) {
                if (this.current == null) {
                    if (this.pointer < this.readers.length) {
                        if (this.tenum != null) {
                            this.smi = this.tenum.matchingSegments[this.matchingSegmentPos++];
                            if (this.smi == null) {
                                this.pointer = this.readers.length;
                                return 0;
                            }
                            this.pointer = this.smi.ord;
                        }
                        this.base = this.starts[this.pointer];
                        this.current = this.termDocs(this.pointer++);
                        continue;
                    }
                    return 0;
                }
                end = this.current.read(docs, freqs);
                if (end != 0) break;
                this.current = null;
            }
            int b = this.base;
            int i = 0;
            while (i < end) {
                int n = i++;
                docs[n] = docs[n] + b;
            }
            return end;
        }

        public boolean skipTo(int target) throws IOException {
            while (true) {
                if (this.current != null && this.current.skipTo(target - this.base)) {
                    return true;
                }
                if (this.pointer >= this.readers.length) break;
                if (this.tenum != null) {
                    SegmentMergeInfo smi;
                    if ((smi = this.tenum.matchingSegments[this.matchingSegmentPos++]) == null) {
                        this.pointer = this.readers.length;
                        return false;
                    }
                    this.pointer = smi.ord;
                }
                this.base = this.starts[this.pointer];
                this.current = this.termDocs(this.pointer++);
            }
            return false;
        }

        private TermDocs termDocs(int i) throws IOException {
            TermDocs result2 = this.readerTermDocs[i];
            if (result2 == null) {
                result2 = this.readerTermDocs[i] = this.termDocs(this.readers[i]);
            }
            if (this.smi != null) {
                if (!$assertionsDisabled && this.smi.ord != i) {
                    throw new AssertionError();
                }
                if (!$assertionsDisabled && !this.smi.termEnum.term().equals(this.term)) {
                    throw new AssertionError();
                }
                result2.seek(this.smi.termEnum);
            } else {
                result2.seek(this.term);
            }
            return result2;
        }

        protected TermDocs termDocs(IndexReader reader) throws IOException {
            return this.term == null ? reader.termDocs(null) : reader.termDocs();
        }

        public void close() throws IOException {
            for (int i = 0; i < this.readerTermDocs.length; ++i) {
                if (this.readerTermDocs[i] == null) continue;
                this.readerTermDocs[i].close();
            }
        }

        static {
            $assertionsDisabled = !(class$org$apache$lucene$index$DirectoryReader == null ? (class$org$apache$lucene$index$DirectoryReader = DirectoryReader.class$("org.apache.lucene.index.DirectoryReader")) : class$org$apache$lucene$index$DirectoryReader).desiredAssertionStatus();
        }
    }

    static class MultiTermEnum
    extends TermEnum {
        IndexReader topReader;
        private SegmentMergeQueue queue;
        private Term term;
        private int docFreq;
        final SegmentMergeInfo[] matchingSegments;

        public MultiTermEnum(IndexReader topReader, IndexReader[] readers, int[] starts2, Term t) throws IOException {
            this.topReader = topReader;
            this.queue = new SegmentMergeQueue(readers.length);
            this.matchingSegments = new SegmentMergeInfo[readers.length + 1];
            for (int i = 0; i < readers.length; ++i) {
                IndexReader reader = readers[i];
                TermEnum termEnum = t != null ? reader.terms(t) : reader.terms();
                SegmentMergeInfo smi = new SegmentMergeInfo(starts2[i], termEnum, reader);
                smi.ord = i;
                if (t == null ? smi.next() : termEnum.term() != null) {
                    this.queue.put(smi);
                    continue;
                }
                smi.close();
            }
            if (t != null && this.queue.size() > 0) {
                this.next();
            }
        }

        public boolean next() throws IOException {
            SegmentMergeInfo smi;
            for (int i = 0; i < this.matchingSegments.length && (smi = this.matchingSegments[i]) != null; ++i) {
                if (smi.next()) {
                    this.queue.put(smi);
                    continue;
                }
                smi.close();
            }
            int numMatchingSegments = 0;
            this.matchingSegments[0] = null;
            SegmentMergeInfo top = (SegmentMergeInfo)this.queue.top();
            if (top == null) {
                this.term = null;
                return false;
            }
            this.term = top.term;
            this.docFreq = 0;
            while (top != null && this.term.compareTo(top.term) == 0) {
                this.matchingSegments[numMatchingSegments++] = top;
                this.queue.pop();
                this.docFreq += top.termEnum.docFreq();
                top = (SegmentMergeInfo)this.queue.top();
            }
            this.matchingSegments[numMatchingSegments] = null;
            return true;
        }

        public Term term() {
            return this.term;
        }

        public int docFreq() {
            return this.docFreq;
        }

        public void close() throws IOException {
            this.queue.close();
        }
    }

    private static final class ReaderCommit
    extends IndexCommit {
        private String segmentsFileName;
        Collection files;
        Directory dir;
        long generation;
        long version;
        final boolean isOptimized;
        final Map userData;

        ReaderCommit(SegmentInfos infos, Directory dir2) throws IOException {
            this.segmentsFileName = infos.getCurrentSegmentFileName();
            this.dir = dir2;
            this.userData = infos.getUserData();
            this.files = Collections.unmodifiableCollection(infos.files(dir2, true));
            this.version = infos.getVersion();
            this.generation = infos.getGeneration();
            this.isOptimized = infos.size() == 1 && !infos.info(0).hasDeletions();
        }

        public boolean isOptimized() {
            return this.isOptimized;
        }

        public String getSegmentsFileName() {
            return this.segmentsFileName;
        }

        public Collection getFileNames() {
            return this.files;
        }

        public Directory getDirectory() {
            return this.dir;
        }

        public long getVersion() {
            return this.version;
        }

        public long getGeneration() {
            return this.generation;
        }

        public boolean isDeleted() {
            return false;
        }

        public Map getUserData() {
            return this.userData;
        }

        public void delete() {
            throw new UnsupportedOperationException("This IndexCommit does not support deletions");
        }
    }
}

