/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.Version;

public final class StopFilter
extends TokenFilter {
    private static boolean ENABLE_POSITION_INCREMENTS_DEFAULT = false;
    private final CharArraySet stopWords;
    private boolean enablePositionIncrements = ENABLE_POSITION_INCREMENTS_DEFAULT;
    private TermAttribute termAtt;
    private PositionIncrementAttribute posIncrAtt;

    public StopFilter(TokenStream input2, String[] stopWords) {
        this(ENABLE_POSITION_INCREMENTS_DEFAULT, input2, stopWords, false);
    }

    public StopFilter(boolean enablePositionIncrements, TokenStream input2, String[] stopWords) {
        this(enablePositionIncrements, input2, stopWords, false);
    }

    public StopFilter(TokenStream in, String[] stopWords, boolean ignoreCase) {
        this(ENABLE_POSITION_INCREMENTS_DEFAULT, in, stopWords, ignoreCase);
    }

    public StopFilter(boolean enablePositionIncrements, TokenStream in, String[] stopWords, boolean ignoreCase) {
        super(in);
        this.stopWords = (CharArraySet)StopFilter.makeStopSet(stopWords, ignoreCase);
        this.enablePositionIncrements = enablePositionIncrements;
        this.init();
    }

    public StopFilter(TokenStream input2, Set stopWords, boolean ignoreCase) {
        this(ENABLE_POSITION_INCREMENTS_DEFAULT, input2, stopWords, ignoreCase);
    }

    public StopFilter(boolean enablePositionIncrements, TokenStream input2, Set stopWords, boolean ignoreCase) {
        super(input2);
        if (stopWords instanceof CharArraySet) {
            this.stopWords = (CharArraySet)stopWords;
        } else {
            this.stopWords = new CharArraySet(stopWords.size(), ignoreCase);
            this.stopWords.addAll(stopWords);
        }
        this.enablePositionIncrements = enablePositionIncrements;
        this.init();
    }

    public StopFilter(TokenStream in, Set stopWords) {
        this(ENABLE_POSITION_INCREMENTS_DEFAULT, in, stopWords, false);
    }

    public StopFilter(boolean enablePositionIncrements, TokenStream in, Set stopWords) {
        this(enablePositionIncrements, in, stopWords, false);
    }

    public void init() {
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    }

    public static final Set makeStopSet(String[] stopWords) {
        return StopFilter.makeStopSet(stopWords, false);
    }

    public static final Set makeStopSet(List stopWords) {
        return StopFilter.makeStopSet(stopWords, false);
    }

    public static final Set makeStopSet(String[] stopWords, boolean ignoreCase) {
        CharArraySet stopSet = new CharArraySet(stopWords.length, ignoreCase);
        stopSet.addAll(Arrays.asList(stopWords));
        return stopSet;
    }

    public static final Set makeStopSet(List stopWords, boolean ignoreCase) {
        CharArraySet stopSet = new CharArraySet(stopWords.size(), ignoreCase);
        stopSet.addAll(stopWords);
        return stopSet;
    }

    public final boolean incrementToken() throws IOException {
        int skippedPositions = 0;
        while (this.input.incrementToken()) {
            if (!this.stopWords.contains(this.termAtt.termBuffer(), 0, this.termAtt.termLength())) {
                if (this.enablePositionIncrements) {
                    this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + skippedPositions);
                }
                return true;
            }
            skippedPositions += this.posIncrAtt.getPositionIncrement();
        }
        return false;
    }

    public static boolean getEnablePositionIncrementsDefault() {
        return ENABLE_POSITION_INCREMENTS_DEFAULT;
    }

    public static boolean getEnablePositionIncrementsVersionDefault(Version matchVersion) {
        if (matchVersion.onOrAfter(Version.LUCENE_29)) {
            return true;
        }
        return ENABLE_POSITION_INCREMENTS_DEFAULT;
    }

    public static void setEnablePositionIncrementsDefault(boolean defaultValue) {
        ENABLE_POSITION_INCREMENTS_DEFAULT = defaultValue;
    }

    public boolean getEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public void setEnablePositionIncrements(boolean enable) {
        this.enablePositionIncrements = enable;
    }
}

