/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.AttributeSource;

public abstract class CharTokenizer
extends Tokenizer {
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private static final int MAX_WORD_LEN = 255;
    private static final int IO_BUFFER_SIZE = 4096;
    private final char[] ioBuffer = new char[4096];
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);

    public CharTokenizer(Reader input2) {
        super(input2);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public CharTokenizer(AttributeSource source, Reader input2) {
        super(source, input2);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public CharTokenizer(AttributeSource.AttributeFactory factory, Reader input2) {
        super(factory, input2);
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    protected abstract boolean isTokenChar(char var1);

    protected char normalize(char c) {
        return c;
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        int length = 0;
        int start = this.bufferIndex;
        char[] buffer = this.termAtt.termBuffer();
        while (true) {
            char c;
            if (this.bufferIndex >= this.dataLen) {
                this.offset += this.dataLen;
                this.dataLen = this.input.read(this.ioBuffer);
                if (this.dataLen == -1) {
                    this.dataLen = 0;
                    if (length <= 0) {
                        return false;
                    }
                    break;
                }
                this.bufferIndex = 0;
            }
            if (this.isTokenChar(c = this.ioBuffer[this.bufferIndex++])) {
                if (length == 0) {
                    start = this.offset + this.bufferIndex - 1;
                } else if (length == buffer.length) {
                    buffer = this.termAtt.resizeTermBuffer(1 + length);
                }
                buffer[length++] = this.normalize(c);
                if (length != 255) continue;
                break;
            }
            if (length > 0) break;
        }
        this.termAtt.setTermLength(length);
        this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset(start + length));
        return true;
    }

    public final void end() {
        int finalOffset = this.correctOffset(this.offset);
        this.offsetAtt.setOffset(finalOffset, finalOffset);
    }

    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    public final Token next() throws IOException {
        return super.next();
    }

    public void reset(Reader input2) throws IOException {
        super.reset(input2);
        this.bufferIndex = 0;
        this.offset = 0;
        this.dataLen = 0;
    }
}

