/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;

public class CharArraySet
extends AbstractSet {
    private static final int INIT_SIZE = 8;
    private char[][] entries;
    private int count;
    private final boolean ignoreCase;

    public CharArraySet(int startSize, boolean ignoreCase) {
        int size2;
        this.ignoreCase = ignoreCase;
        for (size2 = 8; startSize + (startSize >> 2) > size2; size2 <<= 1) {
        }
        this.entries = new char[size2][];
    }

    public CharArraySet(Collection c, boolean ignoreCase) {
        this(c.size(), ignoreCase);
        this.addAll(c);
    }

    private CharArraySet(char[][] entries, boolean ignoreCase, int count2) {
        this.entries = entries;
        this.ignoreCase = ignoreCase;
        this.count = count2;
    }

    public boolean contains(char[] text2, int off, int len) {
        return this.entries[this.getSlot(text2, off, len)] != null;
    }

    public boolean contains(CharSequence cs) {
        return this.entries[this.getSlot(cs)] != null;
    }

    private int getSlot(char[] text2, int off, int len) {
        int code = this.getHashCode(text2, off, len);
        int pos = code & this.entries.length - 1;
        char[] text22 = this.entries[pos];
        if (text22 != null && !this.equals(text2, off, len, text22)) {
            int inc = (code >> 8) + code | 1;
            while ((text22 = this.entries[pos = (code += inc) & this.entries.length - 1]) != null && !this.equals(text2, off, len, text22)) {
            }
        }
        return pos;
    }

    private int getSlot(CharSequence text2) {
        int code = this.getHashCode(text2);
        int pos = code & this.entries.length - 1;
        char[] text22 = this.entries[pos];
        if (text22 != null && !this.equals(text2, text22)) {
            int inc = (code >> 8) + code | 1;
            while ((text22 = this.entries[pos = (code += inc) & this.entries.length - 1]) != null && !this.equals(text2, text22)) {
            }
        }
        return pos;
    }

    public boolean add(CharSequence text2) {
        return this.add(((Object)text2).toString());
    }

    public boolean add(String text2) {
        return this.add(text2.toCharArray());
    }

    public boolean add(char[] text2) {
        int slot;
        if (this.ignoreCase) {
            for (int i = 0; i < text2.length; ++i) {
                text2[i] = Character.toLowerCase(text2[i]);
            }
        }
        if (this.entries[slot = this.getSlot(text2, 0, text2.length)] != null) {
            return false;
        }
        this.entries[slot] = text2;
        ++this.count;
        if (this.count + (this.count >> 2) > this.entries.length) {
            this.rehash();
        }
        return true;
    }

    private boolean equals(char[] text1, int off, int len, char[] text2) {
        if (len != text2.length) {
            return false;
        }
        if (this.ignoreCase) {
            for (int i = 0; i < len; ++i) {
                if (Character.toLowerCase(text1[off + i]) == text2[i]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (text1[off + i] == text2[i]) continue;
                return false;
            }
        }
        return true;
    }

    private boolean equals(CharSequence text1, char[] text2) {
        int len = text1.length();
        if (len != text2.length) {
            return false;
        }
        if (this.ignoreCase) {
            for (int i = 0; i < len; ++i) {
                if (Character.toLowerCase(text1.charAt(i)) == text2[i]) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (text1.charAt(i) == text2[i]) continue;
                return false;
            }
        }
        return true;
    }

    private void rehash() {
        int newSize = 2 * this.entries.length;
        char[][] oldEntries = this.entries;
        this.entries = new char[newSize][];
        for (int i = 0; i < oldEntries.length; ++i) {
            char[] text2 = oldEntries[i];
            if (text2 == null) continue;
            this.entries[this.getSlot((char[])text2, (int)0, (int)text2.length)] = text2;
        }
    }

    private int getHashCode(char[] text2, int offset, int len) {
        int code = 0;
        int stop = offset + len;
        if (this.ignoreCase) {
            for (int i = offset; i < stop; ++i) {
                code = code * 31 + Character.toLowerCase(text2[i]);
            }
        } else {
            for (int i = offset; i < stop; ++i) {
                code = code * 31 + text2[i];
            }
        }
        return code;
    }

    private int getHashCode(CharSequence text2) {
        int code = 0;
        int len = text2.length();
        if (this.ignoreCase) {
            for (int i = 0; i < len; ++i) {
                code = code * 31 + Character.toLowerCase(text2.charAt(i));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                code = code * 31 + text2.charAt(i);
            }
        }
        return code;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object o) {
        if (o instanceof char[]) {
            char[] text2 = (char[])o;
            return this.contains(text2, 0, text2.length);
        }
        return this.contains(o.toString());
    }

    public boolean add(Object o) {
        if (o instanceof char[]) {
            return this.add((char[])o);
        }
        return this.add(o.toString());
    }

    public static CharArraySet unmodifiableSet(CharArraySet set) {
        if (set == null) {
            throw new NullPointerException("Given set is null");
        }
        return new UnmodifiableCharArraySet(set.entries, set.ignoreCase, set.count);
    }

    public Iterator iterator() {
        return new CharArraySetIterator();
    }

    private static final class UnmodifiableCharArraySet
    extends CharArraySet {
        private UnmodifiableCharArraySet(char[][] entries, boolean ignoreCase, int count2) {
            super(entries, ignoreCase, count2);
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        public boolean add(char[] text2) {
            throw new UnsupportedOperationException();
        }

        public boolean add(CharSequence text2) {
            throw new UnsupportedOperationException();
        }

        public boolean add(String text2) {
            throw new UnsupportedOperationException();
        }
    }

    public class CharArraySetIterator
    implements Iterator {
        int pos = -1;
        char[] next;

        CharArraySetIterator() {
            this.goNext();
        }

        private void goNext() {
            this.next = null;
            ++this.pos;
            while (this.pos < CharArraySet.this.entries.length && (this.next = CharArraySet.this.entries[this.pos]) == null) {
                ++this.pos;
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public char[] nextCharArray() {
            char[] ret = this.next;
            this.goNext();
            return ret;
        }

        public Object next() {
            return new String(this.nextCharArray());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

