/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

public final class NumberRange {
    private final Number min;
    private final Number max;

    public NumberRange(Number num2) {
        if (num2 == null) {
            throw new NullPointerException("The number must not be null");
        }
        this.min = num2;
        this.max = num2;
    }

    public NumberRange(Number min2, Number max2) {
        if (min2 == null) {
            throw new NullPointerException("The minimum value must not be null");
        }
        if (max2 == null) {
            throw new NullPointerException("The maximum value must not be null");
        }
        if (max2.doubleValue() < min2.doubleValue()) {
            this.min = this.max = min2;
        } else {
            this.min = min2;
            this.max = max2;
        }
    }

    public Number getMinimum() {
        return this.min;
    }

    public Number getMaximum() {
        return this.max;
    }

    public boolean includesNumber(Number number2) {
        if (number2 == null) {
            return false;
        }
        return !(this.min.doubleValue() > number2.doubleValue()) && !(this.max.doubleValue() < number2.doubleValue());
    }

    public boolean includesRange(NumberRange range2) {
        if (range2 == null) {
            return false;
        }
        return this.includesNumber(range2.min) && this.includesNumber(range2.max);
    }

    public boolean overlaps(NumberRange range2) {
        if (range2 == null) {
            return false;
        }
        return range2.includesNumber(this.min) || range2.includesNumber(this.max) || this.includesRange(range2);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NumberRange)) {
            return false;
        }
        NumberRange range2 = (NumberRange)obj;
        return this.min.equals(range2.min) && this.max.equals(range2.max);
    }

    public int hashCode() {
        int result2 = 17;
        result2 = 37 * result2 + this.min.hashCode();
        result2 = 37 * result2 + this.max.hashCode();
        return result2;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.min.doubleValue() < 0.0) {
            sb.append('(').append(this.min).append(')');
        } else {
            sb.append(this.min);
        }
        sb.append('-');
        if (this.max.doubleValue() < 0.0) {
            sb.append('(').append(this.max).append(')');
        } else {
            sb.append(this.max);
        }
        return sb.toString();
    }
}

