/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.TailerListener;

public class Tailer
implements Runnable {
    private final File file;
    private final long delay;
    private final boolean end;
    private final TailerListener listener;
    private volatile boolean run = true;

    public Tailer(File file, TailerListener listener) {
        this(file, listener, 1000L);
    }

    public Tailer(File file, TailerListener listener, long delay2) {
        this(file, listener, 1000L, false);
    }

    public Tailer(File file, TailerListener listener, long delay2, boolean end) {
        this.file = file;
        this.delay = delay2;
        this.end = end;
        this.listener = listener;
        listener.init(this);
    }

    public static Tailer create(File file, TailerListener listener, long delay2, boolean end) {
        Tailer tailer = new Tailer(file, listener, delay2, end);
        Thread thread = new Thread(tailer);
        thread.setDaemon(true);
        thread.start();
        return tailer;
    }

    public static Tailer create(File file, TailerListener listener, long delay2) {
        return Tailer.create(file, listener, delay2, false);
    }

    public static Tailer create(File file, TailerListener listener) {
        return Tailer.create(file, listener, 1000L, false);
    }

    public File getFile() {
        return this.file;
    }

    public long getDelay() {
        return this.delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RandomAccessFile reader = null;
        try {
            long last2 = 0L;
            long position = 0L;
            while (this.run && reader == null) {
                try {
                    reader = new RandomAccessFile(this.file, "r");
                }
                catch (FileNotFoundException e) {
                    this.listener.fileNotFound();
                }
                if (reader == null) {
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                position = this.end ? this.file.length() : 0L;
                last2 = System.currentTimeMillis();
                reader.seek(position);
            }
            while (this.run) {
                long length = this.file.length();
                if (length < position) {
                    this.listener.fileRotated();
                    try {
                        RandomAccessFile save2 = reader;
                        reader = new RandomAccessFile(this.file, "r");
                        position = 0L;
                        IOUtils.closeQuietly(save2);
                    }
                    catch (FileNotFoundException e) {
                        this.listener.fileNotFound();
                    }
                    continue;
                }
                if (length > position) {
                    last2 = System.currentTimeMillis();
                    position = this.readLines(reader);
                } else if (FileUtils.isFileNewer(this.file, last2)) {
                    position = 0L;
                    reader.seek(position);
                    last2 = System.currentTimeMillis();
                    position = this.readLines(reader);
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (Exception e) {
            this.listener.handle(e);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    public void stop() {
        this.run = false;
    }

    private long readLines(RandomAccessFile reader) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            this.listener.handle(line);
            line = reader.readLine();
        }
        return reader.getFilePointer();
    }
}

