/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration.beanutils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;

public class XMLBeanDeclaration
implements BeanDeclaration {
    public static final String RESERVED_PREFIX = "config-";
    public static final String ATTR_PREFIX = "[@config-";
    public static final String ATTR_BEAN_CLASS = "[@config-class]";
    public static final String ATTR_BEAN_FACTORY = "[@config-factory]";
    public static final String ATTR_FACTORY_PARAM = "[@config-factoryParam]";
    private SubnodeConfiguration configuration;
    private ConfigurationNode node;

    public XMLBeanDeclaration(HierarchicalConfiguration config, String key) {
        this(config, key, false);
    }

    public XMLBeanDeclaration(HierarchicalConfiguration config, String key, boolean optional) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration must not be null!");
        }
        try {
            this.configuration = config.configurationAt(key);
            this.node = this.configuration.getRootNode();
        }
        catch (IllegalArgumentException iex) {
            if (!optional || config.getMaxIndex(key) > 0) {
                throw iex;
            }
            this.configuration = config.configurationAt(null);
            this.node = new DefaultConfigurationNode();
        }
        this.initSubnodeConfiguration(this.getConfiguration());
    }

    public XMLBeanDeclaration(HierarchicalConfiguration config) {
        this(config, (String)null);
    }

    public XMLBeanDeclaration(SubnodeConfiguration config, ConfigurationNode node) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration must not be null!");
        }
        if (node == null) {
            throw new IllegalArgumentException("Node must not be null!");
        }
        this.node = node;
        this.configuration = config;
        this.initSubnodeConfiguration(config);
    }

    public SubnodeConfiguration getConfiguration() {
        return this.configuration;
    }

    public ConfigurationNode getNode() {
        return this.node;
    }

    public String getBeanFactoryName() {
        return this.getConfiguration().getString(ATTR_BEAN_FACTORY);
    }

    public Object getBeanFactoryParameter() {
        return this.getConfiguration().getProperty(ATTR_FACTORY_PARAM);
    }

    public String getBeanClassName() {
        return this.getConfiguration().getString(ATTR_BEAN_CLASS);
    }

    public Map getBeanProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Iterator it = this.getNode().getAttributes().iterator();
        while (it.hasNext()) {
            ConfigurationNode attr2 = (ConfigurationNode)it.next();
            if (this.isReservedNode(attr2)) continue;
            props.put(attr2.getName(), this.interpolate(attr2.getValue()));
        }
        return props;
    }

    public Map getNestedBeanDeclarations() {
        HashMap<String, BeanDeclaration> nested = new HashMap<String, BeanDeclaration>();
        Iterator it = this.getNode().getChildren().iterator();
        while (it.hasNext()) {
            ConfigurationNode child = (ConfigurationNode)it.next();
            if (this.isReservedNode(child)) continue;
            nested.put(child.getName(), this.createBeanDeclaration(child));
        }
        return nested;
    }

    protected Object interpolate(Object value2) {
        return PropertyConverter.interpolate(value2, this.getConfiguration().getParent());
    }

    protected boolean isReservedNode(ConfigurationNode nd) {
        return nd.isAttribute() && (nd.getName() == null || nd.getName().startsWith(RESERVED_PREFIX));
    }

    protected BeanDeclaration createBeanDeclaration(ConfigurationNode node) {
        return new XMLBeanDeclaration(this.getConfiguration().configurationAt(node.getName()), node);
    }

    private void initSubnodeConfiguration(SubnodeConfiguration conf) {
        conf.setThrowExceptionOnMissing(false);
        conf.setExpressionEngine(null);
    }
}

