/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.AbstractHierarchicalFileConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.PropertyConverter;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.DefaultConfigurationNode;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLConfiguration
extends AbstractHierarchicalFileConfiguration
implements EntityResolver {
    private static final long serialVersionUID = 2453781111653383552L;
    private static final String DEFAULT_ROOT_NAME = "configuration";
    private static final String ATTR_SPACE = "xml:space";
    private static final String VALUE_PRESERVE = "preserve";
    private static final char ATTR_VALUE_DELIMITER = '|';
    private Document document;
    private Map registeredEntities = new HashMap();
    private String rootElementName;
    private String publicID;
    private String systemID;
    private DocumentBuilder documentBuilder;
    private boolean validating;
    private boolean attributeSplittingDisabled;

    public XMLConfiguration() {
    }

    public XMLConfiguration(HierarchicalConfiguration c) {
        super(c);
        XMLConfiguration.clearReferences(this.getRootNode());
        this.setRootElementName(this.getRootNode().getName());
    }

    public XMLConfiguration(String fileName) throws ConfigurationException {
        super(fileName);
    }

    public XMLConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public XMLConfiguration(URL url) throws ConfigurationException {
        super(url);
    }

    public String getRootElementName() {
        if (this.getDocument() == null) {
            return this.rootElementName == null ? DEFAULT_ROOT_NAME : this.rootElementName;
        }
        return this.getDocument().getDocumentElement().getNodeName();
    }

    public void setRootElementName(String name) {
        if (this.getDocument() != null) {
            throw new UnsupportedOperationException("The name of the root element cannot be changed when loaded from an XML document!");
        }
        this.rootElementName = name;
        this.getRootNode().setName(name);
    }

    public DocumentBuilder getDocumentBuilder() {
        return this.documentBuilder;
    }

    public void setDocumentBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public void setPublicID(String publicID) {
        this.publicID = publicID;
    }

    public String getSystemID() {
        return this.systemID;
    }

    public void setSystemID(String systemID) {
        this.systemID = systemID;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isAttributeSplittingDisabled() {
        return this.attributeSplittingDisabled;
    }

    public void setAttributeSplittingDisabled(boolean attributeSplittingDisabled) {
        this.attributeSplittingDisabled = attributeSplittingDisabled;
    }

    public Document getDocument() {
        return this.document;
    }

    public void clear() {
        super.clear();
        this.document = null;
    }

    public void initProperties(Document document2, boolean elemRefs) {
        if (document2.getDoctype() != null) {
            this.setPublicID(document2.getDoctype().getPublicId());
            this.setSystemID(document2.getDoctype().getSystemId());
        }
        this.constructHierarchy(this.getRoot(), document2.getDocumentElement(), elemRefs, true);
        this.getRootNode().setName(document2.getDocumentElement().getNodeName());
        if (elemRefs) {
            this.getRoot().setReference(document2.getDocumentElement());
        }
    }

    private void constructHierarchy(HierarchicalConfiguration.Node node, Element element, boolean elemRefs, boolean trim2) {
        boolean trimFlag = this.shouldTrim(element, trim2);
        this.processAttributes(node, element, elemRefs);
        StringBuffer buffer = new StringBuffer();
        NodeList list2 = element.getChildNodes();
        for (int i = 0; i < list2.getLength(); ++i) {
            Node w3cNode = list2.item(i);
            if (w3cNode instanceof Element) {
                Element child = (Element)w3cNode;
                XMLNode childNode = new XMLNode(child.getTagName(), elemRefs ? child : null);
                this.constructHierarchy(childNode, child, elemRefs, trimFlag);
                node.addChild(childNode);
                this.handleDelimiters(node, childNode, trimFlag);
                continue;
            }
            if (!(w3cNode instanceof Text)) continue;
            Text data2 = (Text)w3cNode;
            buffer.append(data2.getData());
        }
        String text2 = buffer.toString();
        if (trimFlag) {
            text2 = text2.trim();
        }
        if (text2.length() > 0 || !node.hasChildren()) {
            node.setValue(text2);
        }
    }

    private void processAttributes(HierarchicalConfiguration.Node node, Element element, boolean elemRefs) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node w3cNode = attributes.item(i);
            if (!(w3cNode instanceof Attr)) continue;
            Attr attr2 = (Attr)w3cNode;
            List values2 = this.isAttributeSplittingDisabled() ? Collections.singletonList(attr2.getValue()) : PropertyConverter.split(attr2.getValue(), this.isDelimiterParsingDisabled() ? (char)'|' : (char)this.getListDelimiter());
            Iterator<String> it = values2.iterator();
            while (it.hasNext()) {
                XMLNode child = new XMLNode(attr2.getName(), elemRefs ? element : null);
                ((DefaultConfigurationNode)child).setValue(it.next());
                node.addAttribute(child);
            }
        }
    }

    private void handleDelimiters(HierarchicalConfiguration.Node parent, HierarchicalConfiguration.Node child, boolean trim2) {
        if (child.getValue() != null) {
            List values2;
            if (this.isDelimiterParsingDisabled()) {
                values2 = new ArrayList<String>();
                values2.add(child.getValue().toString());
            } else {
                values2 = PropertyConverter.split(child.getValue().toString(), this.getListDelimiter(), trim2);
            }
            if (values2.size() > 1) {
                Iterator it = values2.iterator();
                HierarchicalConfiguration.Node c = this.createNode(child.getName());
                c.setValue(it.next());
                Iterator itAttrs = child.getAttributes().iterator();
                while (itAttrs.hasNext()) {
                    HierarchicalConfiguration.Node ndAttr = (HierarchicalConfiguration.Node)itAttrs.next();
                    ndAttr.setReference(null);
                    c.addAttribute(ndAttr);
                }
                parent.remove(child);
                parent.addChild(c);
                while (it.hasNext()) {
                    c = new XMLNode(child.getName(), null);
                    c.setValue(it.next());
                    parent.addChild(c);
                }
            } else if (values2.size() == 1) {
                child.setValue(values2.get(0));
            }
        }
    }

    private boolean shouldTrim(Element element, boolean currentTrim) {
        Attr attr2 = element.getAttributeNode(ATTR_SPACE);
        if (attr2 == null) {
            return currentTrim;
        }
        return !VALUE_PRESERVE.equals(attr2.getValue());
    }

    protected DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        if (this.getDocumentBuilder() != null) {
            return this.getDocumentBuilder();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(this.isValidating());
        DocumentBuilder result2 = factory.newDocumentBuilder();
        result2.setEntityResolver(this);
        if (this.isValidating()) {
            result2.setErrorHandler(new DefaultHandler(){

                public void error(SAXParseException ex) throws SAXException {
                    throw ex;
                }
            });
        }
        return result2;
    }

    protected Document createDocument() throws ConfigurationException {
        try {
            Object builder;
            if (this.document == null) {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document newDocument = ((DocumentBuilder)builder).newDocument();
                Element rootElem = newDocument.createElement(this.getRootElementName());
                newDocument.appendChild(rootElem);
                this.document = newDocument;
            }
            builder = new XMLBuilderVisitor(this.document, this.isDelimiterParsingDisabled() ? (char)'\u0000' : this.getListDelimiter());
            ((XMLBuilderVisitor)builder).processDocument(this.getRoot());
            this.initRootElementText(this.document, this.getRootNode().getValue());
            return this.document;
        }
        catch (DOMException domEx) {
            throw new ConfigurationException(domEx);
        }
        catch (ParserConfigurationException pex) {
            throw new ConfigurationException(pex);
        }
    }

    private void initRootElementText(Document doc, Object value2) {
        Element elem2 = doc.getDocumentElement();
        NodeList children2 = elem2.getChildNodes();
        for (int i = 0; i < children2.getLength(); ++i) {
            Node nd = children2.item(i);
            if (nd.getNodeType() != 3) continue;
            elem2.removeChild(nd);
        }
        if (value2 != null) {
            elem2.appendChild(doc.createTextNode(String.valueOf(value2)));
        }
    }

    protected HierarchicalConfiguration.Node createNode(String name) {
        return new XMLNode(name, null);
    }

    public void load(InputStream in) throws ConfigurationException {
        this.load(new InputSource(in));
    }

    public void load(Reader in) throws ConfigurationException {
        this.load(new InputSource(in));
    }

    private void load(InputSource source) throws ConfigurationException {
        try {
            URL sourceURL = this.getDelegate().getURL();
            if (sourceURL != null) {
                source.setSystemId(sourceURL.toString());
            }
            DocumentBuilder builder = this.createDocumentBuilder();
            Document newDocument = builder.parse(source);
            Document oldDocument = this.document;
            this.document = null;
            this.initProperties(newDocument, oldDocument == null);
            this.document = oldDocument == null ? newDocument : oldDocument;
        }
        catch (Exception e) {
            throw new ConfigurationException("Unable to load the configuration", e);
        }
    }

    public void save(Writer writer) throws ConfigurationException {
        try {
            Transformer transformer = this.createTransformer();
            DOMSource source = new DOMSource(this.createDocument());
            StreamResult result2 = new StreamResult(writer);
            transformer.transform(source, result2);
        }
        catch (TransformerException e) {
            throw new ConfigurationException("Unable to save the configuration", e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ConfigurationException("Unable to save the configuration", e);
        }
    }

    protected Transformer createTransformer() throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        if (this.getEncoding() != null) {
            transformer.setOutputProperty("encoding", this.getEncoding());
        }
        if (this.getPublicID() != null) {
            transformer.setOutputProperty("doctype-public", this.getPublicID());
        }
        if (this.getSystemID() != null) {
            transformer.setOutputProperty("doctype-system", this.getSystemID());
        }
        return transformer;
    }

    public Object clone() {
        XMLConfiguration copy = (XMLConfiguration)super.clone();
        copy.document = null;
        copy.setDelegate(copy.createDelegate());
        XMLConfiguration.clearReferences(copy.getRootNode());
        return copy;
    }

    protected AbstractHierarchicalFileConfiguration.FileConfigurationDelegate createDelegate() {
        return new XMLFileConfigurationDelegate();
    }

    public void addNodes(String key, Collection nodes) {
        ArrayList<XMLNode> xmlNodes;
        if (nodes != null && !nodes.isEmpty()) {
            xmlNodes = new ArrayList<XMLNode>(nodes.size());
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                xmlNodes.add(this.convertToXMLNode((ConfigurationNode)it.next()));
            }
        } else {
            xmlNodes = nodes;
        }
        super.addNodes(key, xmlNodes);
    }

    private XMLNode convertToXMLNode(ConfigurationNode node) {
        if (node instanceof XMLNode) {
            return (XMLNode)node;
        }
        XMLNode nd = (XMLNode)this.createNode(node.getName());
        nd.setValue(node.getValue());
        nd.setAttribute(node.isAttribute());
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            nd.addChild(this.convertToXMLNode((ConfigurationNode)it.next()));
        }
        it = node.getAttributes().iterator();
        while (it.hasNext()) {
            nd.addAttribute(this.convertToXMLNode((ConfigurationNode)it.next()));
        }
        return nd;
    }

    public void registerEntityId(String publicId, URL entityURL) {
        if (publicId == null) {
            throw new IllegalArgumentException("Public ID must not be null!");
        }
        this.getRegisteredEntities().put(publicId, entityURL);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        URL entityURL = null;
        if (publicId != null) {
            entityURL = (URL)this.getRegisteredEntities().get(publicId);
        }
        if (entityURL != null) {
            try {
                URLConnection connection = entityURL.openConnection();
                connection.setUseCaches(false);
                InputStream stream = connection.getInputStream();
                InputSource source = new InputSource(stream);
                source.setSystemId(entityURL.toExternalForm());
                return source;
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        return null;
    }

    Map getRegisteredEntities() {
        return this.registeredEntities;
    }

    private class XMLFileConfigurationDelegate
    extends AbstractHierarchicalFileConfiguration.FileConfigurationDelegate {
        private XMLFileConfigurationDelegate() {
        }

        public void load(InputStream in) throws ConfigurationException {
            XMLConfiguration.this.load(in);
        }
    }

    static class XMLBuilderVisitor
    extends HierarchicalConfiguration.BuilderVisitor {
        private Document document;
        private char listDelimiter = AbstractConfiguration.getDefaultListDelimiter();

        public XMLBuilderVisitor(Document doc, char listDelimiter) {
            this.document = doc;
            this.listDelimiter = listDelimiter;
        }

        public void processDocument(HierarchicalConfiguration.Node rootNode) {
            rootNode.visit(this, null);
        }

        protected Object insert(HierarchicalConfiguration.Node newNode, HierarchicalConfiguration.Node parent, HierarchicalConfiguration.Node sibling1, HierarchicalConfiguration.Node sibling2) {
            if (newNode.isAttribute()) {
                XMLBuilderVisitor.updateAttribute(parent, this.getElement(parent), newNode.getName(), this.listDelimiter);
                return null;
            }
            Element elem2 = this.document.createElement(newNode.getName());
            if (newNode.getValue() != null) {
                String txt = newNode.getValue().toString();
                if (this.listDelimiter != '\u0000') {
                    txt = PropertyConverter.escapeDelimiters(txt, this.listDelimiter);
                }
                elem2.appendChild(this.document.createTextNode(txt));
            }
            if (sibling2 == null) {
                this.getElement(parent).appendChild(elem2);
            } else if (sibling1 != null) {
                this.getElement(parent).insertBefore(elem2, this.getElement(sibling1).getNextSibling());
            } else {
                this.getElement(parent).insertBefore(elem2, this.getElement(parent).getFirstChild());
            }
            return elem2;
        }

        private static void updateAttribute(HierarchicalConfiguration.Node node, Element elem2, String name, char listDelimiter) {
            if (node != null && elem2 != null) {
                List attrs = node.getAttributes(name);
                StringBuffer buf = new StringBuffer();
                char delimiter = listDelimiter != '\u0000' ? listDelimiter : (char)'|';
                Iterator it = attrs.iterator();
                while (it.hasNext()) {
                    HierarchicalConfiguration.Node attr2 = (HierarchicalConfiguration.Node)it.next();
                    if (attr2.getValue() != null) {
                        if (buf.length() > 0) {
                            buf.append(delimiter);
                        }
                        buf.append(PropertyConverter.escapeDelimiters(attr2.getValue().toString(), delimiter));
                    }
                    attr2.setReference(elem2);
                }
                if (buf.length() < 1) {
                    elem2.removeAttribute(name);
                } else {
                    elem2.setAttribute(name, buf.toString());
                }
            }
        }

        static void updateAttribute(HierarchicalConfiguration.Node node, String name, char listDelimiter) {
            if (node != null) {
                XMLBuilderVisitor.updateAttribute(node, (Element)node.getReference(), name, listDelimiter);
            }
        }

        private Element getElement(HierarchicalConfiguration.Node node) {
            return node.getName() != null && node.getReference() != null ? (Element)node.getReference() : this.document.getDocumentElement();
        }
    }

    class XMLNode
    extends HierarchicalConfiguration.Node {
        private static final long serialVersionUID = -4133988932174596562L;

        public XMLNode(String name, Element elem2) {
            super(name);
            this.setReference(elem2);
        }

        public void setValue(Object value2) {
            super.setValue(value2);
            if (this.getReference() != null && XMLConfiguration.this.document != null) {
                if (this.isAttribute()) {
                    this.updateAttribute();
                } else {
                    this.updateElement(value2);
                }
            }
        }

        protected void removeReference() {
            if (this.getReference() != null) {
                Element element = (Element)this.getReference();
                if (this.isAttribute()) {
                    this.updateAttribute();
                } else {
                    Node parentElem = element.getParentNode();
                    if (parentElem != null) {
                        parentElem.removeChild(element);
                    }
                }
            }
        }

        private void updateElement(Object value2) {
            Text txtNode = this.findTextNodeForUpdate();
            if (value2 == null) {
                if (txtNode != null) {
                    ((Element)this.getReference()).removeChild(txtNode);
                }
            } else if (txtNode == null) {
                txtNode = XMLConfiguration.this.document.createTextNode(PropertyConverter.escapeDelimiters(value2.toString(), XMLConfiguration.this.getListDelimiter()));
                if (((Element)this.getReference()).getFirstChild() != null) {
                    ((Element)this.getReference()).insertBefore(txtNode, ((Element)this.getReference()).getFirstChild());
                } else {
                    ((Element)this.getReference()).appendChild(txtNode);
                }
            } else {
                txtNode.setNodeValue(PropertyConverter.escapeDelimiters(value2.toString(), XMLConfiguration.this.getListDelimiter()));
            }
        }

        private void updateAttribute() {
            XMLBuilderVisitor.updateAttribute(this.getParent(), this.getName(), XMLConfiguration.this.getListDelimiter());
        }

        private Text findTextNodeForUpdate() {
            Text result2 = null;
            Element elem2 = (Element)this.getReference();
            NodeList children2 = elem2.getChildNodes();
            ArrayList<Node> textNodes = new ArrayList<Node>();
            for (int i = 0; i < children2.getLength(); ++i) {
                Node nd = children2.item(i);
                if (!(nd instanceof Text)) continue;
                if (result2 == null) {
                    result2 = (Text)nd;
                    continue;
                }
                textNodes.add(nd);
            }
            if (result2 instanceof CDATASection) {
                textNodes.add(result2);
                result2 = null;
            }
            Iterator it = textNodes.iterator();
            while (it.hasNext()) {
                elem2.removeChild((Node)it.next());
            }
            return result2;
        }
    }
}

