/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.lang.reflect.Array;
import java.util.Collection;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractConverter
implements Converter {
    private static final String DEFAULT_CONFIG_MSG = "(N.B. Converters can be configured to use default values to avoid throwing exceptions)";
    private static final String PACKAGE = "org.apache.commons.beanutils.converters.";
    private transient Log log;
    private boolean useDefault = false;
    private Object defaultValue = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;

    public AbstractConverter() {
    }

    public AbstractConverter(Object defaultValue) {
        this.setDefaultValue(defaultValue);
    }

    public boolean isUseDefault() {
        return this.useDefault;
    }

    public Object convert(Class type, Object value2) {
        Class<?> sourceType = value2 == null ? null : value2.getClass();
        Class targetType = this.primitive(type == null ? this.getDefaultType() : type);
        if (this.log().isDebugEnabled()) {
            this.log().debug("Converting" + (value2 == null ? "" : " '" + this.toString(sourceType) + "'") + " value '" + value2 + "' to type '" + this.toString(targetType) + "'");
        }
        if ((value2 = this.convertArray(value2)) == null) {
            return this.handleMissing(targetType);
        }
        sourceType = value2.getClass();
        try {
            if (targetType.equals(class$java$lang$String == null ? (class$java$lang$String = AbstractConverter.class$("java.lang.String")) : class$java$lang$String)) {
                return this.convertToString(value2);
            }
            if (targetType.equals(sourceType)) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug("    No conversion required, value is already a " + this.toString(targetType));
                }
                return value2;
            }
            Object result2 = this.convertToType(targetType, value2);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Converted to " + this.toString(targetType) + " value '" + result2 + "'");
            }
            return result2;
        }
        catch (Throwable t) {
            return this.handleError(targetType, value2, t);
        }
    }

    protected String convertToString(Object value2) throws Throwable {
        return value2.toString();
    }

    protected abstract Object convertToType(Class var1, Object var2) throws Throwable;

    protected Object convertArray(Object value2) {
        if (value2 == null) {
            return null;
        }
        if (value2.getClass().isArray()) {
            if (Array.getLength(value2) > 0) {
                return Array.get(value2, 0);
            }
            return null;
        }
        if (value2 instanceof Collection) {
            Collection collection = (Collection)value2;
            if (collection.size() > 0) {
                return collection.iterator().next();
            }
            return null;
        }
        return value2;
    }

    protected Object handleError(Class type, Object value2, Throwable cause) {
        if (this.log().isDebugEnabled()) {
            if (cause instanceof ConversionException) {
                this.log().debug("    Conversion threw ConversionException: " + cause.getMessage());
            } else {
                this.log().debug("    Conversion threw " + cause);
            }
        }
        if (this.useDefault) {
            return this.handleMissing(type);
        }
        ConversionException cex = null;
        if (cause instanceof ConversionException) {
            cex = (ConversionException)cause;
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Re-throwing ConversionException: " + cex.getMessage());
                this.log().debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
            }
        } else {
            String msg = "Error converting from '" + this.toString(value2.getClass()) + "' to '" + this.toString(type) + "' " + cause.getMessage();
            cex = new ConversionException(msg, cause);
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Throwing ConversionException: " + msg);
                this.log().debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
            }
            BeanUtils.initCause(cex, cause);
        }
        throw cex;
    }

    protected Object handleMissing(Class type) {
        if (this.useDefault || type.equals(class$java$lang$String == null ? (class$java$lang$String = AbstractConverter.class$("java.lang.String")) : class$java$lang$String)) {
            Object value2 = this.getDefault(type);
            if (this.useDefault && value2 != null && !type.equals(value2.getClass())) {
                try {
                    value2 = this.convertToType(type, this.defaultValue);
                }
                catch (Throwable t) {
                    this.log().error("    Default conversion to " + this.toString(type) + "failed: " + t);
                }
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug("    Using default " + (value2 == null ? "" : this.toString(value2.getClass()) + " ") + "value '" + this.defaultValue + "'");
            }
            return value2;
        }
        ConversionException cex = new ConversionException("No value specified for '" + this.toString(type) + "'");
        if (this.log().isDebugEnabled()) {
            this.log().debug("    Throwing ConversionException: " + cex.getMessage());
            this.log().debug("    (N.B. Converters can be configured to use default values to avoid throwing exceptions)");
        }
        throw cex;
    }

    protected void setDefaultValue(Object defaultValue) {
        this.useDefault = false;
        if (this.log().isDebugEnabled()) {
            this.log().debug("Setting default value: " + defaultValue);
        }
        this.defaultValue = defaultValue == null ? null : this.convert(this.getDefaultType(), defaultValue);
        this.useDefault = true;
    }

    protected abstract Class getDefaultType();

    protected Object getDefault(Class type) {
        if (type.equals(class$java$lang$String == null ? (class$java$lang$String = AbstractConverter.class$("java.lang.String")) : class$java$lang$String)) {
            return null;
        }
        return this.defaultValue;
    }

    public String toString() {
        return this.toString(this.getClass()) + "[UseDefault=" + this.useDefault + "]";
    }

    Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog(this.getClass());
        }
        return this.log;
    }

    Class primitive(Class type) {
        if (type == null || !type.isPrimitive()) {
            return type;
        }
        if (type == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = AbstractConverter.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (type == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = AbstractConverter.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (type == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = AbstractConverter.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (type == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = AbstractConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (type == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = AbstractConverter.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (type == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = AbstractConverter.class$("java.lang.Short")) : class$java$lang$Short;
        }
        if (type == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = AbstractConverter.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (type == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = AbstractConverter.class$("java.lang.Character")) : class$java$lang$Character;
        }
        return type;
    }

    String toString(Class type) {
        String typeName = null;
        if (type == null) {
            typeName = "null";
        } else if (type.isArray()) {
            Class<?> elementType = type.getComponentType();
            int count2 = 1;
            while (elementType.isArray()) {
                elementType = elementType.getComponentType();
                ++count2;
            }
            typeName = elementType.getName();
            for (int i = 0; i < count2; ++i) {
                typeName = typeName + "[]";
            }
        } else {
            typeName = type.getName();
        }
        if (typeName.startsWith("java.lang.") || typeName.startsWith("java.util.") || typeName.startsWith("java.math.")) {
            typeName = typeName.substring("java.lang.".length());
        } else if (typeName.startsWith(PACKAGE)) {
            typeName = typeName.substring(PACKAGE.length());
        }
        return typeName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

