/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.wsdl.toJava;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.wsdl.toJava.Utils;

public class Namespaces
extends HashMap {
    private String root;
    private String defaultPackage = null;
    private static final char[] pkgSeparators = new char[]{'.', ':'};
    private static final char javaPkgSeparator = pkgSeparators[0];
    private Map pkg2NamespacesMap = new HashMap();

    private static String normalizePackageName(String pkg, char separator) {
        for (int i = 0; i < pkgSeparators.length; ++i) {
            pkg = pkg.replace(pkgSeparators[i], separator);
        }
        return pkg;
    }

    public Namespaces(String root2) {
        this.root = root2;
    }

    private Namespaces(Namespaces clone2) {
        super(clone2);
        this.root = clone2.root;
        this.defaultPackage = clone2.defaultPackage;
    }

    public Object clone() {
        return new Namespaces(this);
    }

    public String getCreate(String key) {
        return this.getCreate(key, true);
    }

    String getCreate(String key, boolean create) {
        if (this.defaultPackage != null) {
            this.put(key, this.defaultPackage);
            return this.defaultPackage;
        }
        String value2 = (String)super.get(key);
        if (value2 == null && create) {
            value2 = Namespaces.normalizePackageName(Utils.makePackageName(key), javaPkgSeparator);
            this.put(key, value2);
        }
        return value2;
    }

    public String getAsDir(String key) {
        if (this.defaultPackage != null) {
            return this.toDir(this.defaultPackage);
        }
        String pkg = (String)this.get(key);
        return this.toDir(pkg);
    }

    public String toDir(String pkg) {
        String dir2 = null;
        if (pkg != null) {
            pkg = Namespaces.normalizePackageName(pkg, File.separatorChar);
        }
        dir2 = this.root == null ? pkg : this.root + File.separatorChar + pkg;
        return dir2 == null ? "" : dir2 + File.separatorChar;
    }

    public void putAll(Map map2) {
        Iterator i = map2.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object key = entry.getKey();
            String pkg = (String)entry.getValue();
            pkg = this.javify(pkg);
            this.put(key, pkg);
        }
    }

    private String javify(String pkg) {
        StringTokenizer st = new StringTokenizer(pkg, ".");
        pkg = "";
        while (st.hasMoreTokens()) {
            String token2 = st.nextToken();
            if (JavaUtils.isJavaKeyword(token2)) {
                token2 = JavaUtils.makeNonJavaKeyword(token2);
            }
            pkg = pkg + token2;
            if (!st.hasMoreTokens()) continue;
            pkg = pkg + '.';
        }
        return pkg;
    }

    public void mkdir(String pkg) {
        String pkgDirString = this.toDir(pkg);
        File packageDir = new File(pkgDirString);
        packageDir.mkdirs();
    }

    public void setDefaultPackage(String defaultPackage) {
        this.defaultPackage = defaultPackage;
    }

    public Object put(Object key, Object value2) {
        Vector v = null;
        v = !this.pkg2NamespacesMap.containsKey(value2) ? new Vector() : (Vector)this.pkg2NamespacesMap.get(value2);
        if (!v.contains(key)) {
            v.add(key);
        }
        this.pkg2NamespacesMap.put(value2, v);
        return super.put(key, value2);
    }

    public Map getPkg2NamespacesMap() {
        return this.pkg2NamespacesMap;
    }
}

