/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.providers;

import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.components.script.Script;
import org.apache.axis.components.script.ScriptFactory;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.RPCElement;
import org.apache.axis.message.RPCHeaderParam;
import org.apache.axis.message.RPCParam;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.providers.BasicProvider;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.commons.logging.Log;

public class BSFProvider
extends BasicProvider {
    protected static Log log = LogFactory.getLog((class$org$apache$axis$providers$BSFProvider == null ? (class$org$apache$axis$providers$BSFProvider = BSFProvider.class$("org.apache.axis.providers.BSFProvider")) : class$org$apache$axis$providers$BSFProvider).getName());
    public static final String OPTION_LANGUAGE = "language";
    public static final String OPTION_SRC = "src";
    public static final String OPTION_SCRIPT = "script";
    static /* synthetic */ Class class$org$apache$axis$providers$BSFProvider;

    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            SOAPEnvelope resEnv;
            SOAPService service = msgContext.getService();
            String language = (String)service.getOption(OPTION_LANGUAGE);
            String scriptStr = (String)service.getOption(OPTION_SRC);
            if (log.isDebugEnabled()) {
                log.debug("Enter: BSFProvider.processMessage()");
            }
            OperationDesc operation = msgContext.getOperation();
            Vector bodies = msgContext.getRequestMessage().getSOAPEnvelope().getBodyElements();
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage("bodyElems00", "" + bodies.size()));
                log.debug(Messages.getMessage("bodyIs00", "" + bodies.get(0)));
            }
            RPCElement body = null;
            for (int bNum = 0; body == null && bNum < bodies.size(); ++bNum) {
                if (!(bodies.get(bNum) instanceof RPCElement)) {
                    ParameterDesc param2;
                    SOAPBodyElement bodyEl = (SOAPBodyElement)bodies.get(bNum);
                    if (!bodyEl.isRoot() || operation == null || bodyEl.getID() != null || (param2 = operation.getParameter(bNum)) == null) continue;
                    Object val = bodyEl.getValueAsType(param2.getTypeQName());
                    body = new RPCElement("", operation.getName(), new Object[]{val});
                    continue;
                }
                body = (RPCElement)bodies.get(bNum);
            }
            String methodName = body.getMethodName();
            Vector args = body.getParams();
            int numArgs = args.size();
            Object[] argValues = new Object[numArgs];
            for (int i = 0; i < numArgs; ++i) {
                RPCParam rpcParam = (RPCParam)args.get(i);
                Object value2 = rpcParam.getObjectValue();
                ParameterDesc paramDesc = rpcParam.getParamDesc();
                if (paramDesc != null && paramDesc.getJavaType() != null) {
                    Class sigType = paramDesc.getJavaType();
                    value2 = JavaUtils.convert(value2, sigType);
                    rpcParam.setObjectValue(value2);
                }
                argValues[i] = value2;
            }
            Script script = ScriptFactory.getScript();
            Object result2 = script.run(language, service.getName(), scriptStr, methodName, argValues);
            RPCElement resBody = new RPCElement(methodName + "Response");
            resBody.setPrefix(body.getPrefix());
            resBody.setNamespaceURI(body.getNamespaceURI());
            resBody.setEncodingStyle(msgContext.getEncodingStyle());
            Message resMsg = msgContext.getResponseMessage();
            if (resMsg == null) {
                resEnv = new SOAPEnvelope(msgContext.getSOAPConstants());
                resMsg = new Message(resEnv);
                msgContext.setResponseMessage(resMsg);
            } else {
                resEnv = resMsg.getSOAPEnvelope();
            }
            QName returnQName = operation.getReturnQName();
            if (returnQName == null) {
                returnQName = new QName("", methodName + "Return");
            }
            if (msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS) {
                returnQName = Constants.QNAME_RPC_RESULT;
            }
            RPCParam param3 = new RPCParam(returnQName, result2);
            param3.setParamDesc(operation.getReturnParamDesc());
            if (!operation.isReturnHeader()) {
                resBody.addParam(param3);
            } else {
                resEnv.addHeader(new RPCHeaderParam(param3));
            }
            resEnv.addBodyElement(resBody);
        }
        catch (Exception e) {
            entLog.debug(Messages.getMessage("toAxisFault00"), e);
            throw AxisFault.makeFault(e);
        }
    }

    public void initServiceDesc(SOAPService service, MessageContext msgContext) throws AxisFault {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

