/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.attachments;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis.AxisFault;
import org.apache.axis.utils.Messages;

public abstract class IncomingAttachmentStreams {
    private boolean _readyToGetNextStream = true;

    public abstract IncomingAttachmentInputStream getNextStream() throws AxisFault;

    public final boolean isReadyToGetNextStream() {
        return this._readyToGetNextStream;
    }

    protected final void setReadyToGetNextStream(boolean ready) {
        this._readyToGetNextStream = ready;
    }

    public final class IncomingAttachmentInputStream
    extends InputStream {
        private HashMap _headers = null;
        private InputStream _stream = null;

        public IncomingAttachmentInputStream(InputStream in) {
            this._stream = in;
        }

        public Map getHeaders() {
            return this._headers;
        }

        public void addHeader(String name, String value2) {
            if (this._headers == null) {
                this._headers = new HashMap();
            }
            this._headers.put(name, value2);
        }

        public String getHeader(String name) {
            Object header;
            block3: {
                block2: {
                    header = null;
                    if (this._headers == null) break block2;
                    Object v = this._headers.get(name);
                    header = v;
                    if (v != null) break block3;
                }
                return null;
            }
            return header.toString();
        }

        public String getContentId() {
            return this.getHeader("Content-Id");
        }

        public String getContentLocation() {
            return this.getHeader("Content-Location");
        }

        public String getContentType() {
            return this.getHeader("Content-Type");
        }

        public boolean markSupported() {
            return false;
        }

        public void reset() throws IOException {
            throw new IOException(Messages.getMessage("markNotSupported"));
        }

        public void mark(int readLimit) {
        }

        public int read() throws IOException {
            int retval = this._stream.read();
            IncomingAttachmentStreams.this.setReadyToGetNextStream(retval == -1);
            return retval;
        }

        public int read(byte[] b) throws IOException {
            int retval = this._stream.read(b);
            IncomingAttachmentStreams.this.setReadyToGetNextStream(retval == -1);
            return retval;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int retval = this._stream.read(b, off, len);
            IncomingAttachmentStreams.this.setReadyToGetNextStream(retval == -1);
            return retval;
        }
    }
}

