/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.graph;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.EdgeFactory;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.GraphHelper;
import org._3pq.jgrapht.UndirectedGraph;
import org._3pq.jgrapht.graph.AbstractGraph;
import org._3pq.jgrapht.graph.EdgeListFactory;

public abstract class AbstractBaseGraph
extends AbstractGraph
implements Graph,
Cloneable,
Serializable {
    private static final String LOOPS_NOT_ALLOWED = "loops not allowed";
    Map m_vertexMap;
    boolean m_allowingLoops;
    private Class m_factoryEdgeClass;
    private EdgeFactory m_edgeFactory;
    private EdgeListFactory m_edgeListFactory;
    private Set m_edgeSet;
    private transient Set m_unmodifiableEdgeSet = null;
    private transient Set m_unmodifiableVertexSet = null;
    private Specifics m_specifics;
    private boolean m_allowingMultipleEdges;

    public AbstractBaseGraph(EdgeFactory edgeFactory, boolean bl, boolean bl2) {
        if (edgeFactory == null) {
            throw new NullPointerException();
        }
        this.m_vertexMap = new LinkedHashMap();
        this.m_edgeSet = new LinkedHashSet();
        this.m_edgeFactory = edgeFactory;
        this.m_allowingLoops = bl2;
        this.m_allowingMultipleEdges = bl;
        this.m_specifics = this.createSpecifics();
        Edge edge = edgeFactory.createEdge(new Object(), new Object());
        this.m_factoryEdgeClass = edge.getClass();
        this.m_edgeListFactory = new ArrayListFactory();
    }

    public List getAllEdges(Object object, Object object2) {
        return this.m_specifics.getAllEdges(object, object2);
    }

    public boolean isAllowingLoops() {
        return this.m_allowingLoops;
    }

    public boolean isAllowingMultipleEdges() {
        return this.m_allowingMultipleEdges;
    }

    public Edge getEdge(Object object, Object object2) {
        return this.m_specifics.getEdge(object, object2);
    }

    public EdgeFactory getEdgeFactory() {
        return this.m_edgeFactory;
    }

    public void setEdgeListFactory(EdgeListFactory edgeListFactory) {
        this.m_edgeListFactory = edgeListFactory;
    }

    public Edge addEdge(Object object, Object object2) {
        this.assertVertexExist(object);
        this.assertVertexExist(object2);
        if (!this.m_allowingMultipleEdges && this.containsEdge(object, object2)) {
            return null;
        }
        if (!this.m_allowingLoops && object.equals(object2)) {
            throw new IllegalArgumentException(LOOPS_NOT_ALLOWED);
        }
        Edge edge = this.m_edgeFactory.createEdge(object, object2);
        if (this.containsEdge(edge)) {
            return null;
        }
        this.m_edgeSet.add(edge);
        this.m_specifics.addEdgeToTouchingVertices(edge);
        return edge;
    }

    public boolean addEdge(Edge edge) {
        if (edge == null) {
            throw new NullPointerException();
        }
        if (this.containsEdge(edge)) {
            return false;
        }
        Object object = edge.getSource();
        Object object2 = edge.getTarget();
        this.assertVertexExist(object);
        this.assertVertexExist(object2);
        this.assertCompatibleWithEdgeFactory(edge);
        if (!this.m_allowingMultipleEdges && this.containsEdge(object, object2)) {
            return false;
        }
        if (!this.m_allowingLoops && object.equals(object2)) {
            throw new IllegalArgumentException(LOOPS_NOT_ALLOWED);
        }
        this.m_edgeSet.add(edge);
        this.m_specifics.addEdgeToTouchingVertices(edge);
        return true;
    }

    public boolean addVertex(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (this.containsVertex(object)) {
            return false;
        }
        this.m_vertexMap.put(object, null);
        return true;
    }

    public Object clone() {
        try {
            AbstractBaseGraph abstractBaseGraph = (AbstractBaseGraph)super.clone();
            abstractBaseGraph.m_vertexMap = new LinkedHashMap();
            abstractBaseGraph.m_edgeSet = new LinkedHashSet();
            abstractBaseGraph.m_factoryEdgeClass = this.m_factoryEdgeClass;
            abstractBaseGraph.m_edgeFactory = this.m_edgeFactory;
            abstractBaseGraph.m_unmodifiableEdgeSet = null;
            abstractBaseGraph.m_unmodifiableVertexSet = null;
            abstractBaseGraph.m_specifics = abstractBaseGraph.createSpecifics();
            GraphHelper.addGraph(abstractBaseGraph, this);
            return abstractBaseGraph;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            throw new RuntimeException();
        }
    }

    public boolean containsEdge(Edge edge) {
        return this.m_edgeSet.contains(edge);
    }

    public boolean containsVertex(Object object) {
        return this.m_vertexMap.containsKey(object);
    }

    public int degreeOf(Object object) {
        return this.m_specifics.degreeOf(object);
    }

    public Set edgeSet() {
        if (this.m_unmodifiableEdgeSet == null) {
            this.m_unmodifiableEdgeSet = Collections.unmodifiableSet(this.m_edgeSet);
        }
        return this.m_unmodifiableEdgeSet;
    }

    public List edgesOf(Object object) {
        return this.m_specifics.edgesOf(object);
    }

    public int inDegreeOf(Object object) {
        return this.m_specifics.inDegreeOf(object);
    }

    public List incomingEdgesOf(Object object) {
        return this.m_specifics.incomingEdgesOf(object);
    }

    public int outDegreeOf(Object object) {
        return this.m_specifics.outDegreeOf(object);
    }

    public List outgoingEdgesOf(Object object) {
        return this.m_specifics.outgoingEdgesOf(object);
    }

    public Edge removeEdge(Object object, Object object2) {
        Edge edge = this.getEdge(object, object2);
        if (edge != null) {
            this.m_specifics.removeEdgeFromTouchingVertices(edge);
            this.m_edgeSet.remove(edge);
        }
        return edge;
    }

    public boolean removeEdge(Edge edge) {
        if (this.containsEdge(edge)) {
            this.m_specifics.removeEdgeFromTouchingVertices(edge);
            this.m_edgeSet.remove(edge);
            return true;
        }
        return false;
    }

    public boolean removeVertex(Object object) {
        if (this.containsVertex(object)) {
            List list2 = this.edgesOf(object);
            Edge[] edgeArray = new Edge[list2.size()];
            list2.toArray(edgeArray);
            this.removeAllEdges(edgeArray);
            this.m_vertexMap.remove(object);
            return true;
        }
        return false;
    }

    public Set vertexSet() {
        if (this.m_unmodifiableVertexSet == null) {
            this.m_unmodifiableVertexSet = Collections.unmodifiableSet(this.m_vertexMap.keySet());
        }
        return this.m_unmodifiableVertexSet;
    }

    private boolean assertCompatibleWithEdgeFactory(Edge edge) {
        if (edge == null) {
            throw new NullPointerException();
        }
        if (!this.m_factoryEdgeClass.isInstance(edge)) {
            throw new ClassCastException("incompatible edge class");
        }
        return true;
    }

    private Specifics createSpecifics() {
        if (this instanceof DirectedGraph) {
            return new DirectedSpecifics();
        }
        if (this instanceof UndirectedGraph) {
            return new UndirectedSpecifics();
        }
        throw new IllegalArgumentException("must be instance of either DirectedGraph or UndirectedGraph");
    }

    private class UndirectedSpecifics
    extends Specifics {
        private static final String NOT_IN_UNDIRECTED_GRAPH = "no such operation in an undirected graph";

        private UndirectedSpecifics() {
        }

        public List getAllEdges(Object object, Object object2) {
            ArrayList<Edge> arrayList = null;
            if (AbstractBaseGraph.this.containsVertex(object) && AbstractBaseGraph.this.containsVertex(object2)) {
                arrayList = new ArrayList<Edge>();
                Iterator iterator2 = this.getEdgeContainer((Object)object).m_vertexEdges.iterator();
                while (iterator2.hasNext()) {
                    boolean bl;
                    Edge edge = (Edge)iterator2.next();
                    boolean bl2 = object.equals(edge.getSource()) && object2.equals(edge.getTarget());
                    boolean bl3 = bl = object.equals(edge.getTarget()) && object2.equals(edge.getSource());
                    if (!bl2 && !bl) continue;
                    arrayList.add(edge);
                }
            }
            return arrayList;
        }

        public Edge getEdge(Object object, Object object2) {
            if (AbstractBaseGraph.this.containsVertex(object) && AbstractBaseGraph.this.containsVertex(object2)) {
                Iterator iterator2 = this.getEdgeContainer((Object)object).m_vertexEdges.iterator();
                while (iterator2.hasNext()) {
                    boolean bl;
                    Edge edge = (Edge)iterator2.next();
                    boolean bl2 = object.equals(edge.getSource()) && object2.equals(edge.getTarget());
                    boolean bl3 = bl = object.equals(edge.getTarget()) && object2.equals(edge.getSource());
                    if (!bl2 && !bl) continue;
                    return edge;
                }
            }
            return null;
        }

        public void addEdgeToTouchingVertices(Edge edge) {
            Object object = edge.getSource();
            Object object2 = edge.getTarget();
            this.getEdgeContainer(object).addEdge(edge);
            if (object != object2) {
                this.getEdgeContainer(object2).addEdge(edge);
            }
        }

        public int degreeOf(Object object) {
            if (AbstractBaseGraph.this.m_allowingLoops) {
                int n = 0;
                List list2 = this.getEdgeContainer((Object)object).m_vertexEdges;
                Iterator iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    Edge edge = (Edge)iterator2.next();
                    if (edge.getSource().equals(edge.getTarget())) {
                        n += 2;
                        continue;
                    }
                    ++n;
                }
                return n;
            }
            return this.getEdgeContainer(object).edgeCount();
        }

        public List edgesOf(Object object) {
            return this.getEdgeContainer(object).getUnmodifiableVertexEdges();
        }

        public int inDegreeOf(Object object) {
            throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
        }

        public List incomingEdgesOf(Object object) {
            throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
        }

        public int outDegreeOf(Object object) {
            throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
        }

        public List outgoingEdgesOf(Object object) {
            throw new UnsupportedOperationException(NOT_IN_UNDIRECTED_GRAPH);
        }

        public void removeEdgeFromTouchingVertices(Edge edge) {
            Object object = edge.getSource();
            Object object2 = edge.getTarget();
            this.getEdgeContainer(object).removeEdge(edge);
            if (object != object2) {
                this.getEdgeContainer(object2).removeEdge(edge);
            }
        }

        private UndirectedEdgeContainer getEdgeContainer(Object object) {
            AbstractBaseGraph.this.assertVertexExist(object);
            UndirectedEdgeContainer undirectedEdgeContainer = (UndirectedEdgeContainer)AbstractBaseGraph.this.m_vertexMap.get(object);
            if (undirectedEdgeContainer == null) {
                undirectedEdgeContainer = new UndirectedEdgeContainer(AbstractBaseGraph.this.m_edgeListFactory, object);
                AbstractBaseGraph.this.m_vertexMap.put(object, undirectedEdgeContainer);
            }
            return undirectedEdgeContainer;
        }
    }

    private static class UndirectedEdgeContainer
    implements Serializable {
        List m_vertexEdges;
        private transient List m_unmodifiableVertexEdges = null;

        UndirectedEdgeContainer(EdgeListFactory edgeListFactory, Object object) {
            this.m_vertexEdges = edgeListFactory.createEdgeList(object);
        }

        public List getUnmodifiableVertexEdges() {
            if (this.m_unmodifiableVertexEdges == null) {
                this.m_unmodifiableVertexEdges = Collections.unmodifiableList(this.m_vertexEdges);
            }
            return this.m_unmodifiableVertexEdges;
        }

        public void addEdge(Edge edge) {
            this.m_vertexEdges.add(edge);
        }

        public int edgeCount() {
            return this.m_vertexEdges.size();
        }

        public void removeEdge(Edge edge) {
            this.m_vertexEdges.remove(edge);
        }
    }

    private class DirectedSpecifics
    extends Specifics {
        private static final String NOT_IN_DIRECTED_GRAPH = "no such operation in a directed graph";

        private DirectedSpecifics() {
        }

        public List getAllEdges(Object object, Object object2) {
            ArrayList<Edge> arrayList = null;
            if (AbstractBaseGraph.this.containsVertex(object) && AbstractBaseGraph.this.containsVertex(object2)) {
                arrayList = new ArrayList<Edge>();
                DirectedEdgeContainer directedEdgeContainer = this.getEdgeContainer(object);
                Iterator iterator2 = directedEdgeContainer.m_outgoing.iterator();
                while (iterator2.hasNext()) {
                    Edge edge = (Edge)iterator2.next();
                    if (!edge.getTarget().equals(object2)) continue;
                    arrayList.add(edge);
                }
            }
            return arrayList;
        }

        public Edge getEdge(Object object, Object object2) {
            if (AbstractBaseGraph.this.containsVertex(object) && AbstractBaseGraph.this.containsVertex(object2)) {
                DirectedEdgeContainer directedEdgeContainer = this.getEdgeContainer(object);
                Iterator iterator2 = directedEdgeContainer.m_outgoing.iterator();
                while (iterator2.hasNext()) {
                    Edge edge = (Edge)iterator2.next();
                    if (!edge.getTarget().equals(object2)) continue;
                    return edge;
                }
            }
            return null;
        }

        public void addEdgeToTouchingVertices(Edge edge) {
            Object object = edge.getSource();
            Object object2 = edge.getTarget();
            this.getEdgeContainer(object).addOutgoingEdge(edge);
            this.getEdgeContainer(object2).addIncomingEdge(edge);
        }

        public int degreeOf(Object object) {
            throw new UnsupportedOperationException(NOT_IN_DIRECTED_GRAPH);
        }

        public List edgesOf(Object object) {
            ArrayList arrayList = new ArrayList(this.getEdgeContainer((Object)object).m_incoming);
            arrayList.addAll(this.getEdgeContainer((Object)object).m_outgoing);
            if (AbstractBaseGraph.this.m_allowingLoops) {
                List list2 = this.getAllEdges(object, object);
                int n = 0;
                while (n < arrayList.size()) {
                    Object e = arrayList.get(n);
                    if (list2.contains(e)) {
                        arrayList.remove(n);
                        list2.remove(e);
                        continue;
                    }
                    ++n;
                }
            }
            return arrayList;
        }

        public int inDegreeOf(Object object) {
            return this.getEdgeContainer((Object)object).m_incoming.size();
        }

        public List incomingEdgesOf(Object object) {
            return this.getEdgeContainer(object).getUnmodifiableIncomingEdges();
        }

        public int outDegreeOf(Object object) {
            return this.getEdgeContainer((Object)object).m_outgoing.size();
        }

        public List outgoingEdgesOf(Object object) {
            return this.getEdgeContainer(object).getUnmodifiableOutgoingEdges();
        }

        public void removeEdgeFromTouchingVertices(Edge edge) {
            Object object = edge.getSource();
            Object object2 = edge.getTarget();
            this.getEdgeContainer(object).removeOutgoingEdge(edge);
            this.getEdgeContainer(object2).removeIncomingEdge(edge);
        }

        private DirectedEdgeContainer getEdgeContainer(Object object) {
            AbstractBaseGraph.this.assertVertexExist(object);
            DirectedEdgeContainer directedEdgeContainer = (DirectedEdgeContainer)AbstractBaseGraph.this.m_vertexMap.get(object);
            if (directedEdgeContainer == null) {
                directedEdgeContainer = new DirectedEdgeContainer(AbstractBaseGraph.this.m_edgeListFactory, object);
                AbstractBaseGraph.this.m_vertexMap.put(object, directedEdgeContainer);
            }
            return directedEdgeContainer;
        }
    }

    private static class DirectedEdgeContainer
    implements Serializable {
        List m_incoming;
        List m_outgoing;
        private transient List m_unmodifiableIncoming = null;
        private transient List m_unmodifiableOutgoing = null;

        DirectedEdgeContainer(EdgeListFactory edgeListFactory, Object object) {
            this.m_incoming = edgeListFactory.createEdgeList(object);
            this.m_outgoing = edgeListFactory.createEdgeList(object);
        }

        public List getUnmodifiableIncomingEdges() {
            if (this.m_unmodifiableIncoming == null) {
                this.m_unmodifiableIncoming = Collections.unmodifiableList(this.m_incoming);
            }
            return this.m_unmodifiableIncoming;
        }

        public List getUnmodifiableOutgoingEdges() {
            if (this.m_unmodifiableOutgoing == null) {
                this.m_unmodifiableOutgoing = Collections.unmodifiableList(this.m_outgoing);
            }
            return this.m_unmodifiableOutgoing;
        }

        public void addIncomingEdge(Edge edge) {
            this.m_incoming.add(edge);
        }

        public void addOutgoingEdge(Edge edge) {
            this.m_outgoing.add(edge);
        }

        public void removeIncomingEdge(Edge edge) {
            this.m_incoming.remove(edge);
        }

        public void removeOutgoingEdge(Edge edge) {
            this.m_outgoing.remove(edge);
        }
    }

    private static class ArrayListFactory
    implements EdgeListFactory {
        private ArrayListFactory() {
        }

        public List createEdgeList(Object object) {
            return new ArrayList(1);
        }
    }

    private abstract class Specifics
    implements Serializable {
        private Specifics() {
        }

        public abstract List getAllEdges(Object var1, Object var2);

        public abstract Edge getEdge(Object var1, Object var2);

        public abstract void addEdgeToTouchingVertices(Edge var1);

        public abstract int degreeOf(Object var1);

        public abstract List edgesOf(Object var1);

        public abstract int inDegreeOf(Object var1);

        public abstract List incomingEdgesOf(Object var1);

        public abstract int outDegreeOf(Object var1);

        public abstract List outgoingEdgesOf(Object var1);

        public abstract void removeEdgeFromTouchingVertices(Edge var1);
    }
}

