/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.BinaryGISModelReader;
import opennlp.maxent.io.BinaryGISModelWriter;
import opennlp.uima.util.MaxentModelResource;
import org.apache.uima.UimaContext;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;

public final class OpennlpUtil {
    private OpennlpUtil() {
    }

    public static GISModel createModel(InputStream in) throws ResourceInitializationException {
        try {
            GISModel model = new BinaryGISModelReader(new DataInputStream(new GZIPInputStream(in))).getModel();
            return model;
        }
        catch (IOException e) {
            throw new ResourceInitializationException("opennlp.uima.util.ExceptionMessages", "io_error_model_reading", new Object[]{e.getMessage()}, e);
        }
    }

    public static MaxentModel createModel(UimaContext context, String modelName) throws ResourceInitializationException {
        try {
            MaxentModelResource modelResource = (MaxentModelResource)context.getResourceObject(modelName);
            return modelResource.getModel();
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException(e);
        }
    }

    public static void serialize(GISModel model, OutputStream out) throws IOException {
        BinaryGISModelWriter writer = new BinaryGISModelWriter(model, new DataOutputStream(new GZIPOutputStream(out)));
        writer.persist();
    }
}

