/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import opennlp.uima.util.AnnotationIteratorPair;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationComboIterator
implements Iterable<AnnotationIteratorPair>,
Iterator<AnnotationIteratorPair> {
    private final FSIterator upperIt;
    private final FSIterator lowerIt;
    private int upperBegin;
    private int upperEnd;
    private boolean nextLowerChecked = false;
    private boolean nextLowerAvailable = false;

    public AnnotationComboIterator(CAS cas, Type upper, Type lower) {
        this.upperIt = cas.getAnnotationIndex(upper).iterator();
        this.lowerIt = cas.getAnnotationIndex(lower).iterator();
        this.upperIt.moveToFirst();
        this.lowerIt.moveToFirst();
        if (this.upperIt.isValid()) {
            AnnotationFS upperFS = (AnnotationFS)this.upperIt.get();
            this.upperBegin = upperFS.getBegin();
            this.upperEnd = upperFS.getEnd();
        } else {
            this.nextLowerChecked = true;
        }
    }

    @Override
    public boolean hasNext() {
        return this.upperIt.hasNext();
    }

    @Override
    public AnnotationIteratorPair next() {
        if (!this.upperIt.hasNext()) {
            throw new NoSuchElementException();
        }
        AnnotationFS upperFS = (AnnotationFS)this.upperIt.next();
        this.upperBegin = upperFS.getBegin();
        this.upperEnd = upperFS.getEnd();
        this.nextLowerChecked = false;
        return new AnnotationIteratorPair(upperFS, new AnnotationIterator());
    }

    @Override
    public Iterator<AnnotationIteratorPair> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AnnotationIterator
    implements Iterable<AnnotationFS>,
    Iterator<AnnotationFS> {
        private AnnotationIterator() {
        }

        public AnnotationIterator iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (AnnotationComboIterator.this.nextLowerChecked) {
                return AnnotationComboIterator.this.nextLowerAvailable;
            }
            AnnotationComboIterator.this.nextLowerChecked = true;
            AnnotationComboIterator.this.nextLowerAvailable = false;
            if (AnnotationComboIterator.this.lowerIt.isValid()) {
                AnnotationFS lowerFS = (AnnotationFS)AnnotationComboIterator.this.lowerIt.get();
                int lowerBegin = lowerFS.getBegin();
                while (lowerBegin < AnnotationComboIterator.this.upperBegin) {
                    AnnotationComboIterator.this.lowerIt.moveToNext();
                    if (AnnotationComboIterator.this.lowerIt.isValid()) {
                        lowerFS = (AnnotationFS)AnnotationComboIterator.this.lowerIt.next();
                        lowerBegin = lowerFS.getBegin();
                        continue;
                    }
                    return false;
                }
                if (AnnotationComboIterator.this.upperEnd >= lowerFS.getEnd()) {
                    AnnotationComboIterator.this.nextLowerAvailable = true;
                }
            }
            return AnnotationComboIterator.this.nextLowerAvailable;
        }

        @Override
        public AnnotationFS next() {
            if (AnnotationComboIterator.this.nextLowerChecked ? !AnnotationComboIterator.this.nextLowerAvailable : !this.hasNext()) {
                throw new NoSuchElementException();
            }
            AnnotationComboIterator.this.nextLowerChecked = false;
            AnnotationFS rv = (AnnotationFS)AnnotationComboIterator.this.lowerIt.get();
            AnnotationComboIterator.this.lowerIt.moveToNext();
            return rv;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

