/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.sentdetect;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.tools.sentdetect.SDEventStream;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.util.DataStreamBuilder;
import opennlp.uima.util.CasConsumerUtil;
import opennlp.uima.util.OpennlpUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.ProcessTrace;

public final class SentenceDetectorTrainer
extends CasConsumer_ImplBase {
    private DataStreamBuilder mSentenceEvents;
    private Type mSentenceType;
    private String mModelName;
    private Logger mLogger;
    private UimaContext mContext;

    public void initialize() throws ResourceInitializationException {
        this.mContext = this.getUimaContext();
        this.mSentenceEvents = new DataStreamBuilder();
        this.mLogger = this.mContext.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP SentenceDetector trainer.");
        }
        this.mModelName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.MODEL_PARAMETER);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
        String sentenceTypeName = CasConsumerUtil.getRequiredStringParameter(this.mContext, UimaUtil.SENTENCE_TYPE_PARAMETER);
        this.mSentenceType = CasConsumerUtil.getType(typeSystem, sentenceTypeName);
    }

    public void processCas(CAS cas) {
        AnnotationIndex<AnnotationFS> sentenceIndex = cas.getAnnotationIndex(this.mSentenceType);
        Object[] sentArray = new String[sentenceIndex.size()];
        int i = 0;
        for (AnnotationFS sentenceAnnotation : sentenceIndex) {
            sentArray[i++] = sentenceAnnotation.getCoveredText();
        }
        this.mSentenceEvents.add(sentArray);
    }

    public void collectionProcessComplete(ProcessTrace trace) throws ResourceProcessException, IOException {
        GIS.PRINT_MESSAGES = true;
        GISModel sentenceModel = SentenceDetectorME.train(new SDEventStream(this.mSentenceEvents), 100, 5);
        this.mSentenceEvents = null;
        File modelFile = new File(this.getUimaContextAdmin().getResourceManager().getDataPath() + File.separatorChar + this.mModelName);
        OpennlpUtil.serialize(sentenceModel, new FileOutputStream(modelFile));
    }

    public boolean isStateless() {
        return false;
    }

    public void destroy() {
        this.mSentenceEvents = null;
    }
}

